/*********************************************************************
* Copyright (c) 2005, 2019 SAP SE
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which is available at https://www.eclipse.org/legal/epl-2.0/
*
* Contributors:
*    SAP SE - initial API, implementation and documentation
*
* SPDX-License-Identifier: EPL-2.0
**********************************************************************/
package org.eclipse.graphiti.features.context;

import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

/**
 * The Interface IAddContext.
 * 
 * This context contains the information, needed to let a feature add a
 * pictogram element, which has to be linked to any domain model element, to a
 * container shape.
 * 
 * @see PictogramElement
 * @see ContainerShape
 * @noimplement This interface is not intended to be implemented by clients.
 * @noextend This interface is not intended to be extended by clients.
 */
public interface IAddContext extends IAreaContext, ITargetContext, ITargetConnectionContext, ITargetConnectionDecoratorContext {

	/**
	 * A pictogram element has to be added. This pictogram element has to link
	 * to a domain model element.
	 * 
	 * @return instance of a domain model element
	 */
	Object getNewObject();

}