/**
 * Copyright (c) 2016 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.processors;

import java.io.PrintWriter;
import java.io.StringWriter;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.about.ISystemSummarySection;

public class ConfigurationInfo {

    // should be one of:
    // - Current Install Configuration
    // - Platform Details
    // - Security Configuration
    @Nullable
    public static String getConfiguration(String sectionTitle) {
        ISystemSummarySection section = findBySectionTitle(sectionTitle);
        if (section == null) {
            return null;
        }
        StringWriter w = new StringWriter();
        PrintWriter p = new PrintWriter(w);
        section.write(p);
        return w.toString();
    }

    private static ISystemSummarySection findBySectionTitle(String sectionTitle) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(PlatformUI.PLUGIN_ID,
                "systemSummarySections");
        for (IConfigurationElement element : elements) {
            if (sectionTitle.equalsIgnoreCase(element.getAttribute("sectionTitle"))) {
                try {
                    // return (ISystemSummarySection) WorkbenchPlugin.createExtension(element, "class");
                    return (ISystemSummarySection) element.createExecutableExtension("class");
                } catch (CoreException e) {
                    return null;
                }
            }
        }
        return null;
    }
}
