/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core.filters;

import static org.apache.commons.lang3.StringUtils.isEmpty;
import static org.eclipse.epp.logging.aeri.core.Constants.*;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.Nullable;

import com.google.common.base.Predicate;

public class EclipseBuildIdFilter implements Predicate<IStatus> {

    @Override
    public boolean apply(@Nullable IStatus input) {
        return !isEmpty(System.getProperty(SYSPROP_ECLIPSE_BUILD_ID)) || !isEmpty(System.getProperty(SYSPROP_BUILD_ID));
    }
}
