/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.apache.derby.internal.ui.connection.drivers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.apache.derby.internal.ui.connection.drivers.Messages;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.internal.ui.DelimitedStringList;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributor;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class DerbyEmbeddedDriverUIContributor
implements IDriverUIContributor,
Listener,
ModifyListener {
    private static final String CUI_NEWCW_GENERAL_TAB_UI_ = Messages.getString("DerbyEmbeddedDriverUIContributor.general.tab");
    private static final String CUI_NEWCW_OPTIONAL_TAB_UI_ = Messages.getString("DerbyEmbeddedDriverUIContributor.optional.tab");
    private static final String CUI_NEWCW_DBLOCATION_LBL_UI_ = Messages.getString("DerbyEmbeddedDriverUIContributor.0");
    private static final String CUI_NEWCW_DBBROWSE_BTN_UI_ = Messages.getString("DerbyEmbeddedDriverUIContributor.1");
    private static final String CUI_NEWCW_CREATEDB_BTN_UI_ = Messages.getString("DerbyEmbeddedDriverUIContributor.2");
    private static final String CUI_NEWCW_UPGRADEDB_BTN_UI_ = Messages.getString("DerbyEmbeddedDriverUIContributor.3");
    private static final String CUI_NEWCW_USERNAME_LBL_UI_ = Messages.getString("DerbyEmbeddedDriverUIContributor.userName.label");
    private static final String CUI_NEWCW_PASSWORD_LBL_UI_ = Messages.getString("DerbyEmbeddedDriverUIContributor.password.label");
    private static final String CUI_NEWCW_SAVE_PASSWORD_LBL_UI_ = Messages.getString("DerbyEmbeddedDriverUIContributor.persistpassword.label");
    private static final String CUI_NEWCW_CONNECTIONURL_LBL_UI_ = Messages.getString("DerbyEmbeddedDriverUIContributor.url.label");
    private static final String CUI_NEWCW_OPTIONAL_PROPERTIES_LBL_UI_ = Messages.getString("DerbyEmbeddedDriverUIContributor.optionalproperties.label");
    private static final String CUI_NEWCW_DRIVER_NAME_SUMMARY_DATA_TEXT_ = Messages.getString("DerbyEmbeddedDriverUIContributor.summary.driverName.label");
    private static final String CUI_NEWCW_DATABASE_LOCATION_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_DATABASE_LOCATION_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_ = Messages.getString("DerbyEmbeddedDriverUIContributor.summary.userName.label");
    private static final String CUI_NEWCW_URL_SUMMARY_DATA_TEXT_ = Messages.getString("DerbyEmbeddedDriverUIContributor.summary.url.label");
    private static final String CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_CREATE_DATABASE_SUMMARY_DATA_TEXT_ = TextProcessor.process((String)Messages.getString("CUI_NEWCW_CREATE_DATABASE_SUMMARY_DATA_TEXT_"));
    private static final String CUI_NEWCW_UPGRADE_DATABASE_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_UPGRADE_DATABASE_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_OPTIONAL_CONNECTION_PROPERTIES_SUMMARY_DATA_TEXT_ = Messages.getString("DerbyEmbeddedDriverUIContributor.summary.connProps.label");
    private static final String CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_FILE_BROWSER_TITLE_TEXT_ = Messages.getString("DerbyEmbeddedDriverUIContributor.FileDialog.title.filebrowse");
    private static final String CUI_NEWCW_FILE_BROWSER_MESSAGE_TEXT_ = Messages.getString("DerbyEmbeddedDriverUIContributor.FileDialog.msg.filebrowse");
    private static final String CUI_NEWCW_VALIDATE_DBLOCATION_REQ_UI_ = Messages.getString("CUI_NEWCW_VALIDATE_DBLOCATION_REQ_UI_");
    private static final String CREATE_EQUALS_TRUE_TEXT = "create=true";
    private static final String UPGRADE_EQUALS_TRUE_TEXT = "upgrade=true";
    private ScrolledComposite parentComposite;
    private Label databaseLocationLabel;
    private Combo databaseLocationCombo;
    private Button browseDatabaseLocation;
    private Button createCheck;
    private Button upgradeCheck;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private Button savePasswordButton;
    private Label urlLabel;
    private Text urlText;
    private DelimitedStringList optionalConnectionProperties;
    private DialogPage parentPage;
    private IDriverUIContributorInformation contributorInformation;
    private Properties properties;
    private String databaseName;
    private boolean isReadOnly = false;

    public boolean determineContributorCompletion() {
        boolean isComplete = true;
        if (this.databaseLocationCombo.getText().equals("")) {
            this.parentPage.setErrorMessage(CUI_NEWCW_VALIDATE_DBLOCATION_REQ_UI_);
            isComplete = false;
        }
        if (isComplete) {
            this.parentPage.setErrorMessage(null);
        }
        return isComplete;
    }

    public Composite getContributedDriverUI(Composite parent, boolean isReadOnly) {
        if (this.parentComposite == null || this.parentComposite.isDisposed() || this.isReadOnly != isReadOnly) {
            this.isReadOnly = isReadOnly;
            int additionalStyles = 0;
            if (isReadOnly) {
                additionalStyles = 8;
            }
            this.parentComposite = new ScrolledComposite(parent, 768);
            this.parentComposite.setExpandHorizontal(true);
            this.parentComposite.setExpandVertical(true);
            this.parentComposite.setLayout((Layout)new GridLayout());
            TabFolder baseComposite = new TabFolder((Composite)this.parentComposite, 128);
            TabItem generalTab = new TabItem(baseComposite, 0);
            generalTab.setText(CUI_NEWCW_GENERAL_TAB_UI_);
            TabItem optionalTab = new TabItem(baseComposite, 0);
            optionalTab.setText(CUI_NEWCW_OPTIONAL_TAB_UI_);
            Composite generalComposite = new Composite((Composite)baseComposite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            generalComposite.setLayout((Layout)layout);
            generalTab.setControl((Control)generalComposite);
            Composite optionalComposite = new Composite((Composite)baseComposite, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            optionalComposite.setLayout((Layout)layout);
            optionalTab.setControl((Control)optionalComposite);
            this.databaseLocationLabel = new Label(generalComposite, 0);
            this.databaseLocationLabel.setText(CUI_NEWCW_DBLOCATION_LBL_UI_);
            Composite textAndBrowseComposite = new Composite(generalComposite, 0);
            GridLayout subCompositeLayout = new GridLayout(2, false);
            subCompositeLayout.marginLeft = -5;
            subCompositeLayout.marginRight = -5;
            subCompositeLayout.marginTop = -5;
            subCompositeLayout.marginBottom = -5;
            textAndBrowseComposite.setLayout((Layout)subCompositeLayout);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            textAndBrowseComposite.setLayoutData((Object)gd);
            this.databaseLocationCombo = new Combo(textAndBrowseComposite, 2052);
            this.databaseLocationCombo.setEnabled(!isReadOnly);
            gd = new GridData(768);
            this.databaseLocationCombo.setLayoutData((Object)gd);
            this.browseDatabaseLocation = new Button(textAndBrowseComposite, 8);
            this.browseDatabaseLocation.setEnabled(!isReadOnly);
            this.browseDatabaseLocation.setText(CUI_NEWCW_DBBROWSE_BTN_UI_);
            this.browseDatabaseLocation.setLayoutData((Object)new GridData(128));
            this.browseDatabaseLocation.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DerbyEmbeddedDriverUIContributor.this.browseForDBFolder();
                }
            });
            this.usernameLabel = new Label(generalComposite, 0);
            this.usernameLabel.setText(CUI_NEWCW_USERNAME_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.usernameLabel.setLayoutData((Object)gd);
            this.usernameText = new Text(generalComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.usernameText.setLayoutData((Object)gd);
            this.passwordLabel = new Label(generalComposite, 0);
            this.passwordLabel.setText(CUI_NEWCW_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.passwordLabel.setLayoutData((Object)gd);
            this.passwordText = new Text(generalComposite, 0x400804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.passwordText.setLayoutData((Object)gd);
            this.urlLabel = new Label(generalComposite, 0);
            this.urlLabel.setText(CUI_NEWCW_CONNECTIONURL_LBL_UI_);
            this.urlText = new Text(generalComposite, 2060);
            gd = new GridData(256);
            gd.horizontalSpan = 2;
            this.urlText.setLayoutData((Object)gd);
            this.createCheck = new Button(generalComposite, 32);
            this.createCheck.setText(CUI_NEWCW_CREATEDB_BTN_UI_);
            this.createCheck.setSelection(true);
            gd = new GridData();
            gd.horizontalSpan = 3;
            this.createCheck.setLayoutData((Object)gd);
            this.upgradeCheck = new Button(generalComposite, 32);
            this.upgradeCheck.setText(CUI_NEWCW_UPGRADEDB_BTN_UI_);
            this.upgradeCheck.setSelection(false);
            gd = new GridData();
            gd.horizontalSpan = 3;
            this.upgradeCheck.setLayoutData((Object)gd);
            this.savePasswordButton = new Button(generalComposite, 32);
            this.savePasswordButton.setText(CUI_NEWCW_SAVE_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 3;
            gd.grabExcessHorizontalSpace = true;
            this.savePasswordButton.setLayoutData((Object)gd);
            Label optionalPropertiesLabel = new Label(optionalComposite, 0);
            GridData gdata = new GridData(768);
            gdata.horizontalSpan = 2;
            optionalPropertiesLabel.setLayoutData((Object)gdata);
            optionalPropertiesLabel.setText(CUI_NEWCW_OPTIONAL_PROPERTIES_LBL_UI_);
            this.optionalConnectionProperties = new DelimitedStringList(optionalComposite, 0, isReadOnly);
            gdata = new GridData(768);
            gdata.horizontalSpan = 2;
            this.optionalConnectionProperties.setLayoutData((Object)gdata);
            this.parentComposite.setContent((Control)baseComposite);
            this.parentComposite.setMinSize(baseComposite.computeSize(-1, -1));
            this.initialize();
        }
        return this.parentComposite;
    }

    private void initialize() {
        this.updateURL();
        this.addListeners();
    }

    public List getSummaryData() {
        ArrayList<String[]> summaryData = new ArrayList<String[]>();
        String driverID = this.properties.getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
        DriverInstance driverInstance = DriverManager.getInstance().getDriverInstanceByID(driverID);
        summaryData.add(new String[]{CUI_NEWCW_DRIVER_NAME_SUMMARY_DATA_TEXT_, driverInstance.getName()});
        summaryData.add(new String[]{CUI_NEWCW_DATABASE_LOCATION_SUMMARY_DATA_TEXT_, this.databaseLocationCombo.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_, this.usernameText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_URL_SUMMARY_DATA_TEXT_, this.urlText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_CREATE_DATABASE_SUMMARY_DATA_TEXT_, this.createCheck.getSelection() ? CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ : CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_});
        summaryData.add(new String[]{CUI_NEWCW_UPGRADE_DATABASE_SUMMARY_DATA_TEXT_, this.upgradeCheck.getSelection() ? CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ : CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_});
        summaryData.add(new String[]{CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_, this.savePasswordButton.getSelection() ? CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ : CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_});
        summaryData.add(new String[]{CUI_NEWCW_OPTIONAL_CONNECTION_PROPERTIES_SUMMARY_DATA_TEXT_, this.optionalConnectionProperties.getSelection()});
        return summaryData;
    }

    public void loadProperties() {
        String connectionProperties;
        String savePassword;
        String password;
        this.removeListeners();
        DerbyEmbeddedJDBCURL url = new DerbyEmbeddedJDBCURL(this.properties.getProperty("org.eclipse.datatools.connectivity.db.URL"));
        this.databaseLocationCombo.setText(url.getNode());
        this.updateDatabaseName();
        String username = this.properties.getProperty("org.eclipse.datatools.connectivity.db.username");
        if (username != null) {
            this.usernameText.setText(username);
        }
        if ((password = this.properties.getProperty("org.eclipse.datatools.connectivity.db.password")) != null) {
            this.passwordText.setText(password);
        }
        if ((savePassword = this.properties.getProperty("org.eclipse.datatools.connectivity.db.savePWD")) != null && Boolean.valueOf(savePassword) == Boolean.TRUE) {
            this.savePasswordButton.setSelection(true);
        }
        if (url.getProperties().indexOf(CREATE_EQUALS_TRUE_TEXT) <= -1) {
            this.createCheck.setSelection(false);
        }
        if (url.getProperties().indexOf(UPGRADE_EQUALS_TRUE_TEXT) > -1) {
            this.upgradeCheck.setSelection(true);
        }
        if ((connectionProperties = this.properties.getProperty("org.eclipse.datatools.connectivity.db.connectionProperties")) != null) {
            this.optionalConnectionProperties.setSelection(connectionProperties);
        }
        this.updateURL();
        this.addListeners();
        this.setConnectionInformation();
    }

    protected void updateDatabaseName() {
        if (this.databaseLocationCombo.getText() != null && !this.databaseLocationCombo.getText().equals("")) {
            this.databaseName = this.databaseLocationCombo.getText().substring(this.databaseLocationCombo.getText().lastIndexOf(File.separator) + 1);
        }
    }

    public void setDialogPage(DialogPage parentPage) {
        this.parentPage = parentPage;
    }

    public void setConnectionInformation() {
        this.updateDatabaseName();
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.databaseName", this.databaseName);
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.password", this.passwordText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(this.savePasswordButton.getSelection()));
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.username", this.usernameText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.URL", this.urlText.getText().trim());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.connectionProperties", this.optionalConnectionProperties.getSelection());
        this.contributorInformation.setProperties(this.properties);
    }

    public void setDriverUIContributorInformation(IDriverUIContributorInformation contributorInformation) {
        this.contributorInformation = contributorInformation;
        this.properties = contributorInformation.getProperties();
    }

    public void handleEvent(Event event) {
        if (this.isReadOnly) {
            if (event.widget == this.savePasswordButton) {
                this.savePasswordButton.setSelection(!this.savePasswordButton.getSelection());
            } else if (event.widget == this.createCheck) {
                this.createCheck.setSelection(!this.createCheck.getSelection());
            } else if (event.widget == this.upgradeCheck) {
                this.upgradeCheck.setSelection(!this.upgradeCheck.getSelection());
            }
        } else {
            this.updateURL();
            this.setConnectionInformation();
        }
    }

    public void addListeners() {
        this.databaseLocationCombo.addListener(24, (Listener)this);
        this.browseDatabaseLocation.addListener(13, (Listener)this);
        this.usernameText.addListener(24, (Listener)this);
        this.passwordText.addListener(24, (Listener)this);
        this.savePasswordButton.addListener(13, (Listener)this);
        this.createCheck.addListener(13, (Listener)this);
        this.upgradeCheck.addListener(13, (Listener)this);
        this.optionalConnectionProperties.addModifyListener((ModifyListener)this);
    }

    protected void removeListeners() {
        this.databaseLocationCombo.removeListener(24, (Listener)this);
        this.browseDatabaseLocation.removeListener(13, (Listener)this);
        this.usernameText.removeListener(24, (Listener)this);
        this.passwordText.removeListener(24, (Listener)this);
        this.savePasswordButton.removeListener(13, (Listener)this);
        this.createCheck.removeListener(13, (Listener)this);
        this.upgradeCheck.removeListener(13, (Listener)this);
        this.optionalConnectionProperties.removeModifyListener((ModifyListener)this);
    }

    protected void updateURL() {
        String url = "jdbc:derby:" + this.databaseLocationCombo.getText();
        url = String.valueOf(url) + (!this.createCheck.getSelection() ? "" : ";create=true");
        url = String.valueOf(url) + (!this.upgradeCheck.getSelection() ? "" : ";upgrade=true");
        this.urlText.setText(url);
    }

    private void browseForDBFolder() {
        String selectedDirectory;
        DirectoryDialog dialog = new DirectoryDialog(this.databaseLocationCombo.getShell());
        dialog.setText(CUI_NEWCW_FILE_BROWSER_TITLE_TEXT_);
        dialog.setMessage(CUI_NEWCW_FILE_BROWSER_MESSAGE_TEXT_);
        String dirName = this.databaseLocationCombo.getText();
        File path = new File(dirName);
        if (path.exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.databaseLocationCombo.setText(selectedDirectory);
        }
    }

    public void modifyText(ModifyEvent e) {
        this.handleEvent(new Event());
    }

    protected class DerbyEmbeddedJDBCURL {
        protected String subprotocol = "";
        protected String node = "";
        protected String properties = "";

        public DerbyEmbeddedJDBCURL(String url) {
            this.parseURL(url);
        }

        public String getNode() {
            return this.node;
        }

        public String getSubprotocol() {
            return this.subprotocol;
        }

        protected void parseURL(String url) {
            try {
                String remainingURL = url.substring(url.indexOf(58) + 1);
                this.subprotocol = remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 1);
                if (remainingURL.indexOf(59) > -1) {
                    this.node = remainingURL.substring(0, remainingURL.indexOf(59));
                    this.properties = remainingURL = remainingURL.substring(remainingURL.indexOf(59) + 1);
                } else {
                    this.node = remainingURL;
                }
            }
            catch (Exception exception) {}
        }

        public String getProperties() {
            return this.properties;
        }
    }
}

