/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.debug;

import java.util.HashMap;
import org.eclipse.cft.server.core.AbstractDebugProvider;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerUtil;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.debug.ApplicationDebugLauncher;
import org.eclipse.cft.server.core.internal.debug.DebugConnectionDescriptor;
import org.eclipse.cft.server.core.internal.debug.DebugProviderRegistry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;
import org.eclipse.jdt.internal.launching.JavaSourceLookupDirector;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;

public abstract class CloudFoundryDebugDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public static final String SOURCE_LOCATOR = "org.eclipse.cft.debug.sourcepathcomputer";
    public static final String CLOUD_DEBUG_APP_LAUNCH_ID = "cloudDebugAppLaunchId";
    public static final String CLOUD_DEBUG_SERVER = "cloudDebugServer";
    public static final String CLOUD_DEBUG_APP_NAME = "cloudDebugAppName";
    public static final String CLOUD_DEBUG_APP_INSTANCE = "cloudDebugAppInstance";
    public static final String CLOUD_DEBUG_REMOTE_DEBUG_PORT = "cloudDebugRemoteDebugPort";
    public static final String TIME_OUT = "timeout";
    public static final String HOST_NAME = "hostname";
    public static final String PORT = "port";
    public static int DEFAULT_REMOTE_PORT = 45283;

    public abstract String getLaunchConfigurationTypeId();

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        CloudFoundryServer cloudServer = CloudFoundryDebugDelegate.getCloudServer(configuration);
        CloudFoundryApplicationModule appModule = CloudFoundryDebugDelegate.getCloudApplication(configuration);
        int appInstance = CloudFoundryDebugDelegate.getAppInstance(configuration);
        int remoteDebugPort = CloudFoundryDebugDelegate.getRemoteDebugPort(configuration);
        AbstractDebugProvider provider = DebugProviderRegistry.getExistingProvider(appModule, cloudServer);
        DebugConnectionDescriptor connectionDescriptor = this.getDebugConnectionDescriptor(appModule, cloudServer, appInstance, remoteDebugPort, monitor);
        if (connectionDescriptor == null) {
            throw CloudErrorUtil.toCoreException(NLS.bind((String)"Unable to resolve debug connection information for {0}. Please check if debug is supported for the given application in {1} ", (Object)appModule.getDeployedApplicationName(), (Object)cloudServer.getServer().getId()));
        }
        IVMConnector connector = JavaRuntime.getDefaultVMConnector();
        HashMap<String, String> argMap = new HashMap<String, String>();
        String timeout = configuration.getAttribute(TIME_OUT, null);
        if (timeout != null) {
            String timeoutVal = String.valueOf(connectionDescriptor.getTimeout());
            argMap.put(TIME_OUT, timeoutVal);
        }
        argMap.put(HOST_NAME, connectionDescriptor.getHost());
        argMap.put(PORT, String.valueOf(connectionDescriptor.getPort()));
        this.setSourceLocator(launch);
        try {
            connector.connect(argMap, monitor, launch);
            ApplicationDebugLauncher.addDebuggerConnectionListener(provider.getApplicationDebugLaunchId(appModule.getLocalModule(), cloudServer.getServer(), appInstance), launch);
        }
        catch (CoreException e) {
            this.fireDebugChanged(configuration, e.getStatus());
            throw e;
        }
    }

    public final void fireDebugChanged(ILaunchConfiguration config, IStatus status) {
        CloudFoundryServer cloudServer = CloudFoundryDebugDelegate.getCloudServer(config);
        CloudFoundryApplicationModule appModule = CloudFoundryDebugDelegate.getCloudApplication(config);
        ApplicationDebugLauncher.fireDebugChanged(cloudServer, appModule, status);
    }

    protected void setSourceLocator(ILaunch launch) throws CoreException {
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        if (configuration != null && launch.getSourceLocator() == null) {
            JavaSourceLookupDirector sourceLocator = new JavaSourceLookupDirector();
            ISourcePathComputer locator = this.getLaunchManager().getSourcePathComputer(SOURCE_LOCATOR);
            if (locator != null) {
                sourceLocator.setSourcePathComputer(locator);
                sourceLocator.initializeDefaults(configuration);
                launch.setSourceLocator((ISourceLocator)sourceLocator);
            }
        }
    }

    protected abstract DebugConnectionDescriptor getDebugConnectionDescriptor(CloudFoundryApplicationModule var1, CloudFoundryServer var2, int var3, int var4, IProgressMonitor var5) throws CoreException;

    protected void printToConsole(CloudFoundryApplicationModule appModule, CloudFoundryServer server, String message, boolean error) {
        if (appModule != null && server != null) {
            CloudFoundryPlugin.getCallback().printToConsole(server, appModule, String.valueOf(message) + '\n', false, error);
        }
    }

    public static CloudFoundryServer getCloudServer(ILaunchConfiguration config) {
        if (config != null) {
            try {
                String serverId = config.getAttribute(CLOUD_DEBUG_SERVER, null);
                return CloudServerUtil.getCloudServer(serverId);
            }
            catch (CoreException e) {
                CloudFoundryPlugin.logError(e);
            }
        }
        return null;
    }

    public static int getAppInstance(ILaunchConfiguration config) {
        if (config != null) {
            try {
                return config.getAttribute(CLOUD_DEBUG_APP_INSTANCE, 0);
            }
            catch (CoreException e) {
                CloudFoundryPlugin.logError(e);
            }
        }
        return 0;
    }

    public static int getRemoteDebugPort(ILaunchConfiguration config) {
        if (config != null) {
            try {
                return config.getAttribute(CLOUD_DEBUG_REMOTE_DEBUG_PORT, DEFAULT_REMOTE_PORT);
            }
            catch (CoreException e) {
                CloudFoundryPlugin.logError(e);
            }
        }
        return DEFAULT_REMOTE_PORT;
    }

    public static CloudFoundryApplicationModule getCloudApplication(ILaunchConfiguration config) {
        if (config != null) {
            try {
                String appName;
                CloudFoundryServer cloudServer = CloudFoundryDebugDelegate.getCloudServer(config);
                if (cloudServer != null && (appName = config.getAttribute(CLOUD_DEBUG_APP_NAME, null)) != null) {
                    return cloudServer.getExistingCloudModule(appName);
                }
            }
            catch (CoreException e) {
                CloudFoundryPlugin.logError(e);
            }
        }
        return null;
    }
}

