/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeContentProvider;

public class DefaultViewerSorter
extends ViewerSorter {
    private static AlphanumComparator alphanum = new AlphanumComparator();

    public int compare(Viewer viewer, Object o1, Object o2) {
        if (o1 instanceof AbstractTreeContentProvider.TreeElement) {
            o1 = ((AbstractTreeContentProvider.TreeElement)o1).text;
        }
        if (o2 instanceof AbstractTreeContentProvider.TreeElement) {
            o2 = ((AbstractTreeContentProvider.TreeElement)o2).text;
        }
        if (o1 instanceof String && o2 instanceof String) {
            return DefaultViewerSorter.compareCategories((String)o1, (String)o2);
        }
        if (o1 instanceof String) {
            return -1;
        }
        if (o2 instanceof String) {
            return 1;
        }
        if (o1 instanceof IRuntimeType && o2 instanceof IRuntimeType) {
            return DefaultViewerSorter.compareRuntimeTypes((IRuntimeType)o1, (IRuntimeType)o2);
        }
        if (o1 instanceof IServerType && o2 instanceof IServerType) {
            return DefaultViewerSorter.compareServerTypes((IServerType)o1, (IServerType)o2);
        }
        return 0;
    }

    protected static int compareCategories(String s1, String s2) {
        try {
            Version v1 = Version.parseVersion(s1);
            Version v2 = Version.parseVersion(s2);
            return v1.compareTo(v2);
        }
        catch (NumberFormatException numberFormatException) {
            return s1.compareTo(s2);
        }
    }

    protected static boolean isSameFamily(String s1, String v1, String s2, String v2) {
        int ind;
        if (s1 == null || s2 == null) {
            return false;
        }
        if (v1 != null && (ind = s1.indexOf(v1)) >= 0) {
            s1 = String.valueOf(s1.substring(0, ind)) + s1.substring(ind + v1.length());
        }
        if (v2 != null && (ind = s2.indexOf(v2)) >= 0) {
            s2 = String.valueOf(s2.substring(0, ind)) + s2.substring(ind + v2.length());
        }
        return s1.equals(s2);
    }

    protected static int compareVersions(String s1, String s2) {
        Version v1 = Version.parseVersion(s1);
        Version v2 = Version.parseVersion(s2);
        return v1.compareTo(v2);
    }

    protected static int compareRuntimeTypes(IRuntimeType r1, IRuntimeType r2) {
        if (DefaultViewerSorter.isSameFamily(r1.getName(), r1.getVersion(), r2.getName(), r2.getVersion())) {
            return DefaultViewerSorter.compareVersions(r1.getVersion(), r2.getVersion());
        }
        return alphanum.compare(r1.getName(), r2.getName());
    }

    protected static int compareServerTypes(IServerType s1, IServerType s2) {
        IRuntimeType r1 = s1.getRuntimeType();
        IRuntimeType r2 = s2.getRuntimeType();
        if (r1 != null && r2 != null && DefaultViewerSorter.isSameFamily(s1.getName(), r1.getVersion(), s2.getName(), r2.getVersion())) {
            return DefaultViewerSorter.compareVersions(r1.getVersion(), r2.getVersion());
        }
        return alphanum.compare(s1.getName(), s2.getName());
    }

    private static class AlphanumComparator
    implements Comparator<String> {
        private final boolean isDigit(char ch) {
            return ch >= '0' && ch <= '9';
        }

        /*
         * Unable to fully structure code
         */
        private final String getChunk(String s, int slength, int marker) {
            block3: {
                chunk = new StringBuilder();
                c = s.charAt(marker);
                chunk.append(c);
                ++marker;
                if (!this.isDigit(c)) ** GOTO lbl20
                while (marker < slength) {
                    c = s.charAt(marker);
                    if (this.isDigit(c)) {
                        chunk.append(c);
                        ++marker;
                        continue;
                    }
                    break block3;
                }
                break block3;
                while (!this.isDigit(c = s.charAt(marker))) {
                    chunk.append(c);
                    ++marker;
lbl20:
                    // 2 sources

                    if (marker < slength) continue;
                }
            }
            return chunk.toString();
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1 == null || s2 == null) {
                return 0;
            }
            int thisMarker = 0;
            int thatMarker = 0;
            int s1Length = s1.length();
            int s2Length = s2.length();
            while (thisMarker < s1Length && thatMarker < s2Length) {
                String thisChunk = this.getChunk(s1, s1Length, thisMarker);
                thisMarker += thisChunk.length();
                String thatChunk = this.getChunk(s2, s2Length, thatMarker);
                thatMarker += thatChunk.length();
                int result = 0;
                if (this.isDigit(thisChunk.charAt(0)) && this.isDigit(thatChunk.charAt(0))) {
                    int thisChunkLength = thisChunk.length();
                    result = thisChunkLength - thatChunk.length();
                    if (result == 0) {
                        int i = 0;
                        while (i < thisChunkLength) {
                            result = thisChunk.charAt(i) - thatChunk.charAt(i);
                            if (result != 0) {
                                return result;
                            }
                            ++i;
                        }
                    }
                } else {
                    result = thisChunk.compareTo(thatChunk);
                }
                if (result == 0) continue;
                return result;
            }
            return s1Length - s2Length;
        }
    }

    public static class Version
    implements Comparable {
        private static final String SEPARATORS = ".,";
        private final String[] segments;

        private Version(String[] segments) {
            this.segments = segments;
        }

        public static Version parseVersion(String version) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(version, SEPARATORS, false);
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
            String[] s = new String[list.size()];
            list.toArray(s);
            return new Version(s);
        }

        private int compareTo(String s1, String s2) {
            int i2;
            int i1;
            block4: {
                try {
                    i1 = Integer.parseInt(s1);
                    i2 = Integer.parseInt(s2);
                    if (i1 != i2) break block4;
                    return 0;
                }
                catch (Exception exception) {
                    return s1.compareTo(s2);
                }
            }
            if (i1 > i2) {
                return 1;
            }
            return -1;
        }

        public int compareTo(Object object) {
            if (object == this) {
                return 0;
            }
            Version other = (Version)object;
            int i = 0;
            while (i < this.segments.length && i < other.segments.length) {
                String s1 = this.segments[i];
                String s2 = other.segments[i];
                int c = this.compareTo(s1, s2);
                if (c != 0) {
                    return c;
                }
                ++i;
            }
            if (i == this.segments.length && i == other.segments.length) {
                return 0;
            }
            if (i == this.segments.length) {
                return -1;
            }
            return 1;
        }
    }
}

