/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import io.nayuki.deflate.InflaterInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipException;
import org.eclipse.mat.hprof.Messages;

public class GZIPInputStream2
extends FilterInputStream {
    private static final int FLG_FHCRC = 2;
    private static final int FLG_FCOMMENT = 16;
    private static final int FLG_FNAME = 8;
    private static final int FLG_FEXTRA = 4;
    InputStream is;
    long uncompressedLen;
    CRC32 crc = new CRC32();
    boolean checkcrc;

    public GZIPInputStream2(GZIPInputStream2 gs) throws IOException {
        super(new InflaterInputStream((InflaterInputStream)gs.in));
        this.is = gs.is;
        this.uncompressedLen = gs.uncompressedLen;
        this.checkcrc = false;
    }

    public GZIPInputStream2(InputStream is) throws IOException {
        super(new InflaterInputStream(is, true));
        this.is = is;
        this.readHeader(is);
        this.checkcrc = true;
    }

    private InputStream readHeader(InputStream is) throws IOException {
        int b;
        this.crc.reset();
        int b0 = is.read();
        this.crc.update(b0);
        if (b0 != 31) {
            throw new ZipException(Messages.GZIPInputStream2_NotAGzip);
        }
        int b1 = is.read();
        this.crc.update(b1);
        if (b1 != 139) {
            throw new ZipException("Not a Gzip");
        }
        int b2 = is.read();
        this.crc.update(b2);
        if (b2 != 8) {
            throw new ZipException(Messages.GZIPInputStream2_NotDeflate);
        }
        int b3 = is.read();
        if (b3 < 0) {
            throw new ZipException(Messages.GZIPInputStream2_TruncatedHeader);
        }
        this.crc.update(b3);
        int b4 = is.read();
        if (b4 < 0) {
            throw new ZipException(Messages.GZIPInputStream2_TruncatedHeader);
        }
        this.crc.update(b4);
        int b5 = is.read();
        if (b5 < 0) {
            throw new ZipException(Messages.GZIPInputStream2_TruncatedHeader);
        }
        this.crc.update(b5);
        int b6 = is.read();
        if (b6 < 0) {
            throw new ZipException(Messages.GZIPInputStream2_TruncatedHeader);
        }
        this.crc.update(b6);
        int b7 = is.read();
        if (b7 < 0) {
            throw new ZipException(Messages.GZIPInputStream2_TruncatedHeader);
        }
        this.crc.update(b7);
        int mtime = b4 & 0xFF | (b5 & 0xFF) << 8 | (b6 & 0xFF) << 16 | (b7 & 0xFF) << 24;
        long mjtime = (long)mtime * 1000L;
        int b8 = is.read();
        if (b8 < 0) {
            throw new ZipException(Messages.GZIPInputStream2_TruncatedHeader);
        }
        this.crc.update(b8);
        int b9 = is.read();
        if (b9 < 0) {
            throw new ZipException(Messages.GZIPInputStream2_TruncatedHeader);
        }
        this.crc.update(b9);
        if ((b3 & 4) != 0) {
            int l1 = is.read();
            if (l1 < 0) {
                throw new ZipException(Messages.GZIPInputStream2_TruncatedExtra);
            }
            int l2 = is.read();
            if (l2 < 0) {
                throw new ZipException(Messages.GZIPInputStream2_TruncatedExtra);
            }
            int l = (l2 & 0xFF) << 8 | l1 & 0xFF;
            int r = is.read(new byte[l]);
            if (r < l) {
                throw new ZipException(Messages.GZIPInputStream2_TruncatedExtra);
            }
        }
        if ((b3 & 8) != 0) {
            while ((b = is.read()) != 0) {
                if (b != -1) continue;
                throw new ZipException(Messages.GZIPInputStream2_TruncatedName);
            }
        }
        if ((b3 & 0x10) != 0) {
            while ((b = is.read()) != 0) {
                if (b != -1) continue;
                throw new ZipException(Messages.GZIPInputStream2_TruncatedComment);
            }
        }
        if ((b3 & 2) != 0) {
            int c0 = is.read();
            if (c0 == -1) {
                throw new ZipException(Messages.GZIPInputStream2_TruncatedHeaderCRC);
            }
            int c1 = is.read();
            if (c1 == -1) {
                throw new ZipException(Messages.GZIPInputStream2_TruncatedHeaderCRC);
            }
            int crcv = c1 & 0xFF | (c1 & 0xFF) << 8;
            if ((this.crc.getValue() & 0xFFFFL) != (long)crcv) {
                throw new ZipException(Messages.GZIPInputStream2_BadHeaderCRC);
            }
        }
        this.crc.reset();
        return is;
    }

    @Override
    public int read() throws IOException {
        int r = super.read();
        if (r == -1) {
            this.checkTrailer();
        } else {
            this.crc.update(r);
            ++this.uncompressedLen;
        }
        return r;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int r;
        while ((r = super.read(buf, off, len)) == 0) {
        }
        if (r == -1) {
            this.checkTrailer();
        } else {
            this.crc.update(buf, off, r);
            this.uncompressedLen += (long)r;
        }
        return r;
    }

    public long skip2(long n) throws IOException {
        long skipped = 0L;
        byte[] buf = null;
        while (n > 0L) {
            long r;
            int toskip = (int)Math.min(n, 16384L);
            if (buf == null) {
                buf = new byte[toskip];
            }
            if ((r = (long)this.read(buf, 0, toskip)) == -1L) break;
            skipped += r;
            n -= r;
        }
        return skipped;
    }

    void checkTrailer() throws IOException {
        ((InflaterInputStream)this.in).detach();
        int b0 = this.is.read();
        if (b0 < 0) {
            throw new EOFException();
        }
        int b1 = this.is.read();
        if (b1 < 0) {
            throw new EOFException();
        }
        int b2 = this.is.read();
        if (b2 < 0) {
            throw new EOFException();
        }
        int b3 = this.is.read();
        if (b3 < 0) {
            throw new EOFException();
        }
        long crc32 = (long)(b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16) | ((long)b3 & 0xFFL) << 24;
        long crc32v = this.crc.getValue();
        if (this.checkcrc && crc32v != crc32) {
            throw new ZipException(Messages.GZIPInputStream2_BadTrailerCRC);
        }
        int b4 = this.is.read();
        if (b4 < 0) {
            throw new EOFException();
        }
        int b5 = this.is.read();
        if (b5 < 0) {
            throw new EOFException();
        }
        int b6 = this.is.read();
        if (b6 < 0) {
            throw new EOFException();
        }
        int b7 = this.is.read();
        if (b7 < 0) {
            throw new EOFException();
        }
        long len32 = (long)(b4 & 0xFF | (b5 & 0xFF) << 8 | (b6 & 0xFF) << 16) | ((long)b7 & 0xFFL) << 24;
        if (len32 != (this.uncompressedLen & 0xFFFFFFFFL)) {
            throw new ZipException(Messages.GZIPInputStream2_BadTrailerLength);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

