/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.fluent.Executor;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.client.TargetAuthenticationStrategy;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.CacheCredentialsAuthenticationStrategy;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.CacheCredentialsProvider;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.ChainedCredentialsProvider;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientCustomizer;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientTransport;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.SynchronizedCredentialsProvider;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.SystemCredentialsProvider;
import org.eclipse.userstorage.internal.StorageProperties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

class HttpClientFactory {
    private CredentialsProvider credentialsProvider;
    private CookieStore cookieStore;
    private HttpClient client;
    private Executor executor;

    HttpClientFactory() {
    }

    public HttpClient build() {
        HttpClientBuilder clientBuilder = HttpClientFactory.createClientBuilder();
        if (this.cookieStore == null) {
            this.cookieStore = new BasicCookieStore();
        }
        if (this.credentialsProvider == null) {
            this.credentialsProvider = HttpClientFactory.createCredentialsProvider(clientBuilder);
        }
        clientBuilder.setDefaultCredentialsProvider(this.credentialsProvider);
        clientBuilder.setDefaultCookieStore(this.cookieStore);
        this.client = clientBuilder.build();
        this.executor = Executor.newInstance((HttpClient)this.client).use(this.cookieStore).use(this.credentialsProvider);
        return this.client;
    }

    private static CredentialsProvider createCredentialsProvider(HttpClientBuilder clientBuilder) {
        Object credentialsProvider = new SystemCredentialsProvider();
        credentialsProvider = HttpClientFactory.customizeCredentialsProvider((CredentialsProvider)credentialsProvider);
        CacheCredentialsProvider cacheProvider = new CacheCredentialsProvider();
        credentialsProvider = new ChainedCredentialsProvider(cacheProvider, (CredentialsProvider)credentialsProvider);
        credentialsProvider = new SynchronizedCredentialsProvider((CredentialsProvider)credentialsProvider);
        clientBuilder.addInterceptorFirst((request, context) -> context.setAttribute(CacheCredentialsAuthenticationStrategy.CREDENTIALS_CACHE_ATTRIBUTE, (Object)cacheProvider));
        return credentialsProvider;
    }

    private static HttpClientBuilder createClientBuilder() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder = HttpClientFactory.customizeBuilder(builder);
        builder.setMaxConnPerRoute(100).setMaxConnTotal(200);
        HttpClientFactory.setClientTimeouts(builder);
        builder.setTargetAuthenticationStrategy((AuthenticationStrategy)new CacheCredentialsAuthenticationStrategy.Target((AuthenticationStrategy)TargetAuthenticationStrategy.INSTANCE));
        builder.setProxyAuthenticationStrategy((AuthenticationStrategy)new CacheCredentialsAuthenticationStrategy.Proxy((AuthenticationStrategy)ProxyAuthenticationStrategy.INSTANCE));
        builder.setUserAgent(HttpClientTransport.USER_AGENT);
        return builder;
    }

    private static void setClientTimeouts(HttpClientBuilder builder) {
        int connectTimeoutUssDefault = StorageProperties.getProperty((String)"org.eclipse.userstorage.connectTimeout", (int)HttpClientTransport.DEFAULT_CONNECT_TIMEOUT);
        int readTimeoutUssDefault = StorageProperties.getProperty((String)"org.eclipse.userstorage.socketTimeout", (int)HttpClientTransport.DEFAULT_READ_TIMEOUT);
        int connectTimeout = HttpClientFactory.getTimeoutValue(HttpClientTransport.CONNECT_TIMEOUT_PROPERTY, connectTimeoutUssDefault);
        int readTimeout = HttpClientFactory.getTimeoutValue(HttpClientTransport.READ_TIMEOUT_PROPERTY, readTimeoutUssDefault);
        int connectionRequestTimeout = HttpClientFactory.getTimeoutValue(HttpClientTransport.CONNECTION_REQUEST_TIMEOUT_PROPERTY, HttpClientTransport.DEFAULT_CONNECTION_REQUEST_TIMEOUT);
        SocketConfig defaultSocketConfig = SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT).setSoTimeout(readTimeout).setTcpNoDelay(true).build();
        RequestConfig defaultRequestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setSocketTimeout(readTimeout).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectionRequestTimeout).build();
        builder.setDefaultSocketConfig(defaultSocketConfig);
        builder.setDefaultRequestConfig(defaultRequestConfig);
    }

    private static int getTimeoutValue(String property, int defaultValue) {
        String propertyValue = FrameworkUtil.getBundle(HttpClientTransport.class).getBundleContext().getProperty(property);
        if (propertyValue == null || "".equals(propertyValue)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    private static HttpClientBuilder customizeBuilder(HttpClientBuilder builder) {
        BundleContext context = HttpClientFactory.getBundleContext();
        Collection<ServiceReference<HttpClientCustomizer>> serviceReferences = HttpClientFactory.getClientBuilderCustomizers(context);
        HttpClientBuilder customBuilder = builder;
        for (ServiceReference<HttpClientCustomizer> reference : serviceReferences) {
            try {
                HttpClientCustomizer service = (HttpClientCustomizer)context.getService(reference);
                customBuilder = HttpClientFactory.customizeBuilder(service, customBuilder);
            }
            finally {
                context.ungetService(reference);
            }
        }
        return customBuilder;
    }

    private static HttpClientBuilder customizeBuilder(HttpClientCustomizer service, HttpClientBuilder builder) {
        if (service == null) {
            return builder;
        }
        HttpClientBuilder customBuilder = service.customizeBuilder(builder);
        return customBuilder == null ? builder : customBuilder;
    }

    private static CredentialsProvider customizeCredentialsProvider(CredentialsProvider credentialsProvider) {
        BundleContext context = HttpClientFactory.getBundleContext();
        Collection<ServiceReference<HttpClientCustomizer>> serviceReferences = HttpClientFactory.getClientBuilderCustomizers(context);
        CredentialsProvider customizedCredentialsProvider = credentialsProvider;
        for (ServiceReference<HttpClientCustomizer> reference : serviceReferences) {
            try {
                HttpClientCustomizer service = (HttpClientCustomizer)context.getService(reference);
                customizedCredentialsProvider = HttpClientFactory.customizeCredentialsProvider(service, customizedCredentialsProvider);
            }
            finally {
                context.ungetService(reference);
            }
        }
        return customizedCredentialsProvider;
    }

    private static CredentialsProvider customizeCredentialsProvider(HttpClientCustomizer service, CredentialsProvider credentialsProvider) {
        if (service == null) {
            return credentialsProvider;
        }
        CredentialsProvider customCredentialsProvider = service.customizeCredentialsProvider(credentialsProvider);
        return customCredentialsProvider == null ? credentialsProvider : customCredentialsProvider;
    }

    private static BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(HttpClientTransport.class).getBundleContext();
    }

    private static Collection<ServiceReference<HttpClientCustomizer>> getClientBuilderCustomizers(BundleContext context) {
        Set<ServiceReference<HttpClientCustomizer>> serviceReferences;
        try {
            serviceReferences = context.getServiceReferences(HttpClientCustomizer.class, null);
        }
        catch (InvalidSyntaxException e) {
            MarketplaceClientCore.error(e);
            serviceReferences = Collections.emptySet();
        }
        return serviceReferences;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public HttpClient getClient() {
        return this.client;
    }
}

