/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractBasicListTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.FieldInfo;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.om.trace.ContextTracer;

@Deprecated
public abstract class AbstractFeatureMapTableMapping
extends AbstractBasicListTableMapping {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AbstractFeatureMapTableMapping.class);
    private IDBTable table;
    private FieldInfo[] keyFields;
    private Map<CDOID, String> tagMap = CDOIDUtil.createMap();
    private List<String> columnNames = new ArrayList<String>();
    private Map<CDOID, ITypeMapping> typeMappings = CDOIDUtil.createMap();
    private String sqlSelectChunksPrefix;
    private String sqlOrderByIndex;
    protected String sqlInsert;
    private List<DBType> dbTypes;

    public AbstractFeatureMapTableMapping(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        super(mappingStrategy, eClass, feature);
        this.initDBTypes();
        this.initTable();
        this.initSQLStrings();
    }

    private void initDBTypes() {
        ITypeMapping.Registry registry = this.getTypeMappingRegistry();
        this.dbTypes = new ArrayList<DBType>(registry.getDefaultFeatureMapDBTypes());
    }

    protected ITypeMapping.Registry getTypeMappingRegistry() {
        return ITypeMapping.Registry.INSTANCE;
    }

    private void initTable() {
        String tableName = this.getMappingStrategy().getTableName(this.getContainingClass(), this.getFeature());
        DBType idType = this.getMappingStrategy().getStore().getIDHandler().getDBType();
        int idLength = this.getMappingStrategy().getStore().getIDColumnLength();
        IDBDatabase database = this.getMappingStrategy().getStore().getDatabase();
        this.table = database.getSchema().getTable(tableName);
        if (this.table == null) {
            this.table = database.getSchemaTransaction().getWorkingCopy().addTable(tableName);
            IDBIndex index = this.table.addIndexEmpty(IDBIndex.Type.NON_UNIQUE);
            FieldInfo[] fieldInfoArray = this.getKeyFields();
            int n = fieldInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                FieldInfo fieldInfo = fieldInfoArray[n2];
                IDBField field = this.table.addField(fieldInfo.getName(), fieldInfo.getType(), fieldInfo.getPrecision());
                index.addIndexField(field);
                ++n2;
            }
            this.table.addField("CDO_IDX", DBType.INTEGER);
            this.table.addField("CDO_FEATURE", idType, idLength);
            this.initTypeColumns(true);
            this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new String[]{"CDO_IDX"});
            this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new String[]{"CDO_FEATURE"});
        } else {
            this.initTypeColumns(false);
        }
    }

    private void initTypeColumns(boolean create) {
        for (DBType type : this.getDBTypes()) {
            String column = "CDO_VALUE_" + type.name();
            if (create) {
                this.table.addField(column, type);
            }
            this.columnNames.add(column);
        }
    }

    private void initSQLStrings() {
        String tableName = this.getTable().getName();
        FieldInfo[] fields = this.getKeyFields();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("CDO_FEATURE");
        builder.append(", ");
        Iterator<String> iter = this.columnNames.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(" FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        int i = 0;
        while (i < fields.length) {
            builder.append(fields[i].getName());
            if (i + 1 < fields.length) {
                builder.append("=? AND ");
            } else {
                builder.append("=? ");
            }
            ++i;
        }
        this.sqlSelectChunksPrefix = builder.toString();
        this.sqlOrderByIndex = " ORDER BY CDO_IDX";
        builder = new StringBuilder("INSERT INTO ");
        builder.append(tableName);
        builder.append(" (");
        i = 0;
        while (i < fields.length) {
            builder.append(fields[i].getName());
            builder.append(", ");
            ++i;
        }
        i = 0;
        while (i < this.columnNames.size()) {
            builder.append(this.columnNames.get(i));
            builder.append(", ");
            ++i;
        }
        builder.append("CDO_IDX");
        builder.append(", ");
        builder.append("CDO_FEATURE");
        builder.append(") VALUES (");
        i = 0;
        while (i < fields.length + this.columnNames.size()) {
            builder.append("?, ");
            ++i;
        }
        builder.append("?, ?)");
        this.sqlInsert = builder.toString();
    }

    protected final FieldInfo[] getKeyFields() {
        if (this.keyFields == null) {
            ArrayList<FieldInfo> list = new ArrayList<FieldInfo>(3);
            IDBStore store = this.getMappingStrategy().getStore();
            DBType type = store.getIDHandler().getDBType();
            int precision = store.getIDColumnLength();
            list.add(new FieldInfo("CDO_SOURCE", type, precision));
            this.addKeyFields(list);
            this.keyFields = list.toArray(new FieldInfo[list.size()]);
        }
        return this.keyFields;
    }

    protected abstract void addKeyFields(List<FieldInfo> var1);

    protected abstract void setKeyFields(PreparedStatement var1, CDORevision var2) throws SQLException;

    @Override
    public Collection<IDBTable> getDBTables() {
        return Collections.singleton(this.table);
    }

    protected List<DBType> getDBTypes() {
        return this.dbTypes;
    }

    protected final IDBTable getTable() {
        return this.table;
    }

    protected final List<String> getColumnNames() {
        return this.columnNames;
    }

    protected final Map<CDOID, ITypeMapping> getTypeMappings() {
        return this.typeMappings;
    }

    protected final Map<CDOID, String> getTagMap() {
        return this.tagMap;
    }

    @Override
    public void readValues(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        CDOList list = revision.getListOrNull(this.getFeature());
        if (list == null) {
            return;
        }
        if (listChunk == 0 || list.size() == 0) {
            return;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision.getID(), revision.getVersion()});
        }
        String sql = String.valueOf(this.sqlSelectChunksPrefix) + this.sqlOrderByIndex;
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.HIGH);
        IDBResultSet resultSet = null;
        try {
            try {
                this.setKeyFields((PreparedStatement)stmt, (CDORevision)revision);
                if (listChunk != -1) {
                    stmt.setMaxRows(listChunk);
                }
                resultSet = stmt.executeQuery();
                int currentIndex = 0;
                while ((listChunk == -1 || --listChunk >= 0) && resultSet.next()) {
                    CDOID tag = idHandler.getCDOID((ResultSet)resultSet, 1);
                    Object value = this.getTypeMapping(tag).readValue((ResultSet)resultSet);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for index {0} from result set: {1}", new Object[]{currentIndex, value});
                    }
                    list.set(currentIndex++, (Object)CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)this.getFeatureByTag(tag), (Object)value));
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values done for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision.getID(), revision.getVersion()});
        }
    }

    private void addFeature(CDOID tag) {
        EStructuralFeature modelFeature = this.getFeatureByTag(tag);
        ITypeMapping typeMapping = this.getMappingStrategy().createValueMapping(modelFeature);
        String column = "CDO_VALUE_" + typeMapping.getDBType();
        this.tagMap.put(tag, column);
        typeMapping.setDBField(this.table, column);
        this.typeMappings.put(tag, typeMapping);
    }

    @Override
    public final void readChunks(IDBStoreChunkReader chunkReader, List<IStoreChunkReader.Chunk> chunks, String where) {
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list chunk values for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), chunkReader.getRevision().getID(), chunkReader.getRevision().getVersion()});
        }
        StringBuilder builder = new StringBuilder(this.sqlSelectChunksPrefix);
        if (where != null) {
            builder.append(" AND ");
            builder.append(where);
        }
        builder.append(this.sqlOrderByIndex);
        String sql = builder.toString();
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = chunkReader.getAccessor().getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.LOW);
        IDBResultSet resultSet = null;
        try {
            try {
                this.setKeyFields((PreparedStatement)stmt, chunkReader.getRevision());
                resultSet = stmt.executeQuery();
                IStoreChunkReader.Chunk chunk = null;
                int chunkSize = 0;
                int chunkIndex = 0;
                int indexInChunk = 0;
                while (resultSet.next()) {
                    CDOID tag = idHandler.getCDOID((ResultSet)resultSet, 1);
                    Object value = this.getTypeMapping(tag).readValue((ResultSet)resultSet);
                    if (chunk == null) {
                        chunk = chunks.get(chunkIndex++);
                        chunkSize = chunk.size();
                        if (TRACER.isEnabled()) {
                            TRACER.format("Current chunk no. {0} is [start = {1}, size = {2}]", new Object[]{chunkIndex - 1, chunk.getStartIndex(), chunkSize});
                        }
                    }
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for chunk index {0} from result set: {1}", new Object[]{indexInChunk, value});
                    }
                    chunk.add(indexInChunk++, (Object)CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)this.getFeatureByTag(tag), (Object)value));
                    if (indexInChunk != chunkSize) continue;
                    if (TRACER.isEnabled()) {
                        TRACER.format("Chunk finished", new Object[0]);
                    }
                    chunk = null;
                    indexInChunk = 0;
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Reading list chunk values done for feature {0}.{1} of {2}", new Object[]{this.getContainingClass().getName(), this.getFeature(), chunkReader.getRevision()});
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
    }

    @Override
    public void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        CDOList values = revision.getListOrNull(this.getFeature());
        if (values != null) {
            int idx = 0;
            for (Object element : values) {
                this.writeValue(accessor, (CDORevision)revision, idx++, element);
            }
        }
    }

    protected final void writeValue(IDBStoreAccessor accessor, CDORevision revision, int idx, Object value) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing value for feature {0}.{1} index {2} of {3} : {4}", new Object[]{this.getContainingClass().getName(), this.getFeature(), idx, revision, value});
        }
        FeatureMap.Entry entry = (FeatureMap.Entry)value;
        EStructuralFeature entryFeature = entry.getEStructuralFeature();
        CDOID tag = this.getTagByFeature(entryFeature, revision.getTimeStamp());
        ITypeMapping typeMapping = this.getTypeMapping(tag);
        String columnName = this.getColumnName(tag);
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlInsert, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                this.setKeyFields((PreparedStatement)stmt, revision);
                int column = this.getKeyFields().length + 1;
                int i = 0;
                while (i < this.columnNames.size()) {
                    if (this.columnNames.get(i).equals(columnName)) {
                        typeMapping.setValue((PreparedStatement)stmt, column++, entry.getValue());
                    } else {
                        stmt.setNull(column++, this.getDBTypes().get(i).getCode());
                    }
                    ++i;
                }
                stmt.setInt(column++, idx);
                idHandler.setCDOID((PreparedStatement)stmt, column++, tag);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    protected String getColumnName(CDOID tag) {
        String column = this.tagMap.get(tag);
        if (column == null) {
            this.addFeature(tag);
            column = this.tagMap.get(tag);
        }
        return column;
    }

    protected ITypeMapping getTypeMapping(CDOID tag) {
        ITypeMapping typeMapping = this.typeMappings.get(tag);
        if (typeMapping == null) {
            this.addFeature(tag);
            typeMapping = this.typeMappings.get(tag);
        }
        return typeMapping;
    }

    private EStructuralFeature getFeatureByTag(CDOID tag) {
        IMetaDataManager metaDataManager = this.getMappingStrategy().getStore().getMetaDataManager();
        return (EStructuralFeature)metaDataManager.getMetaInstance(tag);
    }

    protected CDOID getTagByFeature(EStructuralFeature feature, long timeStamp) {
        IMetaDataManager metaDataManager = this.getMappingStrategy().getStore().getMetaDataManager();
        return metaDataManager.getMetaID((EModelElement)feature, timeStamp);
    }

    @Override
    public final boolean queryXRefs(IDBStoreAccessor accessor, String mainTableName, String mainTableWhere, IStoreAccessor.QueryXRefsContext context, String idString) {
        throw new ImplementationError("Should never be called!");
    }
}

