/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.browsing;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.browsing.ScriptBrowsingContentProvider;
import org.eclipse.dltk.ui.browsing.ScriptBrowsingPart;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ProjectAndSourceFolderContentProvider
extends ScriptBrowsingContentProvider {
    public ProjectAndSourceFolderContentProvider(ScriptBrowsingPart browsingPart, IDLTKLanguageToolkit languageToolkit) {
        super(false, browsingPart, languageToolkit);
    }

    @Override
    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return NO_CHILDREN;
        }
        try {
            this.startReadInDisplayThread();
            if (element instanceof IStructuredSelection) {
                Assert.isLegal((boolean)false);
                Object[] result = new Object[]{};
                Class<?> clazz = null;
                for (Object item : (IStructuredSelection)element) {
                    if (clazz == null) {
                        clazz = item.getClass();
                    }
                    if (clazz == item.getClass()) {
                        result = ProjectAndSourceFolderContentProvider.concatenate(result, this.getChildren(item));
                        continue;
                    }
                    Object[] objectArray = NO_CHILDREN;
                    return objectArray;
                }
                Object[] objectArray = result;
                return objectArray;
            }
            if (element instanceof IStructuredSelection) {
                Assert.isLegal((boolean)false);
                Object[] result = new Object[]{};
                Iterator iter = ((IStructuredSelection)element).iterator();
                while (iter.hasNext()) {
                    result = ProjectAndSourceFolderContentProvider.concatenate(result, this.getChildren(iter.next()));
                }
                Object[] objectArray = result;
                return objectArray;
            }
            if (element instanceof IScriptProject) {
                Object[] objectArray = this.getProjectFragments((IScriptProject)element);
                return objectArray;
            }
            if (element instanceof IProjectFragment) {
                Object[] objectArray = NO_CHILDREN;
                return objectArray;
            }
            Object[] children = super.getChildren(element);
            ArrayList<Object> newObjs = new ArrayList<Object>();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof IModelElement) {
                    IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)((IModelElement)children[i]));
                    if (this.getToolkit().equals(languageToolkit)) {
                        newObjs.add(children[i]);
                    }
                } else {
                    newObjs.add(children[i]);
                }
                ++i;
            }
            Object[] objectArray = newObjs.toArray();
            return objectArray;
        }
        catch (ModelException e) {
            Object[] objectArray = NO_CHILDREN;
            return objectArray;
        }
        finally {
            this.finishedReadInDisplayThread();
        }
    }

    @Override
    protected Object[] getProjectFragments(IScriptProject project) throws ModelException {
        if (!project.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        IProjectFragment[] roots = project.getProjectFragments();
        ArrayList<IProjectFragment> list = new ArrayList<IProjectFragment>(roots.length);
        int i = 0;
        while (i < roots.length) {
            IProjectFragment root = roots[i];
            if (!this.isProjectProjectFragment(root)) {
                list.add(root);
            }
            ++i;
        }
        return list.toArray();
    }

    @Override
    public boolean hasChildren(Object element) {
        return element instanceof IScriptProject && super.hasChildren(element);
    }
}

