/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.xtext.ui.JdtHyperlink;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkHelper;
import org.eclipse.xtext.ui.editor.hyperlinking.XtextHyperlink;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.ui.refactoring.ui.SyncUtil;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.testing.AbstractEditorTest;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.junit.Assert;

public abstract class AbstractHyperlinkingTest
extends AbstractEditorTest {
    @Inject
    @Extension
    protected IHyperlinkHelper _iHyperlinkHelper;
    @Inject
    @Extension
    protected FileExtensionProvider _fileExtensionProvider;
    @Inject
    @Extension
    protected IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    @Extension
    protected SyncUtil _syncUtil;
    @Inject
    protected IResourceSetProvider resourceSetProvider;
    @Inject
    @Extension
    protected XtextDocumentUtil _xtextDocumentUtil;
    protected IProject project;
    protected final String c = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<|>");
            return _builder.toString();
        }
    }.apply();

    public void hasHyperlinkTo(CharSequence it, String hyperlinkTarget) {
        this.hasHyperlinkTo(it, this.hyperlinkRegion(it), hyperlinkTarget);
    }

    public void hasHyperlinkTo(CharSequence it, IRegion hyperlinkRegion, String hyperlinkTarget) {
        this.hyperlinkIsOffered(this.hyperlinkingOn(this.dslFile(it), hyperlinkRegion.getOffset()), hyperlinkRegion, hyperlinkTarget);
    }

    protected IFile dslFile(CharSequence text) {
        try {
            boolean _not;
            IFile _xblockexpression = null;
            String content = text.toString().replace(this.c, "");
            IFile file = IResourcesSetupUtil.createFile(this.getProjectName(), this.getFileName(), this.getFileExtension(), content.toString());
            IProject project = file.getProject();
            boolean _hasNature = project.hasNature("org.eclipse.xtext.ui.shared.xtextNature");
            boolean bl = _not = !_hasNature;
            if (_not) {
                IResourcesSetupUtil.addNature(project, "org.eclipse.xtext.ui.shared.xtextNature");
            }
            _xblockexpression = file;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected IHyperlink[] hyperlinkingOn(IFile dslFile, int offset) {
        IHyperlink[] _xblockexpression = null;
        XtextEditor editor = this.openInEditor(dslFile);
        IXtextDocument document = this._xtextDocumentUtil.getXtextDocument((ITextViewer)editor.getInternalSourceViewer());
        XtextResource resource = (XtextResource)document.readOnly((IUnitOfWork)new IUnitOfWork<XtextResource, XtextResource>(){

            public XtextResource exec(XtextResource state) {
                return state;
            }
        });
        _xblockexpression = this._iHyperlinkHelper.createHyperlinksByOffset(resource, offset, true);
        return _xblockexpression;
    }

    protected XtextEditor openInEditor(IFile dslFile) {
        try {
            XtextEditor _xblockexpression = null;
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            this._syncUtil.waitForBuild((IProgressMonitor)_nullProgressMonitor);
            _xblockexpression = this.openEditor(dslFile);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void hyperlinkIsOffered(IHyperlink[] hyperlinks, IRegion expectedRegion, String expectedHyperlinkTarget) {
        Assert.assertNotNull((String)"No hyperlinks found!", (Object)hyperlinks);
        Assert.assertEquals((long)1L, (long)hyperlinks.length);
        IHyperlink hyperlink = (IHyperlink)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)hyperlinks)));
        Assert.assertEquals((Object)expectedRegion, (Object)hyperlink.getHyperlinkRegion());
        Assert.assertEquals((Object)expectedHyperlinkTarget, (Object)this.target(hyperlink));
    }

    protected String _target(JdtHyperlink hyperlink) {
        String _xblockexpression = null;
        IJavaElement javaElement = hyperlink.getJavaElement();
        Assert.assertTrue((boolean)(javaElement instanceof IType));
        _xblockexpression = ((IType)javaElement).getFullyQualifiedName();
        return _xblockexpression;
    }

    protected String _target(XtextHyperlink hyperlink) {
        String _xblockexpression = null;
        ResourceSet resourceSet = this.resourceSetProvider.get(this.project);
        EObject eObject = resourceSet.getEObject(hyperlink.getURI(), true);
        _xblockexpression = this._iQualifiedNameProvider.getFullyQualifiedName(eObject).toString();
        return _xblockexpression;
    }

    protected String _target(IHyperlink hyperlink) {
        Object _xblockexpression = null;
        Class<?> _class = hyperlink.getClass();
        String _plus = "Unsupported hyperlink " + _class;
        Assert.fail((String)_plus);
        _xblockexpression = null;
        return _xblockexpression;
    }

    protected String getProjectName() {
        return "HyperlinkingTestProject";
    }

    protected String getFileName() {
        return "hyperlinking";
    }

    protected String getFileExtension() {
        return this._fileExtensionProvider.getPrimaryFileExtension();
    }

    protected IRegion hyperlinkRegion(CharSequence input) {
        int second;
        Region _xblockexpression = null;
        String text = input.toString();
        int first = text.indexOf(this.c);
        if (first == -1) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Can't locate the first position symbol '");
            _builder.append(this.c);
            _builder.append("' in the input text");
            Assert.fail((String)_builder.toString());
        }
        if (first == (second = text.lastIndexOf(this.c))) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Can't locate the second position symbol '");
            _builder_1.append(this.c);
            _builder_1.append("' in the input text");
            Assert.fail((String)_builder_1.toString());
        }
        int offset = first;
        int _length = this.c.length();
        int length = second - first - _length;
        _xblockexpression = new Region(offset, length);
        return _xblockexpression;
    }

    protected String target(IHyperlink hyperlink) {
        if (hyperlink instanceof JdtHyperlink) {
            return this._target((JdtHyperlink)hyperlink);
        }
        if (hyperlink instanceof XtextHyperlink) {
            return this._target((XtextHyperlink)hyperlink);
        }
        if (hyperlink != null) {
            return this._target(hyperlink);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(hyperlink).toString());
    }
}

