/*******************************************************************************
 * Copyright (c) 2010-2019, Tamas Szabo, Istvan Rath and Daniel Varro
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *******************************************************************************/
package org.eclipse.viatra.query.runtime.rete.index.timely;

import java.util.List;
import java.util.Map;

import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.TimelyMemory;
import org.eclipse.viatra.query.runtime.rete.index.MemoryNullIndexer;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;

public class TimelyMemoryNullIndexer extends MemoryNullIndexer {

    protected final TimelyMemory<Timestamp> memoryWithTimestamp;

    public TimelyMemoryNullIndexer(final ReteContainer reteContainer, final int tupleWidth,
            final TimelyMemory<Timestamp> memoryWithTimestamp, final Supplier parent,
            final Receiver activeNode, final List<ListenerSubscription> sharedSubscriptionList) {
        super(reteContainer, tupleWidth, memoryWithTimestamp.keySet(), parent, activeNode, sharedSubscriptionList);
        this.memoryWithTimestamp = memoryWithTimestamp;
    }

    @Override
    public Map<Tuple, Timestamp> getWithTimestamp(final Tuple signature) {
        if (nullSignature.equals(signature)) {
            return isEmpty() ? null : this.memoryWithTimestamp.asMap();
        } else {
            return null;
        }
    }

}
