/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.validation.runtime;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.addon.validation.core.api.IEntry;
import org.eclipse.viatra.addon.validation.core.api.IViolation;
import org.eclipse.viatra.addon.validation.core.listeners.ConstraintListener;
import org.eclipse.viatra.addon.validation.core.listeners.ViolationListener;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;

public class MarkerManagerViolationListener
implements ConstraintListener,
ViolationListener {
    private Logger logger;
    private Map<IViolation, IMarker> markerMap = new HashMap<IViolation, IMarker>();
    private IResource editorLocation;

    public MarkerManagerViolationListener(IResource editorLocation, Logger logger) {
        this.editorLocation = editorLocation;
        this.logger = logger;
    }

    public void violationAppeared(IViolation violation) {
        List keyNames = violation.getConstraint().getSpecification().getKeyNames();
        Map keyObjects = violation.getKeyObjects();
        for (String keyName : keyNames) {
            Object keyObject = keyObjects.get(keyName);
            if (!(keyObject instanceof EObject)) continue;
            EObject location = (EObject)keyObject;
            if (location.eResource() == null) break;
            IResource markerLoc = this.editorLocation;
            if (markerLoc == null) {
                URI uri = location.eResource().getURI();
                String platformString = uri.toPlatformString(true);
                if (platformString == null) {
                    this.logger.error((Object)("Marker location for " + location.toString() + " is invalid!"));
                    return;
                }
                markerLoc = ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
                if (markerLoc == null) {
                    this.logger.error((Object)("Marker location " + platformString + " for " + location + "is not in workspace!"));
                    return;
                }
            }
            try {
                IMarker marker = markerLoc.createMarker("org.eclipse.emf.ecore.diagnostic");
                marker.setAttribute("severity", violation.getConstraint().getSpecification().getSeverity().ordinal());
                marker.setAttribute("transient", true);
                StringBuilder locationSB = new StringBuilder();
                StringBuilder relatedUriSB = new StringBuilder();
                for (Map.Entry entry : keyObjects.entrySet()) {
                    if (locationSB.length() > 0) {
                        locationSB.append(", ");
                    }
                    String locationString = String.format("%1$s: %2$s", entry.getKey(), BasePatternMatch.prettyPrintValue(entry.getValue()));
                    locationSB.append(locationString);
                    if (((String)entry.getKey()).equals(keyName)) continue;
                    if (relatedUriSB.length() > 0) {
                        relatedUriSB.append(" ");
                    }
                    if (!(entry.getValue() instanceof EObject)) continue;
                    URI targetUri = EcoreUtil.getURI((EObject)((EObject)entry.getValue()));
                    relatedUriSB.append(targetUri);
                }
                marker.setAttribute("location", (Object)locationSB.toString());
                if (relatedUriSB.length() > 0) {
                    marker.setAttribute("relatedURIs", (Object)relatedUriSB.toString());
                }
                marker.setAttribute("uri", (Object)EcoreUtil.getURI((EObject)location).toString());
                marker.setAttribute("message", (Object)violation.getMessage());
                this.markerMap.put(violation, marker);
                violation.addListener((ViolationListener)this);
            }
            catch (CoreException e) {
                this.logger.error((Object)"Error during marker initialization!", (Throwable)e);
            }
            break;
        }
    }

    public void violationDisappeared(IViolation violation) {
        IMarker marker = this.markerMap.remove(violation);
        if (marker != null) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                this.logger.error((Object)"Could not delete marker!", (Throwable)e);
            }
        }
    }

    public void violationEntryAppeared(IViolation violation, IEntry entry) {
    }

    public void violationMessageUpdated(IViolation violation) {
        IMarker marker = this.markerMap.get(violation);
        if (marker != null) {
            try {
                marker.setAttribute("message", (Object)violation.getMessage());
            }
            catch (CoreException e) {
                this.logger.error((Object)"Error during marker update!", (Throwable)e);
            }
        }
    }

    public void violationEntryDisappeared(IViolation violation, IEntry entry) {
    }

    public void dispose() {
        for (IMarker marker : this.markerMap.values()) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                this.logger.error((Object)String.format("Exception occured when removing a marker on dispose: %s", e.getMessage()), (Throwable)e);
            }
        }
    }
}

