/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfAnalysisElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfAnalysisOutputElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfViewsElement;
import org.eclipse.tracecompass.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class TmfAggregateAnalysisElement
extends TmfAnalysisElement {
    private final @NonNull Set<TmfAnalysisElement> fContainedAnalyses = new HashSet<TmfAnalysisElement>();
    private final @NonNull TmfCommonProjectElement fExperimentParent;

    protected TmfAggregateAnalysisElement(@NonNull TmfCommonProjectElement experiment, @NonNull TmfAnalysisElement module) {
        super(module.getName(), module.getResource(), module.getParent(), module.getAnalysisHelper());
        this.fExperimentParent = experiment;
        this.fContainedAnalyses.add(module);
    }

    @Override
    public void dispose() {
    }

    @Override
    protected synchronized void refreshChildren() {
        for (TmfAnalysisElement analysis : this.fContainedAnalyses) {
            analysis.refreshChildren();
        }
        super.refreshChildren();
    }

    @Override
    public boolean canExecute() {
        for (TmfAnalysisElement analysis : this.fContainedAnalyses) {
            if (!analysis.canExecute()) continue;
            return true;
        }
        return false;
    }

    public void addAnalyses(@NonNull TmfAnalysisElement element) {
        this.fContainedAnalyses.add(element);
    }

    public void removeAnalyses(@NonNull TmfAnalysisElement element) {
        this.fContainedAnalyses.remove(element);
    }

    public boolean isEmpty() {
        return this.fContainedAnalyses.isEmpty();
    }

    @Override
    public String getHelpMessage() {
        HashSet<String> messages = new HashSet<String>();
        for (TmfAnalysisElement analysis : this.fContainedAnalyses) {
            messages.add(analysis.getHelpMessage());
        }
        if (!messages.isEmpty()) {
            return String.join((CharSequence)",", messages);
        }
        return super.getHelpMessage();
    }

    @Override
    public void activateParentTrace() {
        TmfOpenTraceHelper.openTraceFromElement(this.fExperimentParent);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        Set<TmfAnalysisElement> analyses = this.fContainedAnalyses;
        ArrayList<ReadOnlyTextPropertyDescriptor> descs = new ArrayList<ReadOnlyTextPropertyDescriptor>();
        for (TmfAnalysisElement analysis : analyses) {
            if (!analysis.canExecute()) continue;
            descs.add(new ReadOnlyTextPropertyDescriptor(analysis.getResource(), analysis.getParent().getParent().getLabelText()));
        }
        return descs.toArray(new IPropertyDescriptor[0]);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id instanceof IResource) {
            Set<TmfAnalysisElement> analyses = this.fContainedAnalyses;
            for (TmfAnalysisElement tmfAnalysisElement : analyses) {
                if (!id.equals(tmfAnalysisElement.getResource())) continue;
                return tmfAnalysisElement;
            }
        }
        return null;
    }

    @Override
    public boolean hasChildren() {
        for (TmfAnalysisElement analysis : this.fContainedAnalyses) {
            if (!analysis.hasChildren()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ITmfProjectModelElement> getChildren() {
        ArrayList<ITmfProjectModelElement> children = new ArrayList<ITmfProjectModelElement>();
        for (TmfAnalysisElement analysis : this.fContainedAnalyses) {
            if (!analysis.hasChildren()) continue;
            for (ITmfProjectModelElement output : analysis.getChildren()) {
                if (!(output instanceof TmfAnalysisOutputElement)) continue;
                TmfAnalysisOutputElement newOutput = new TmfAnalysisOutputElement(output.getName(), output.getResource(), this, ((TmfAnalysisOutputElement)output).getOutput());
                children.add(newOutput);
            }
            return children;
        }
        return children;
    }

    @Override
    public TmfViewsElement getParent() {
        return this.fExperimentParent.getChildElementViews();
    }
}

