/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.provider;

import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;

public class CallStackEntryModel
extends TimeGraphEntryModel {
    public static final int TRACE = -2;
    public static final int PROCESS = -1;
    public static final int THREAD = 0;
    private final int fStackLevel;
    private final int fPid;

    public CallStackEntryModel(long id, long parentId, @NonNull List<@NonNull String> labels, long startTime, long endTime, int stackLevel, int pid) {
        super(id, parentId, labels, startTime, endTime);
        this.fStackLevel = stackLevel;
        this.fPid = pid;
    }

    public int getStackLevel() {
        return this.fStackLevel;
    }

    public int getPid() {
        return this.fPid;
    }

    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CallStackEntryModel)) {
            return false;
        }
        CallStackEntryModel other = (CallStackEntryModel)((Object)obj);
        return this.fStackLevel == other.fStackLevel && this.fPid == other.fPid;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fStackLevel, this.fPid);
    }

    public String toString() {
        return String.valueOf(super.toString()) + ' ' + this.getType();
    }

    private String getType() {
        switch (this.fStackLevel) {
            case -2: {
                return "TRACE";
            }
            case -1: {
                return "PROCESS";
            }
            case 0: {
                return "THREAD";
            }
        }
        return "FUNCTION";
    }
}

