/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.runtime.concurrent.interfaces.IExecutor;
import org.eclipse.tcf.te.runtime.extensions.AbstractExtensionPointManager;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtensionProxy;

public final class Executors {
    private static final ExecutorServiceExtensionPointManager EXTENSION_POINT_MANAGER = new ExecutorServiceExtensionPointManager();

    private Executors() {
    }

    public static IExecutor newExecutor(String id) {
        Assert.isNotNull((Object)id);
        return EXTENSION_POINT_MANAGER.getExecutor(id, true);
    }

    public static IExecutor getSharedExecutor(String id) {
        Assert.isNotNull((Object)id);
        return EXTENSION_POINT_MANAGER.getExecutor(id, false);
    }

    public static IExecutor[] getAllSharedExecutors() {
        return EXTENSION_POINT_MANAGER.getExecutors();
    }

    protected static class ExecutorServiceExtensionPointManager
    extends AbstractExtensionPointManager<IExecutor> {
        protected ExecutorServiceExtensionPointManager() {
        }

        protected String getExtensionPointId() {
            return "org.eclipse.tcf.te.runtime.concurrent.executorServices";
        }

        protected String getConfigurationElementName() {
            return "executorService";
        }

        public IExecutor[] getExecutors() {
            ArrayList<IExecutor> contributions = new ArrayList<IExecutor>();
            Collection proxies = this.getExtensions().values();
            for (ExecutableExtensionProxy proxy : proxies) {
                if (proxy.getInstance() == null || contributions.contains(proxy.getInstance())) continue;
                contributions.add((IExecutor)proxy.getInstance());
            }
            return contributions.toArray(new IExecutor[contributions.size()]);
        }

        public IExecutor getExecutor(String id, boolean newInstance) {
            Assert.isNotNull((Object)id);
            IExecutor executorService = null;
            if (this.getExtensions().containsKey(id)) {
                ExecutableExtensionProxy proxy = (ExecutableExtensionProxy)this.getExtensions().get(id);
                executorService = newInstance ? (IExecutor)proxy.newInstance() : (IExecutor)proxy.getInstance();
            }
            return executorService;
        }
    }
}

