/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.jobs.IPJobStatus;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.IPDIExpression;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.internal.debug.ui.messages.Messages;
import org.eclipse.ptp.internal.ui.views.IToolTipProvider;

public class PVariableManager {
    private final Map<String, List<PVariableInfo>> jobVariableMap = new HashMap<String, List<PVariableInfo>>();
    private final UpdateVariableJob upVariableJob = new UpdateVariableJob();

    public void shutdown() {
        this.jobVariableMap.clear();
        this.upVariableJob.cancelAll();
    }

    public PVariableInfo[] getPVariableInfo() {
        ArrayList<PVariableInfo> aList = new ArrayList<PVariableInfo>();
        for (List<PVariableInfo> list : this.jobVariableMap.values()) {
            aList.addAll(list);
        }
        return aList.toArray(new PVariableInfo[0]);
    }

    public PVariableInfo[] getPVariableInfo(String jobId) {
        List<PVariableInfo> infoList = this.jobVariableMap.get(jobId);
        if (infoList == null) {
            return new PVariableInfo[0];
        }
        return infoList.toArray(new PVariableInfo[0]);
    }

    public boolean isPVariableEnable(String jobId, String varname) {
        List<PVariableInfo> infoList = this.jobVariableMap.get(jobId);
        if (infoList != null) {
            PVariableInfo[] pVariableInfoArray = infoList.toArray(new PVariableInfo[0]);
            int n = pVariableInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                PVariableInfo info = pVariableInfoArray[n2];
                if (info.getName().equals(varname)) {
                    return info.isEnabled();
                }
                ++n2;
            }
        }
        return false;
    }

    public void updateVariableStatus(PVariableInfo info, boolean enabled) throws CoreException {
        info.setEnabled(enabled);
        this.getSession(info.getJobId()).getPDISession().getExpressionManager().updateStatusMultiExpressions(info.getName(), enabled);
    }

    public void updateVariableStatus(String jobId, String varname, boolean enabled) throws CoreException {
        PVariableInfo info = this.findVariableInfo(jobId, varname);
        if (info == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, NLS.bind((String)Messages.PVariableManager_0, (Object)varname), null));
        }
        this.updateVariableStatus(info, enabled);
    }

    public void addVariable(String jobId, String varname, boolean enabled) throws CoreException {
        if (this.findVariableInfo(jobId, varname) != null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, NLS.bind((String)Messages.PVariableManager_1, (Object)varname), null));
        }
        List<PVariableInfo> infoList = this.jobVariableMap.get(jobId);
        if (infoList == null) {
            infoList = new ArrayList<PVariableInfo>();
            this.jobVariableMap.put(jobId, infoList);
        }
        IPSession session = this.getSession(jobId);
        session.getPDISession().getExpressionManager().createMutliExpressions(session.getTasks(), varname, enabled);
        infoList.add(new PVariableInfo(jobId, varname, enabled));
    }

    public void removeVariable(String job_id) {
        this.jobVariableMap.remove(job_id);
    }

    public void removeVariable(String jobId, String varname) throws CoreException {
        PVariableInfo info = this.findVariableInfo(jobId, varname);
        if (info == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, NLS.bind((String)Messages.PVariableManager_0, (Object)varname), null));
        }
        this.jobVariableMap.get(jobId).remove(info);
        this.getSession(jobId).getPDISession().getExpressionManager().removeMutliExpressions(varname);
    }

    public void updateVariable(String jobId, String varname, String newvarname, boolean enabled) throws CoreException {
        if (newvarname != null) {
            this.removeVariable(jobId, varname);
            this.addVariable(jobId, newvarname, enabled);
        } else {
            this.updateVariableStatus(jobId, varname, enabled);
        }
    }

    public void updateValues(String jobId) {
        try {
            this.updateValues(jobId, this.getSession(jobId).getTasks());
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    public void updateValues(final String jobId, final TaskSet tasks) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IPDISession session = PVariableManager.this.getSession(jobId).getPDISession();
                    TaskSet targetTasks = session.getTaskManager().getSuspendedTasks(tasks);
                    if (targetTasks.isEmpty()) {
                        monitor.done();
                    } else {
                        session.getExpressionManager().updateMultiExpressions(targetTasks, monitor);
                    }
                }
                catch (CoreException ce) {
                    throw new InterruptedException(ce.getMessage());
                }
                catch (PDIException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }
        };
        try {
            new ProgressMonitorDialog(PTPDebugUIPlugin.getActiveWorkbenchShell()).run(true, true, runnable);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException ie) {
            ie.printStackTrace();
        }
    }

    public String getValue(final IPJobStatus job, final int task, final IToolTipProvider provider) {
        IPDIExpression[] expressions;
        block11: {
            block10: {
                IPSession session = this.getSession(job.getJobId());
                expressions = session.getPDISession().getExpressionManager().getMultiExpressions(task);
                if (expressions != null && expressions.length != 0) break block10;
                return "";
            }
            String pState = job.getProcessState(task);
            if (pState.equals("SUSPENDED")) break block11;
            return "";
        }
        try {
            StringBuffer display = new StringBuffer();
            IPDIExpression[] iPDIExpressionArray = expressions;
            int n = expressions.length;
            int n2 = 0;
            while (n2 < n) {
                IPDIExpression expression = iPDIExpressionArray[n2];
                display.append("<i>");
                display.append(expression.getExpressionText());
                display.append("</i>");
                display.append(" = ");
                try {
                    IAIF aif = expression.getAIF();
                    if (aif == null) {
                        IRunnableWithProgress runnable = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    IPSession session = PVariableManager.this.getSession(job.getJobId());
                                    session.getPDISession().getExpressionManager().updateMultiExpressions(session.getTasks(task), monitor);
                                }
                                catch (CoreException ce) {
                                    throw new InterruptedException(ce.getMessage());
                                }
                                catch (PDIException pDIException) {
                                    // empty catch block
                                }
                                if (provider != null) {
                                    provider.update(task, PVariableManager.this.getValue(job, task, null));
                                }
                            }
                        };
                        this.queueRunnable(runnable);
                        display.append(Messages.PVariableManager_2);
                    } else {
                        display.append(aif.getValue().getValueString());
                    }
                }
                catch (PDIException e) {
                    display.append(e.getMessage());
                }
                catch (AIFException ae) {
                    display.append(ae.getMessage());
                }
                display.append("<br>");
                ++n2;
            }
            return display.toString();
        }
        catch (CoreException e) {
            return e.getMessage();
        }
    }

    public void resetValues(final String jobId) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IPSession session = PVariableManager.this.getSession(jobId);
                    session.getPDISession().getExpressionManager().cleanMultiExpressions(session.getTasks(), monitor);
                }
                catch (CoreException ce) {
                    throw new InterruptedException(ce.getMessage());
                }
                catch (PDIException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }
        };
        this.queueRunnable(runnable);
    }

    public void resetValue(final String jobId, final TaskSet tasks) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IPSession session = PVariableManager.this.getSession(jobId);
                    session.getPDISession().getExpressionManager().cleanMultiExpressions(tasks, monitor);
                }
                catch (CoreException ce) {
                    throw new InterruptedException(ce.getMessage());
                }
                catch (PDIException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }
        };
        this.queueRunnable(runnable);
    }

    private PVariableInfo findVariableInfo(String jobId, String varname) {
        List<PVariableInfo> infoList = this.jobVariableMap.get(jobId);
        if (infoList != null) {
            PVariableInfo[] pVariableInfoArray = infoList.toArray(new PVariableInfo[0]);
            int n = pVariableInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                PVariableInfo info = pVariableInfoArray[n2];
                if (info.getName().equals(varname)) {
                    return info;
                }
                ++n2;
            }
        }
        return null;
    }

    private IPSession getSession(String jobId) throws CoreException {
        IPSession session = PTPDebugCorePlugin.getDebugModel().getSession(jobId);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, Messages.PVariableManager_3, null));
        }
        return session;
    }

    public void queueRunnable(IRunnableWithProgress runnable) {
        this.upVariableJob.addRunnable(runnable);
    }

    public class PVariableInfo {
        private final String jobId;
        private final String name;
        private boolean enabled;

        public PVariableInfo(String jobId, String name, boolean enabled) {
            this.jobId = jobId;
            this.name = name;
            this.enabled = enabled;
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    private class UpdateVariableJob
    extends Job {
        private final Vector<IRunnableWithProgress> fRunnables;

        public UpdateVariableJob() {
            super(Messages.PVariableManager_4);
            this.setSystem(true);
            this.fRunnables = new Vector(10);
        }

        public void cancelAll() {
            this.fRunnables.clear();
            super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRunnable(IRunnableWithProgress runnable) {
            Vector<IRunnableWithProgress> vector = this.fRunnables;
            synchronized (vector) {
                this.fRunnables.add(runnable);
            }
            this.schedule();
        }

        public boolean shouldRun() {
            return !this.fRunnables.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            IRunnableWithProgress[] runnables;
            Vector<IRunnableWithProgress> vector = this.fRunnables;
            synchronized (vector) {
                runnables = this.fRunnables.toArray(new IRunnableWithProgress[0]);
                this.fRunnables.clear();
            }
            MultiStatus failed = null;
            monitor.beginTask(this.getName(), runnables.length);
            IRunnableWithProgress[] iRunnableWithProgressArray = runnables;
            int n = runnables.length;
            int n2 = 0;
            while (n2 < n) {
                IRunnableWithProgress runnable = iRunnableWithProgressArray[n2];
                try {
                    runnable.run(monitor);
                }
                catch (Exception e) {
                    if (failed == null) {
                        failed = new MultiStatus(PTPDebugCorePlugin.getUniqueIdentifier(), 1000, Messages.PVariableManager_5, null);
                    }
                    failed.add((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, Messages.PVariableManager_5, (Throwable)e));
                }
                monitor.worked(1);
                ++n2;
            }
            monitor.done();
            if (failed == null) {
                return Status.OK_STATUS;
            }
            return failed;
        }
    }
}

