/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.php.formatter.ui.FormatterMessages;

public final class WhiteSpaceOptions {
    private static final String FOR_PREVIEW = "for ($i= 0, $j= 0; $i < 8; $i++, $j--) {}";
    private static final String FOREACH_PREVIEW = "foreach ($s as $key => $value) {}";
    private static final String YIELD_PREVIEW = "function a() { yield $value; yield $key => $value; $x = (yield $value); $x = (yield $key => $value); }";
    private static final String WHILE_PREVIEW = "while ($condition) {} do {} while ($condition);";
    private static final String CATCH_PREVIEW = "try { echo $b; } catch (Exception $e) {}";
    private static final String STATIC_PREVIEW = "static $a,$b;";
    private static final String GLOBAL_PREVIEW = "global $a,$b;";
    private static final String ECHO_PREVIEW = "echo 'hello ',$a;";
    private static final String IF_PREVIEW = "if ($condition) { return $foo; } else {return $bar;}";
    private static final String SWITCH_PREVIEW = "switch ($number) { case RED: return GREEN; case GREEN: return BLUE; case BLUE: return RED; default: return BLACK;}";
    private static final String METHOD_DECL_PREVIEW = "function foo() {}function bar(MyClass $x, $y, $z=1) {}";
    private static final String ARRAY_CREATION_PREVIEW = "list($a,$b)= array(1,2,3);\n$array=array(1=>2,2=>3);\n";
    private static final String ARRAY_ACCESS_PREVIEW = "$array[$i]->foo();$array[]='first cell';";
    private static final String METHOD_CALL_PREVIEW = "foo();\nbar($x, $y);MyClass::foo();$myClass->foo();";
    private static final String FIELD_ACCESS_PREVIEW = "$myClass->$attr;MyClass::$attr;MyClass::MY_CONST;";
    private static final String SEMICOLON_PREVIEW = "$a= 4; foo(); bar($x, $y);";
    private static final String CONDITIONAL_PREVIEW = "$a = $condition ? TRUE : FALSE;";
    private static final String CLASS_DECL_PREVIEW = "class MyClass implements I0, I1, I2 {}";
    private static final String OPERATOR_PREVIEW = "$a= -4 + -9; $b= $a++ / --$number; $c += 4; $value= true && false;";
    private static final String CAST_PREVIEW = "$s= (string)$object;";
    private static final String PARENTHESIS_EXPRESSION_PREVIEW = "(($a));";
    private static final String REFERENCED_EXPRESSION_PREVIEW = "$b = &$a;";
    private static final String MULT_FIELD_PREVIEW = "class MyClass {public $a=0,$b=1,$c=2,$d=3; const MY_TRUE=1,MY_FALSE=2;}";
    private static final String BLOCK_PREVIEW = "if (true) { return 1; } else if(true) {return 3; }else { return 2; }";

    public static List<Node> createTreeBySyntaxElem(Map<String, Object> workingValues) {
        ArrayList<Node> roots = new ArrayList<Node>();
        InnerNode element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_opening_paren);
        WhiteSpaceOptions.createBeforeOpenParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        WhiteSpaceOptions.createAfterOpenParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_closing_paren);
        WhiteSpaceOptions.createBeforeClosingParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        WhiteSpaceOptions.createAfterCloseParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_opening_brace);
        WhiteSpaceOptions.createBeforeOpenBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_closing_brace);
        WhiteSpaceOptions.createAfterCloseBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_opening_bracket);
        WhiteSpaceOptions.createBeforeOpenBracketTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        WhiteSpaceOptions.createAfterOpenBracketTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_closing_bracket);
        WhiteSpaceOptions.createBeforeClosingBracketTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_operator);
        WhiteSpaceOptions.createBeforeOperatorTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        WhiteSpaceOptions.createAfterOperatorTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_comma);
        WhiteSpaceOptions.createBeforeCommaTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        WhiteSpaceOptions.createAfterCommaTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_colon);
        WhiteSpaceOptions.createBeforeColonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        WhiteSpaceOptions.createAfterColonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_semicolon);
        WhiteSpaceOptions.createBeforeSemicolonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        WhiteSpaceOptions.createAfterSemicolonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_question_mark);
        WhiteSpaceOptions.createBeforeQuestionTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        WhiteSpaceOptions.createAfterQuestionTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_parens);
        WhiteSpaceOptions.createBetweenEmptyParenTree(workingValues, element);
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_brackets);
        WhiteSpaceOptions.createBetweenEmptyBracketsTree(workingValues, element);
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_before_arrow);
        WhiteSpaceOptions.createBeforeArrowTree(workingValues, element);
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_after_arrow);
        WhiteSpaceOptions.createAfterArrowTree(workingValues, element);
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_before_coloncolon);
        WhiteSpaceOptions.createBeforeColoncolonTree(workingValues, element);
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_after_coloncolon);
        WhiteSpaceOptions.createAfterColoncolonTree(workingValues, element);
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_after_reference_symbol);
        WhiteSpaceOptions.createAfterReferenceSymbolTree(workingValues, element);
        roots.add(element);
        return roots;
    }

    public static List<Node> createAltTree(Map<String, Object> workingValues) {
        ArrayList<Node> roots = new ArrayList<Node>();
        InnerNode parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_opening_paren);
        WhiteSpaceOptions.createBeforeOpenParenTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_opening_paren);
        WhiteSpaceOptions.createAfterOpenParenTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_closing_paren);
        WhiteSpaceOptions.createBeforeClosingParenTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_closing_paren);
        WhiteSpaceOptions.createAfterCloseParenTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_parens);
        WhiteSpaceOptions.createBetweenEmptyParenTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_opening_brace);
        WhiteSpaceOptions.createBeforeOpenBraceTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_closing_brace);
        WhiteSpaceOptions.createAfterCloseBraceTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_opening_bracket);
        WhiteSpaceOptions.createBeforeOpenBracketTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_opening_bracket);
        WhiteSpaceOptions.createAfterOpenBracketTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_closing_bracket);
        WhiteSpaceOptions.createBeforeClosingBracketTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_brackets);
        WhiteSpaceOptions.createBetweenEmptyBracketsTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_operator);
        WhiteSpaceOptions.createBeforeOperatorTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_operator);
        WhiteSpaceOptions.createAfterOperatorTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_comma);
        WhiteSpaceOptions.createBeforeCommaTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_comma);
        WhiteSpaceOptions.createAfterCommaTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_colon);
        WhiteSpaceOptions.createAfterColonTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_colon);
        WhiteSpaceOptions.createBeforeColonTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_semicolon);
        WhiteSpaceOptions.createBeforeSemicolonTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_semicolon);
        WhiteSpaceOptions.createAfterSemicolonTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_question_mark);
        WhiteSpaceOptions.createBeforeQuestionTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_question_mark);
        WhiteSpaceOptions.createAfterQuestionTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_arrow);
        WhiteSpaceOptions.createBeforeArrowTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_arrow);
        WhiteSpaceOptions.createAfterArrowTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_coloncolon);
        WhiteSpaceOptions.createBeforeColoncolonTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_coloncolon);
        WhiteSpaceOptions.createAfterColoncolonTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_reference_symbol);
        WhiteSpaceOptions.createAfterReferenceSymbolTree(workingValues, parent);
        return roots;
    }

    private static InnerNode createParentNode(List<Node> roots, Map<String, Object> workingValues, String text) {
        InnerNode parent = new InnerNode(null, workingValues, text);
        roots.add(parent);
        return parent;
    }

    public static ArrayList<Node> createTreeByPHPElement(Map<String, Object> workingValues) {
        InnerNode declarations = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_declarations);
        WhiteSpaceOptions.createClassTree(workingValues, declarations);
        WhiteSpaceOptions.createFieldTree(workingValues, declarations);
        WhiteSpaceOptions.createMethodDeclTree(workingValues, declarations);
        InnerNode statements = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_statements);
        WhiteSpaceOptions.createOption(statements, workingValues, FormatterMessages.WhiteSpaceOptions_before_semicolon, "org.eclipse.php.formatter.core.formatter.insert_space_before_semicolon", SEMICOLON_PREVIEW);
        WhiteSpaceOptions.createBlockTree(workingValues, statements);
        WhiteSpaceOptions.createIfStatementTree(workingValues, statements);
        WhiteSpaceOptions.createForStatementTree(workingValues, statements);
        WhiteSpaceOptions.createForeachStatementTree(workingValues, statements);
        WhiteSpaceOptions.createSwitchStatementTree(workingValues, statements);
        WhiteSpaceOptions.createDoWhileTree(workingValues, statements);
        WhiteSpaceOptions.createTryStatementTree(workingValues, statements);
        WhiteSpaceOptions.createStaticTree(workingValues, statements);
        WhiteSpaceOptions.createGlobalTree(workingValues, statements);
        WhiteSpaceOptions.createEchoTree(workingValues, statements);
        WhiteSpaceOptions.createYieldStatementTree(workingValues, statements);
        InnerNode expressions = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_expressions);
        WhiteSpaceOptions.createFieldAccessTree(workingValues, expressions);
        WhiteSpaceOptions.createFunctionCallTree(workingValues, expressions);
        WhiteSpaceOptions.createAssignmentTree(workingValues, expressions);
        WhiteSpaceOptions.createOperatorTree(workingValues, expressions);
        WhiteSpaceOptions.createTypecastTree(workingValues, expressions);
        WhiteSpaceOptions.createConditionalTree(workingValues, expressions);
        WhiteSpaceOptions.createParenthesisExpressionTree(workingValues, expressions);
        WhiteSpaceOptions.createReferencedExpressionTree(workingValues, expressions);
        InnerNode arrays = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_arrays);
        WhiteSpaceOptions.createArrayCreationTree(workingValues, arrays);
        WhiteSpaceOptions.createArrayElementAccessTree(workingValues, arrays);
        ArrayList<Node> roots = new ArrayList<Node>();
        roots.add(declarations);
        roots.add(statements);
        roots.add(expressions);
        roots.add(arrays);
        return roots;
    }

    private static void createBeforeQuestionTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.php.formatter.core.formatter.insert_space_before_question_in_conditional", CONDITIONAL_PREVIEW);
    }

    private static void createBeforeSemicolonTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.php.formatter.core.formatter.insert_space_before_semicolon_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_statements, "org.eclipse.php.formatter.core.formatter.insert_space_before_semicolon", SEMICOLON_PREVIEW);
    }

    private static void createBeforeColonTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.php.formatter.core.formatter.insert_space_before_colon_in_conditional", CONDITIONAL_PREVIEW);
        InnerNode switchStatement = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch);
        WhiteSpaceOptions.createOption(switchStatement, workingValues, FormatterMessages.WhiteSpaceOptions_case, "org.eclipse.php.formatter.core.formatter.insert_space_before_colon_in_case", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(switchStatement, workingValues, FormatterMessages.WhiteSpaceOptions_default, "org.eclipse.php.formatter.core.formatter.insert_space_before_colon_in_default", SWITCH_PREVIEW);
    }

    private static void createBeforeCommaTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_for_inits", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_method_invocation_arguments", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_decl, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_method_declaration_parameters", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_fields, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_multiple_field_declarations", MULT_FIELD_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_constants, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_multiple_constant_declarations", MULT_FIELD_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_implements_clause, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_superinterfaces", CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_decl, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_array_creation", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_list, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_list", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_echo, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_echo", ECHO_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_global, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_global", GLOBAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_static, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_static", STATIC_PREVIEW);
    }

    private static void createBeforeOperatorTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_assignment_operator, "org.eclipse.php.formatter.core.formatter.insert_space_before_assignment_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_unary_operator, "org.eclipse.php.formatter.core.formatter.insert_space_before_unary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_binary_operator, "org.eclipse.php.formatter.core.formatter.insert_space_before_binary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_prefix_operator, "org.eclipse.php.formatter.core.formatter.insert_space_before_prefix_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_postfix_operator, "org.eclipse.php.formatter.core.formatter.insert_space_before_postfix_operator", OPERATOR_PREVIEW);
    }

    private static void createBeforeClosingBracketTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_element_access, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_bracket_in_array_reference", ARRAY_ACCESS_PREVIEW);
    }

    private static void createBeforeOpenBracketTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_element_access, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_bracket_in_array_reference", ARRAY_ACCESS_PREVIEW);
    }

    private static void createBeforeOpenBraceTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_class_decl, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_brace_in_type_declaration", CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_decl, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_brace_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_block, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_brace_in_block", BLOCK_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_brace_in_switch", SWITCH_PREVIEW);
    }

    private static void createBeforeClosingParenTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_catch, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_catch", CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_foreach, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_foreach", FOREACH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_list, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_list", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_if, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_if", IF_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_while, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_while", WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_cast, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_cast", CAST_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_decl, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_paren_expr, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_parenthesized_expression", PARENTHESIS_EXPRESSION_PREVIEW);
    }

    private static void createBeforeOpenParenTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_catch, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_catch", CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_foreach, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_foreach", FOREACH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_list, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_list", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_if, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_if", IF_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_while, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_while", WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_decl, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_method_invocation", METHOD_CALL_PREVIEW);
    }

    private static void createAfterQuestionTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.php.formatter.core.formatter.insert_space_after_question_in_conditional", CONDITIONAL_PREVIEW);
    }

    private static void createAfterColoncolonTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_field_access, "org.eclipse.php.formatter.core.formatter.insert_space_after_coloncolon_in_field_access", FIELD_ACCESS_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.php.formatter.core.formatter.insert_space_after_coloncolon_in_method_invocation", METHOD_CALL_PREVIEW);
    }

    private static void createAfterReferenceSymbolTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_ref_expr, "org.eclipse.php.formatter.core.formatter.insert_space_after_reference_symbol_in_referenced_expression", REFERENCED_EXPRESSION_PREVIEW);
    }

    private static void createBeforeColoncolonTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_field_access, "org.eclipse.php.formatter.core.formatter.insert_space_before_coloncolon_in_field_access", FIELD_ACCESS_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.php.formatter.core.formatter.insert_space_before_coloncolon_in_method_invocation", METHOD_CALL_PREVIEW);
    }

    private static void createAfterArrowTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_foreach, "org.eclipse.php.formatter.core.formatter.insert_space_after_arrow_in_foreach", FOREACH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.php.formatter.core.formatter.insert_space_after_arrow_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_field_access, "org.eclipse.php.formatter.core.formatter.insert_space_after_arrow_in_field_access", FIELD_ACCESS_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_decl, "org.eclipse.php.formatter.core.formatter.insert_space_after_arrow_in_array_creation", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_yield, "org.eclipse.php.formatter.core.formatter.insert_space_after_arrow_in_yield", YIELD_PREVIEW);
    }

    private static void createBeforeArrowTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_foreach, "org.eclipse.php.formatter.core.formatter.insert_space_before_arrow_in_foreach", FOREACH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.php.formatter.core.formatter.insert_space_before_arrow_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_field_access, "org.eclipse.php.formatter.core.formatter.insert_space_before_arrow_in_field_access", FIELD_ACCESS_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_decl, "org.eclipse.php.formatter.core.formatter.insert_space_before_arrow_in_array_creation", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_yield, "org.eclipse.php.formatter.core.formatter.insert_space_before_arrow_in_yield", YIELD_PREVIEW);
    }

    private static void createAfterSemicolonTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.php.formatter.core.formatter.insert_space_after_semicolon_in_for", FOR_PREVIEW);
    }

    private static void createAfterColonTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.php.formatter.core.formatter.insert_space_after_colon_in_conditional", CONDITIONAL_PREVIEW);
    }

    private static void createAfterCommaTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_for_inits", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_method_invocation_arguments", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_decl, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_method_declaration_parameters", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_fields, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_multiple_field_declarations", MULT_FIELD_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_constants, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_multiple_constant_declarations", MULT_FIELD_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_implements_clause, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_superinterfaces", CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_decl, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_array_creation", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_list, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_list", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_echo, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_echo", ECHO_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_global, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_global", GLOBAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_static, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_static", STATIC_PREVIEW);
    }

    private static void createAfterOperatorTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_assignment_operator, "org.eclipse.php.formatter.core.formatter.insert_space_after_assignment_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_unary_operator, "org.eclipse.php.formatter.core.formatter.insert_space_after_unary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_binary_operator, "org.eclipse.php.formatter.core.formatter.insert_space_after_binary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_prefix_operator, "org.eclipse.php.formatter.core.formatter.insert_space_after_prefix_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_postfix_operator, "org.eclipse.php.formatter.core.formatter.insert_space_after_postfix_operator", OPERATOR_PREVIEW);
    }

    private static void createAfterOpenBracketTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_element_access, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_bracket_in_array_reference", ARRAY_ACCESS_PREVIEW);
    }

    private static void createAfterCloseBraceTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_block, "org.eclipse.php.formatter.core.formatter.insert_space_after_closing_brace_in_block", BLOCK_PREVIEW);
    }

    private static void createAfterCloseParenTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_cast, "org.eclipse.php.formatter.core.formatter.insert_space_after_closing_paren_in_cast", CAST_PREVIEW);
    }

    private static void createAfterOpenParenTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_catch, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_catch", CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_foreach, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_foreach", FOREACH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_list, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_list", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_if, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_if", IF_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_while, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_while", WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_decl, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_cast, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_cast", CAST_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_paren_expr, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_parenthesized_expression", PARENTHESIS_EXPRESSION_PREVIEW);
    }

    private static void createBetweenEmptyParenTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_decl, "org.eclipse.php.formatter.core.formatter.insert_space_between_empty_parens_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.php.formatter.core.formatter.insert_space_between_empty_parens_in_method_invocation", METHOD_CALL_PREVIEW);
    }

    private static void createBetweenEmptyBracketsTree(Map<String, Object> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_element_access, "org.eclipse.php.formatter.core.formatter.insert_space_between_brackets_in_array_type_reference", ARRAY_ACCESS_PREVIEW);
    }

    private static InnerNode createClassTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_classes);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_classes_before_opening_brace_of_a_class, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_brace_in_type_declaration", CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_classes_before_comma_implements, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_superinterfaces", CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_classes_after_comma_implements, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_superinterfaces", CLASS_DECL_PREVIEW);
        return root;
    }

    private static InnerNode createAssignmentTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_assignments);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_assignments_before_assignment_operator, "org.eclipse.php.formatter.core.formatter.insert_space_before_assignment_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_assignments_after_assignment_operator, "org.eclipse.php.formatter.core.formatter.insert_space_after_assignment_operator", OPERATOR_PREVIEW);
        return root;
    }

    private static InnerNode createOperatorTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_operators);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_binary_operators, "org.eclipse.php.formatter.core.formatter.insert_space_before_binary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_binary_operators, "org.eclipse.php.formatter.core.formatter.insert_space_after_binary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_unary_operators, "org.eclipse.php.formatter.core.formatter.insert_space_before_unary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_unary_operators, "org.eclipse.php.formatter.core.formatter.insert_space_after_unary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_prefix_operators, "org.eclipse.php.formatter.core.formatter.insert_space_before_prefix_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_prefix_operators, "org.eclipse.php.formatter.core.formatter.insert_space_after_prefix_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_postfix_operators, "org.eclipse.php.formatter.core.formatter.insert_space_before_postfix_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_postfix_operators, "org.eclipse.php.formatter.core.formatter.insert_space_after_postfix_operator", OPERATOR_PREVIEW);
        return root;
    }

    private static InnerNode createMethodDeclTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_methods);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_parens, "org.eclipse.php.formatter.core.formatter.insert_space_between_empty_parens_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_brace_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma_in_params, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_method_declaration_parameters", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma_in_params, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_method_declaration_parameters", METHOD_DECL_PREVIEW);
        return root;
    }

    private static InnerNode createFieldTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_fields);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_fields_before_comma, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_multiple_field_declarations", MULT_FIELD_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_fields_after_comma, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_multiple_field_declarations", MULT_FIELD_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_constant_before_comma, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_multiple_constant_declarations", MULT_FIELD_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_constant_after_comma, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_multiple_constant_declarations", MULT_FIELD_PREVIEW);
        return root;
    }

    private static InnerNode createArrayCreationTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_arraycreation);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren_in_array, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_array_creation", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren_in_array, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_array_creation", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren_in_array, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_array_creation", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma_in_array, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_array_creation", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma_in_array, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_array_creation", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_arrow_in_array, "org.eclipse.php.formatter.core.formatter.insert_space_before_arrow_in_array_creation", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_arrow_in_array, "org.eclipse.php.formatter.core.formatter.insert_space_after_arrow_in_array_creation", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren_in_list, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_list", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren_in_list, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_list", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren_in_list, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_list", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma_in_list, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_list", ARRAY_CREATION_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma_in_list, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_list", ARRAY_CREATION_PREVIEW);
        return root;
    }

    private static InnerNode createArrayElementAccessTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_arrayelem);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_bracket, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_bracket_in_array_reference", ARRAY_ACCESS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_bracket, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_bracket_in_array_reference", ARRAY_ACCESS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_bracket, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_bracket_in_array_reference", ARRAY_ACCESS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_brackets, "org.eclipse.php.formatter.core.formatter.insert_space_between_brackets_in_array_type_reference", ARRAY_ACCESS_PREVIEW);
        return root;
    }

    private static InnerNode createFunctionCallTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_calls);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_parens, "org.eclipse.php.formatter.core.formatter.insert_space_between_empty_parens_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_before_comma_in_method_args, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_method_invocation_arguments", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_after_comma_in_method_args, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_method_invocation_arguments", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_before_arrow_in_method, "org.eclipse.php.formatter.core.formatter.insert_space_before_arrow_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_after_arrow_in_method, "org.eclipse.php.formatter.core.formatter.insert_space_after_arrow_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_before_coloncolon_in_method, "org.eclipse.php.formatter.core.formatter.insert_space_before_coloncolon_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_after_coloncolon_in_method, "org.eclipse.php.formatter.core.formatter.insert_space_after_coloncolon_in_method_invocation", METHOD_CALL_PREVIEW);
        return root;
    }

    private static InnerNode createFieldAccessTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_fieldaccess);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_fieldaccess_before_arrow_in_field_acecss, "org.eclipse.php.formatter.core.formatter.insert_space_before_arrow_in_field_access", FIELD_ACCESS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_fieldaccess_after_arrow_in_field_acecss, "org.eclipse.php.formatter.core.formatter.insert_space_after_arrow_in_field_access", FIELD_ACCESS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_fieldaccess_before_coloncolon_in_field_acecss, "org.eclipse.php.formatter.core.formatter.insert_space_before_coloncolon_in_field_access", FIELD_ACCESS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_fieldaccess_after_coloncolon_in_field_acecss, "org.eclipse.php.formatter.core.formatter.insert_space_after_coloncolon_in_field_access", FIELD_ACCESS_PREVIEW);
        return root;
    }

    private static InnerNode createBlockTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_blocks);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_brace_in_block", BLOCK_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_closing_brace, "org.eclipse.php.formatter.core.formatter.insert_space_after_closing_brace_in_block", CATCH_PREVIEW);
        return root;
    }

    private static InnerNode createSwitchStatementTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_switch);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_switch_before_case_colon, "org.eclipse.php.formatter.core.formatter.insert_space_before_colon_in_case", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_switch_before_default_colon, "org.eclipse.php.formatter.core.formatter.insert_space_before_colon_in_default", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_brace_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_switch", SWITCH_PREVIEW);
        return root;
    }

    private static InnerNode createDoWhileTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_do);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_while", WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_while", WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_while", WHILE_PREVIEW);
        return root;
    }

    private static InnerNode createTryStatementTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_try);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_catch", CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_catch", CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_catch", CATCH_PREVIEW);
        return root;
    }

    private static InnerNode createStaticTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_static);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_static", STATIC_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_static", STATIC_PREVIEW);
        return root;
    }

    private static InnerNode createGlobalTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_global);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_global", GLOBAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_global", GLOBAL_PREVIEW);
        return root;
    }

    private static InnerNode createEchoTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_echo);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_echo", ECHO_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_echo", ECHO_PREVIEW);
        return root;
    }

    private static InnerNode createIfStatementTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_if);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_if", IF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_if", IF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_if", IF_PREVIEW);
        return root;
    }

    private static InnerNode createForStatementTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_for);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_for_before_comma, "org.eclipse.php.formatter.core.formatter.insert_space_before_comma_in_for_inits", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_for_after_comma, "org.eclipse.php.formatter.core.formatter.insert_space_after_comma_in_for_inits", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_semicolon, "org.eclipse.php.formatter.core.formatter.insert_space_before_semicolon_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_semicolon, "org.eclipse.php.formatter.core.formatter.insert_space_after_semicolon_in_for", FOR_PREVIEW);
        return root;
    }

    private static InnerNode createForeachStatementTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_foreach);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.php.formatter.core.formatter.insert_space_before_opening_paren_in_foreach", FOREACH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_foreach", FOREACH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_foreach", FOREACH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_foreach_before_arrow, "org.eclipse.php.formatter.core.formatter.insert_space_before_arrow_in_foreach", FOREACH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_foreach_after_arrow, "org.eclipse.php.formatter.core.formatter.insert_space_after_arrow_in_foreach", FOREACH_PREVIEW);
        return root;
    }

    private static InnerNode createYieldStatementTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_yield);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_yield_before_arrow, "org.eclipse.php.formatter.core.formatter.insert_space_before_arrow_in_yield", YIELD_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_yield_after_arrow, "org.eclipse.php.formatter.core.formatter.insert_space_after_arrow_in_yield", YIELD_PREVIEW);
        return root;
    }

    private static InnerNode createConditionalTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_conditionals);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_question, "org.eclipse.php.formatter.core.formatter.insert_space_before_question_in_conditional", CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_question, "org.eclipse.php.formatter.core.formatter.insert_space_after_question_in_conditional", CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_colon, "org.eclipse.php.formatter.core.formatter.insert_space_before_colon_in_conditional", CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_colon, "org.eclipse.php.formatter.core.formatter.insert_space_after_colon_in_conditional", CONDITIONAL_PREVIEW);
        return root;
    }

    private static InnerNode createParenthesisExpressionTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_paren_expr);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_parenthesized_expression", PARENTHESIS_EXPRESSION_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_parenthesized_expression", PARENTHESIS_EXPRESSION_PREVIEW);
        return root;
    }

    private static InnerNode createReferencedExpressionTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_ref_expr);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_reference_symbol, "org.eclipse.php.formatter.core.formatter.insert_space_after_reference_symbol_in_referenced_expression", REFERENCED_EXPRESSION_PREVIEW);
        return root;
    }

    private static InnerNode createTypecastTree(Map<String, Object> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_typecasts);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.php.formatter.core.formatter.insert_space_after_opening_paren_in_cast", CAST_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.php.formatter.core.formatter.insert_space_before_closing_paren_in_cast", CAST_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_closing_paren, "org.eclipse.php.formatter.core.formatter.insert_space_after_closing_paren_in_cast", CAST_PREVIEW);
        return root;
    }

    private static InnerNode createChild(InnerNode root, Map<String, Object> workingValues, String message) {
        return new InnerNode(root, workingValues, message);
    }

    private static OptionNode createOption(InnerNode root, Map<String, Object> workingValues, String message, String key, String snippet) {
        return new OptionNode(root, workingValues, message, key, snippet);
    }

    public static void makeIndexForNodes(List<Node> tree, List<Node> flatList) {
        for (Node node : tree) {
            node.index = flatList.size();
            flatList.add(node);
            WhiteSpaceOptions.makeIndexForNodes(node.getChildren(), flatList);
        }
    }

    public static class InnerNode
    extends Node {
        public InnerNode(InnerNode parent, Map<String, Object> workingValues, String messageKey) {
            super(parent, workingValues, messageKey);
        }

        @Override
        public void setChecked(boolean checked) {
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                ((Node)iter.next()).setChecked(checked);
            }
        }

        public void add(Node child) {
            this.fChildren.add(child);
        }

        @Override
        public List<String> getSnippets() {
            ArrayList<String> snippets = new ArrayList<String>(this.fChildren.size());
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                List<String> childSnippets = ((Node)iter.next()).getSnippets();
                for (String snippet : childSnippets) {
                    if (snippets.contains(snippet)) continue;
                    snippets.add(snippet);
                }
            }
            return snippets;
        }

        @Override
        public void getCheckedLeafs(List<Node> list) {
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                ((Node)iter.next()).getCheckedLeafs(list);
            }
        }
    }

    public static abstract class Node {
        private final InnerNode fParent;
        private final String fName;
        public int index;
        protected final Map<String, Object> fWorkingValues;
        protected final ArrayList<Node> fChildren;

        public Node(InnerNode parent, Map<String, Object> workingValues, String message) {
            if (workingValues == null || message == null) {
                throw new IllegalArgumentException();
            }
            this.fParent = parent;
            this.fWorkingValues = workingValues;
            this.fName = message;
            this.fChildren = new ArrayList();
            if (this.fParent != null) {
                this.fParent.add(this);
            }
        }

        public abstract void setChecked(boolean var1);

        public boolean hasChildren() {
            return !this.fChildren.isEmpty();
        }

        public List<Node> getChildren() {
            return Collections.unmodifiableList(this.fChildren);
        }

        public InnerNode getParent() {
            return this.fParent;
        }

        public final String toString() {
            return this.fName;
        }

        public abstract List<String> getSnippets();

        public abstract void getCheckedLeafs(List<Node> var1);
    }

    public static class OptionNode
    extends Node {
        private final String fKey;
        private final ArrayList<String> fSnippets;

        public OptionNode(InnerNode parent, Map<String, Object> workingValues, String messageKey, String key, String snippet) {
            super(parent, workingValues, messageKey);
            this.fKey = key;
            this.fSnippets = new ArrayList(1);
            this.fSnippets.add(snippet);
        }

        @Override
        public void setChecked(boolean checked) {
            this.fWorkingValues.put(this.fKey, checked ? "true" : "false");
        }

        public boolean getChecked() {
            return "true".equals(this.fWorkingValues.get(this.fKey));
        }

        @Override
        public List<String> getSnippets() {
            return this.fSnippets;
        }

        @Override
        public void getCheckedLeafs(List<Node> list) {
            if (this.getChecked()) {
                list.add(this);
            }
        }
    }
}

