/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug;

import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIThisVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;

public class TeamInstance
extends JDIThisVariable
implements IAdaptable {
    public static final int IS_INACTIVE = 0;
    public static final int IS_IMPLICITACTIVE = 1;
    public static final int IS_ACTIVE = 2;
    private List<TeamThread> _activethreads = new ArrayList<TeamThread>();
    private List<TeamThread> _deactivethreads = new ArrayList<TeamThread>();
    private List<TeamThread> _implicitActivethreads = new ArrayList<TeamThread>();
    private int _activationState;
    private TeamThread _globalThread = new TeamThread(-1L, 0L);
    private long _creationTime = System.currentTimeMillis();
    private long _activationTime = 0L;

    public TeamInstance(JDIThisVariable var) throws DebugException {
        super((JDIDebugTarget)var.getDebugTarget(), ((JDIObjectValue)var.getValue()).getUnderlyingObject());
    }

    public long getCreationTime() {
        return this._creationTime;
    }

    public long getActivationTime() {
        return this._activationTime;
    }

    public void setImplicitActiveForThreadID(long threadID) {
        TeamThread teamThread = new TeamThread(threadID, System.currentTimeMillis());
        this._implicitActivethreads.add(teamThread);
    }

    public void setImplicitInactiveForThreadID(long threadID) {
        TeamThread teamThread = new TeamThread(threadID, 0L);
        this._implicitActivethreads.remove(teamThread);
    }

    public void setActiveForThreadID(long threadID) {
        TeamThread teamThread = new TeamThread(threadID, System.currentTimeMillis());
        this._activethreads.add(teamThread);
        this._deactivethreads.remove(teamThread);
    }

    public void setInactiveForThreadID(long threadID) {
        TeamThread teamThread = new TeamThread(threadID, System.currentTimeMillis());
        this._activethreads.remove(teamThread);
        this._deactivethreads.add(teamThread);
    }

    public Object getAdapter(Class adapter) {
        return AdapterManager.getDefault().getAdapter((Object)this, adapter);
    }

    public int getActivationState(IDebugElement debugElement) {
        IThread thread = null;
        if (debugElement instanceof IStackFrame) {
            IStackFrame stackFrame = (IStackFrame)debugElement;
            thread = stackFrame.getThread();
        } else if (debugElement instanceof IThread) {
            thread = (IThread)debugElement;
        }
        if (thread != null) {
            return this.getActivationState(thread);
        }
        return this.globalActivationState();
    }

    public boolean isActiveFor(IThread thread) {
        boolean isActive = false;
        ThreadReference threadRef = null;
        if (thread != null) {
            threadRef = ((JDIThread)thread).getUnderlyingThread();
            TeamThread teamThread = new TeamThread(threadRef.uniqueID(), 0L);
            isActive = this._activethreads.contains(teamThread);
            if (isActive) {
                this.setActivationTime(this._activethreads.get((int)this._activethreads.indexOf((Object)teamThread)).time);
                return true;
            }
            if (this._deactivethreads.contains(teamThread)) {
                return false;
            }
        }
        if (!isActive) {
            isActive = this._activethreads.contains(this._globalThread);
        }
        return isActive;
    }

    public boolean isImplicitActiveFor(IThread thread) {
        ThreadReference threadRef = ((JDIThread)thread).getUnderlyingThread();
        long threadID = threadRef.uniqueID();
        TeamThread teamThread = new TeamThread(threadID, 0L);
        boolean isImplicitActive = this._implicitActivethreads.contains(teamThread);
        if (isImplicitActive) {
            this.setActivationTime(this._implicitActivethreads.get((int)this._implicitActivethreads.indexOf((Object)teamThread)).time);
        }
        return isImplicitActive;
    }

    public void setGlobalThreadID(long globalThreadID) {
        this._globalThread.threadID = globalThreadID;
    }

    private int getActivationState(IThread thread) {
        if (this.isActiveFor(thread)) {
            return 2;
        }
        if (this.isImplicitActiveFor(thread)) {
            return 1;
        }
        return 0;
    }

    private int globalActivationState() {
        if (this._activethreads.contains(this._globalThread)) {
            return 2;
        }
        return 0;
    }

    private void setActivationTime(long time) {
        this._activationTime = time;
    }

    private class TeamThread {
        public long threadID = 0L;
        public long time = 0L;

        public TeamThread(long threadID, long time) {
            this.threadID = threadID;
            this.time = time;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TeamThread) {
                return this.threadID == ((TeamThread)obj).threadID;
            }
            return super.equals(obj);
        }

        public String toString() {
            return "threadID=" + this.threadID + ",time=" + this.time;
        }
    }
}

