/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.omg.kdm.code;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ExportKind implements Enumerator
{
    PUBLIC(0, "public", "public"),
    PRIVATE(1, "private", "private"),
    PROTECTED(2, "protected", "protected"),
    FINAL(3, "final", "final"),
    UNKNOWN(4, "unknown", "unknown");

    public static final int PUBLIC_VALUE = 0;
    public static final int PRIVATE_VALUE = 1;
    public static final int PROTECTED_VALUE = 2;
    public static final int FINAL_VALUE = 3;
    public static final int UNKNOWN_VALUE = 4;
    private static final ExportKind[] VALUES_ARRAY;
    public static final List<ExportKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExportKind[]{PUBLIC, PRIVATE, PROTECTED, FINAL, UNKNOWN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExportKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExportKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExportKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExportKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExportKind get(int value) {
        switch (value) {
            case 0: {
                return PUBLIC;
            }
            case 1: {
                return PRIVATE;
            }
            case 2: {
                return PROTECTED;
            }
            case 3: {
                return FINAL;
            }
            case 4: {
                return UNKNOWN;
            }
        }
        return null;
    }

    private ExportKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

