/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.refactoring.rename;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.m2e.refactoring.Messages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MavenRenameWizardPage
extends UserInputWizardPage {
    private Text groupIdText;
    private Text artifactIdText;
    private Text versionText;
    private Button renameCheckbox;
    private String groupId;
    private String artifactId;
    private String version;
    private String newGroupId = "";
    private String newArtifactId = "";
    private String newVersion = "";
    private boolean renamed;

    protected MavenRenameWizardPage() {
        super("MavenRenameWizardPage");
        this.setDescription(Messages.MavenRenameWizardPage_desc);
        this.setTitle(Messages.MavenRenameWizardPage_title);
    }

    public void initialize(String groupId, String artifactID, String version) {
        this.groupId = this.newGroupId = this.nvl(groupId);
        this.artifactId = this.newArtifactId = this.nvl(artifactID);
        this.version = this.newVersion = this.nvl(version);
    }

    public String getNewGroupId() {
        return this.newGroupId;
    }

    public String getNewArtifactId() {
        return this.newArtifactId;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public boolean isPageComplete() {
        boolean renamedArtifact = !this.newArtifactId.equals(this.artifactId);
        this.renameCheckbox.setEnabled(renamedArtifact);
        if (!renamedArtifact) {
            this.renameCheckbox.setSelection(false);
            this.renamed = false;
        }
        return !this.newGroupId.equals(this.groupId) || renamedArtifact || !this.newVersion.equals(this.version) || !this.isCurrentPage();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        composite.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        Label groupIdLabel = new Label(composite, 0);
        groupIdLabel.setLayoutData((Object)new GridData());
        groupIdLabel.setText(Messages.MavenRenameWizardPage_lblGroupId);
        this.groupIdText = new Text(composite, 2048);
        this.groupIdText.setLayoutData((Object)new GridData(768));
        this.groupIdText.setData("name", (Object)"groupId");
        Label artifactIdLabel = new Label(composite, 0);
        artifactIdLabel.setLayoutData((Object)new GridData());
        artifactIdLabel.setText(Messages.MavenRenameWizardPage_lblArtifactId);
        this.artifactIdText = new Text(composite, 2048);
        this.artifactIdText.setLayoutData((Object)new GridData(768));
        this.artifactIdText.setData("name", (Object)"artifactId");
        Label versionLabel = new Label(composite, 0);
        versionLabel.setLayoutData((Object)new GridData());
        versionLabel.setText(Messages.MavenRenameWizardPage_lblVersion);
        this.versionText = new Text(composite, 2048);
        this.versionText.setLayoutData((Object)new GridData(768));
        this.versionText.setData("name", (Object)"version");
        new Label(composite, 0);
        this.renameCheckbox = new Button(composite, 32);
        this.renameCheckbox.setText(Messages.MavenRenameWizardPage_cbRenameWorkspace);
        this.renameCheckbox.setLayoutData((Object)new GridData(768));
        this.renameCheckbox.setData("name", (Object)"rename");
        this.renameCheckbox.setEnabled(false);
        this.renameCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenRenameWizardPage.this.renamed = MavenRenameWizardPage.this.renameCheckbox.getSelection();
                MavenRenameWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        ModifyListener listener = e -> {
            this.newGroupId = this.groupIdText.getText();
            this.newArtifactId = this.artifactIdText.getText();
            this.newVersion = this.versionText.getText();
            this.getWizard().getContainer().updateButtons();
        };
        this.groupIdText.setText(this.groupId);
        this.artifactIdText.setText(this.artifactId);
        this.versionText.setText(this.version);
        this.groupIdText.addModifyListener(listener);
        this.artifactIdText.addModifyListener(listener);
        this.versionText.addModifyListener(listener);
    }

    private String nvl(String str) {
        return str == null ? "" : str;
    }

    public boolean getRenameEclipseProject() {
        return this.renamed;
    }
}

