/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.internal.lifecycle;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.ui.internal.UpdateMavenProjectJob;
import org.eclipse.m2e.editor.xml.internal.Messages;
import org.eclipse.m2e.editor.xml.internal.lifecycle.AbstractLifecycleMappingResolution;
import org.eclipse.osgi.util.NLS;

public class WorkspaceLifecycleMappingResolution
extends AbstractLifecycleMappingResolution {
    public WorkspaceLifecycleMappingResolution(IMarker marker, PluginExecutionAction action) {
        super(marker, action);
    }

    public int getOrder() {
        return 60;
    }

    protected void fix(IDocument document, List<IMarker> markers, IProgressMonitor monitor) {
        this.doFix(markers, monitor);
    }

    protected void fix(IResource resource, List<IMarker> markers, IProgressMonitor monitor) {
        this.doFix(markers, monitor);
    }

    public String getLabel() {
        String goal = this.getMarker().getAttribute("goal", "");
        return NLS.bind((String)Messages.LifecycleMappingProposal_workspaceIgnore_label, (Object)goal);
    }

    private void doFix(List<IMarker> markers, IProgressMonitor monitor) {
        LifecycleMappingMetadataSource mapping = LifecycleMappingFactory.getWorkspaceMetadata((boolean)true);
        for (IMarker marker : markers) {
            this.addMapping(mapping, marker);
        }
        LifecycleMappingFactory.writeWorkspaceMetadata((LifecycleMappingMetadataSource)mapping);
        new UpdateMavenProjectJob(WorkspaceLifecycleMappingResolution.toArray(this.getProjects(markers.stream()))).schedule();
    }

    private void addMapping(LifecycleMappingMetadataSource mapping, IMarker marker) {
        String groupId = marker.getAttribute("groupId", "");
        String artifactId = marker.getAttribute("artifactId", "");
        String version = marker.getAttribute("version", "");
        String[] goals = new String[]{marker.getAttribute("goal", "")};
        LifecycleMappingFactory.addLifecyclePluginExecution((LifecycleMappingMetadataSource)mapping, (String)groupId, (String)artifactId, (String)version, (String[])goals, (PluginExecutionAction)this.action);
    }

    private static IProject[] toArray(Set<IProject> projects) {
        return projects.toArray(new IProject[projects.size()]);
    }
}

