/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.views;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.eef.runtime.ui.widgets.masterdetails.AbstractEEFMasterDetailsBlock;
import org.eclipse.emf.eef.runtime.ui.widgets.masterdetails.tree.EEFTreeMasterDetailsBlock;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EEFView
extends ViewPart
implements IEditingDomainProvider {
    private FormToolkit toolkit;
    protected ManagedForm form;
    protected AbstractEEFMasterDetailsBlock block;
    private IPartListener2 partListener;

    public FormToolkit getToolkit() {
        if (this.toolkit == null) {
            this.toolkit = new FormToolkit(Display.getCurrent());
        }
        return this.toolkit;
    }

    public void setToolkit(FormToolkit toolkit) {
        this.toolkit = toolkit;
    }

    public AdapterFactory getAdapterFactory() {
        return this.block.getAdapterFactory();
    }

    public void setAdapterFactory(ComposedAdapterFactory adapterFactory) {
        this.block.setAdapterFactory((AdapterFactory)adapterFactory);
    }

    public EditingDomain getEditingDomain() {
        return this.block.getEditingDomain();
    }

    public void setEditingDomain(EditingDomain editingDomain) {
        this.block.setEditingDomain(editingDomain);
    }

    public void createPartControl(Composite parent) {
        this.form = new ManagedForm(parent);
        this.block = new EEFTreeMasterDetailsBlock(){

            @Override
            protected List<Action> additionalPageActions() {
                return EEFView.this.additionalPageUserActions();
            }
        };
        this.block.createContent((IManagedForm)this.form);
        this.block.getMasterPart().addSelectionChangeListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EEFView.this.form.fireSelectionChanged((IFormPart)EEFView.this.block.getMasterPart(), event.getSelection());
            }
        });
        this.createContextMenuFor(this.block.getMasterPart().getModelViewer());
        this.getSite().getPage().addPartListener(this.getPartListener());
    }

    protected IPartListener2 getPartListener() {
        this.partListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                IWorkbenchPart part = partRef.getPart(false);
                if (part instanceof IEditorPart && part instanceof IEditingDomainProvider) {
                    IEditingDomainProvider editingDomainProvider = (IEditingDomainProvider)part;
                    EditingDomain editingDomain = editingDomainProvider.getEditingDomain();
                    EEFView.this.setEditingDomain(editingDomain);
                    EEFView.this.editingDomainChanged(editingDomain);
                }
            }
        };
        return this.partListener;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
    }

    protected List<Action> additionalPageUserActions() {
        return null;
    }

    public void setFocus() {
    }

    public void dispose() {
        if (this.partListener != null) {
            this.getSite().getPage().removePartListener(this.partListener);
        }
        super.dispose();
    }

    protected void editingDomainChanged(EditingDomain editingDomain) {
        this.block.setInput(editingDomain.getResourceSet());
    }
}

