/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.extended.flow;

import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.eef.EEFGen.EEFGenModel;
import org.eclipse.emf.eef.codegen.core.util.EMFHelper;
import org.eclipse.emf.eef.codegen.extended.initializer.EEFEditorModelInitializer;
import org.eclipse.emf.eef.codegen.flow.Step;
import org.eclipse.emf.eef.codegen.flow.util.GenmodelHelper;
import org.eclipse.emf.eef.codegen.flow.var.WorkflowVariable;

public class GenerateEEFEditorModels
extends Step {
    private EEFEditorModelInitializer eefeditorModelInitializer;
    private Object modelURI;
    private Object editGenProject;
    private Object genmodelURI;
    private WorkflowVariable eefgenModelVar;
    private Object modelsFolder;

    public GenerateEEFEditorModels(String name, Object modelURI, Object editGenProject, Object genmodelURI, Object modelsFolder) {
        super(name);
        this.modelURI = modelURI;
        this.editGenProject = editGenProject;
        this.genmodelURI = genmodelURI;
        this.modelsFolder = modelsFolder;
    }

    public IStatus execute(IProgressMonitor monitor) {
        try {
            IProject editProject = this.getEditProject();
            if (editProject != null) {
                this.eefeditorModelInitializer = new EEFEditorModelInitializer();
                this.initializeEEFModels(this.getModelsFolder(), this.getGenModelURI());
                EEFGenModel eefgenModel = this.generatedEEFGen(this.getModelURI(), this.getModelsFolder());
                ((WorkflowVariable)this.getEEFGenModel()).setValue((Object)eefgenModel);
                return Status.OK_STATUS;
            }
            return new Status(4, "org.eclipse.emf.eef.codegen", "Unable to find edit project");
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.emf.eef.codegen", "An error occured during EEF models initialization.", (Throwable)e);
        }
        catch (CoreException e) {
            return new Status(4, "org.eclipse.emf.eef.codegen", "An error occured during EEF models initialization.", (Throwable)e);
        }
    }

    public Object getEEFGenModel() {
        if (this.eefgenModelVar == null) {
            this.eefgenModelVar = new WorkflowVariable(this.eefgenmodelVarName());
        }
        return this.eefgenModelVar;
    }

    private final String eefgenmodelVarName() {
        return "GEN_EEF_EDITOR_MODEL_" + this.name + "_EEFGENMODEL";
    }

    private URI getModelURI() {
        if (this.modelURI instanceof URI) {
            return (URI)this.modelURI;
        }
        if (this.modelURI instanceof WorkflowVariable) {
            return (URI)((WorkflowVariable)this.modelURI).getValue();
        }
        return null;
    }

    private URI getGenModelURI() {
        if (this.genmodelURI instanceof URI) {
            return (URI)this.genmodelURI;
        }
        if (this.genmodelURI instanceof WorkflowVariable) {
            return (URI)((WorkflowVariable)this.genmodelURI).getValue();
        }
        return null;
    }

    private IProject getEditProject() {
        if (this.editGenProject instanceof IProject) {
            return (IProject)this.editGenProject;
        }
        if (this.editGenProject instanceof WorkflowVariable) {
            return (IProject)((WorkflowVariable)this.editGenProject).getValue();
        }
        return null;
    }

    private IFolder getModelsFolder() {
        if (this.modelsFolder instanceof IFolder) {
            return (IFolder)this.modelsFolder;
        }
        if (this.modelsFolder instanceof WorkflowVariable) {
            return (IFolder)((WorkflowVariable)this.modelsFolder).getValue();
        }
        return null;
    }

    private void initializeEEFModels(IFolder modelsFolder, URI genmodelURI) throws IOException, CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.eefeditorModelInitializer.initialize(genmodelURI, (IContainer)modelsFolder);
        modelsFolder.refreshLocal(2, (IProgressMonitor)monitor);
    }

    private EEFGenModel generatedEEFGen(URI modelURI, IFolder modelsFolder) throws IOException {
        EEFGenModel eefgenModel = null;
        URI eefgenURI = GenmodelHelper.computeEditorEEFGenModelURI((IContainer)modelsFolder, (URI)modelURI);
        EObject extractedEEFGenModel = EMFHelper.load((URI)eefgenURI, (ResourceSet)this.resourceSet);
        if (extractedEEFGenModel instanceof EEFGenModel) {
            eefgenModel = (EEFGenModel)extractedEEFGenModel;
        }
        return eefgenModel;
    }
}

