/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.importexport.breakpoints;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.core.BreakpointManager;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.importexport.breakpoints.BreakpointsPathDecorator;
import org.eclipse.debug.internal.ui.importexport.breakpoints.EmbeddedBreakpointsViewer;
import org.eclipse.debug.internal.ui.importexport.breakpoints.ImportExportMessages;
import org.eclipse.debug.internal.ui.importexport.breakpoints.WizardImportBreakpointsPage;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewer;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.ImportBreakpointsOperation;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class WizardImportBreakpointsSelectionPage
extends WizardPage {
    private EmbeddedBreakpointsViewer fTView;
    private boolean fIsVisible;

    protected WizardImportBreakpointsSelectionPage(String pageName) {
        super(pageName, ImportExportMessages.WizardImportBreakpointsSelectionPage_2, null);
    }

    public void createControl(Composite parent) {
        this.setDescription(ImportExportMessages.WizardImportBreakpointsSelectionPage_1);
        Composite composite = SWTFactory.createComposite(parent, 1, 1, 1808);
        SWTFactory.createLabel(composite, ImportExportMessages.WizardExportBreakpointsPage_2, 1);
        BreakpointManager breakpointManager = new BreakpointManager();
        this.fTView = new EmbeddedBreakpointsViewer(composite, breakpointManager, null);
        BreakpointsViewer viewer = this.fTView.getViewer();
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)viewer.getLabelProvider(), (ILabelDecorator)new BreakpointsPathDecorator()));
        this.setControl((Control)composite);
    }

    public List<IMarker> getSelectedMarkers() {
        if (!this.fIsVisible) {
            return null;
        }
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        List breakpoints = this.fTView.getCheckedElements().toList();
        for (IBreakpoint breakpoint : breakpoints) {
            markers.add(breakpoint.getMarker());
        }
        return markers;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fIsVisible = true;
            try {
                this.updateBreakpointsPreviewList(this.fTView);
            }
            catch (Exception e) {
                this.setErrorMessage(e.getMessage());
            }
        } else {
            this.fIsVisible = false;
        }
        super.setVisible(visible);
    }

    private void updateBreakpointsPreviewList(EmbeddedBreakpointsViewer currentTView) throws InvocationTargetException, InterruptedException {
        this.getContainer().run(false, true, monitor -> {
            IBreakpoint[] importedBreakpoints;
            WizardImportBreakpointsPage mainPage = (WizardImportBreakpointsPage)this.getWizard().getPage(ImportExportMessages.WizardImportBreakpoints_0);
            ImportBreakpointsOperation operation = new ImportBreakpointsOperation(mainPage.getFileNameField().getText().trim(), mainPage.getAutoRemoveDuplicates(), false, false);
            operation.run(monitor);
            BreakpointContainer breakpointManager = new BreakpointContainer(null, null);
            IBreakpoint[] iBreakpointArray = importedBreakpoints = operation.getImportedBreakpoints();
            int n = importedBreakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint importedBreakpoint = iBreakpointArray[n2];
                breakpointManager.addBreakpoint(importedBreakpoint, new ModelDelta(null, 1));
                ++n2;
            }
            currentTView.getViewer().setInput(breakpointManager);
            currentTView.getViewer().refresh();
        });
    }

    public Image getImage() {
        return DebugUITools.getImage("IMG_WIZBAN_IMPORT_BREAKPOINTS");
    }
}

