/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.action;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectEditModel;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.action.IEditSchemaObjectAction;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.action.Messages;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.SchemaObjectEditor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.SOEUIPlugin;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.SchemaObjectEditorUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;

public class EditSchemaObjectAction
extends Action
implements IEditSchemaObjectAction {
    private ISchemaObjectEditModel _modelObj;
    private String _vendorName;
    private String _version;
    private String _objectTypeId;
    private String _editorId;
    private DatabaseIdentifier _databaseIdentifier;
    private IEditorPart _part;
    protected SQLObject _sqlObject;
    private String _defaultPageId;

    public EditSchemaObjectAction(SQLObject obj, ISchemaObjectEditModel modelObj) {
        this._sqlObject = obj;
        this._modelObj = modelObj;
    }

    public EditSchemaObjectAction(String vendorName, String version, String objectTypeId, ISchemaObjectEditModel modelObj, DatabaseIdentifier databaseIdentifier) {
        this._vendorName = vendorName;
        this._version = version;
        this._objectTypeId = objectTypeId;
        this._modelObj = modelObj;
        this._databaseIdentifier = databaseIdentifier;
    }

    public EditSchemaObjectAction(String vendorName, String version, String objectTypeId, String text, int style, ISchemaObjectEditModel modelObj, DatabaseIdentifier databaseIdentifier) {
        super(text, style);
        this._vendorName = vendorName;
        this._version = version;
        this._objectTypeId = objectTypeId;
        this._modelObj = modelObj;
        this._databaseIdentifier = databaseIdentifier;
    }

    public EditSchemaObjectAction(String vendorName, String version, String objectTypeId, String text, ISchemaObjectEditModel modelObj) {
        super(text);
        this._vendorName = vendorName;
        this._version = version;
        this._objectTypeId = objectTypeId;
        this._modelObj = modelObj;
    }

    public EditSchemaObjectAction(String vendorName, String version, String objectTypeId, String text, ImageDescriptor image, ISchemaObjectEditModel modelObj) {
        super(text, image);
        this._vendorName = vendorName;
        this._version = version;
        this._objectTypeId = objectTypeId;
        this._modelObj = modelObj;
    }

    public EditSchemaObjectAction() {
    }

    public EditSchemaObjectAction(String text, ImageDescriptor image) {
        super(text, image);
    }

    public EditSchemaObjectAction(String text, int style) {
        super(text, style);
    }

    public EditSchemaObjectAction(String text) {
        super(text);
    }

    public void run() {
        OpenSchemaEditorJob job = new OpenSchemaEditorJob(Messages.EditSchemaObjectAction_opening);
        job.setUser(true);
        job.schedule();
    }

    public void run(IProgressMonitor monitor) {
        SOEUIPlugin.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                EditSchemaObjectAction.this.checkAndOpenEditor();
                EditSchemaObjectAction.this.setActivePage();
            }
        });
    }

    public void checkAndOpenEditor() {
        if (this._modelObj == null) {
            String[] buttons = new String[]{IDialogConstants.OK_LABEL};
            MessageDialog d = new MessageDialog(SOEUIPlugin.getActiveWorkbenchShell(), Messages.EditSchemaObjectAction_error, null, Messages.EditSchemaObjectAction_model_null, 1, buttons, 0);
            d.open();
            return;
        }
        if (this._editorId != null && this._editorId.trim().length() != 0) {
            this._part = SchemaObjectEditorUtils.openEditor(this._editorId, this._modelObj, this._databaseIdentifier);
        }
        if (this._vendorName == null || this._version == null || this._objectTypeId == null || this._databaseIdentifier == null) {
            boolean calculated = false;
            if (this._sqlObject != null) {
                EObject root = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)this._sqlObject);
                if (root != null && root instanceof Database) {
                    calculated = true;
                    Database db = (Database)root;
                    if (this._vendorName == null) {
                        this._vendorName = db.getVendor();
                    }
                    if (this._version == null) {
                        this._version = db.getVersion();
                    }
                    if (this._databaseIdentifier == null) {
                        SQLDevToolsUtil.getDatabaseIdentifier((SQLObject)this._sqlObject);
                    }
                    if (this._objectTypeId == null) {
                        this._objectTypeId = String.valueOf(this._sqlObject.eClass().getEPackage().getName()) + "." + this._sqlObject.eClass().getName();
                    }
                }
            } else if (!calculated) {
                String[] buttons = new String[]{IDialogConstants.OK_LABEL};
                MessageDialog d = new MessageDialog(SOEUIPlugin.getActiveWorkbenchShell(), Messages.EditSchemaObjectAction_error, null, Messages.EditSchemaObjectAction_no_vendor_name, 1, buttons, 0);
                d.open();
                return;
            }
        }
        this._part = SchemaObjectEditorUtils.openEditor(this._vendorName, this._version, this._objectTypeId, this._modelObj, this._databaseIdentifier);
    }

    public String getEditorId() {
        return this._editorId;
    }

    public void setEditorId(String id) {
        this._editorId = id;
    }

    public Object getModelObj() {
        return this._modelObj;
    }

    public void setModelObj(ISchemaObjectEditModel obj) {
        this._modelObj = obj;
    }

    public String getObjectTypeId() {
        return this._objectTypeId;
    }

    public void setObjectTypeId(String typeId) {
        this._objectTypeId = typeId;
    }

    public String getVendorName() {
        return this._vendorName;
    }

    public void setVendorName(String name) {
        this._vendorName = name;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String _version) {
        this._version = _version;
    }

    public IEditorPart getPart() {
        return this._part;
    }

    public DatabaseIdentifier getDatabaseIdentifier() {
        return this._databaseIdentifier;
    }

    public void setDatabaseIdentifier(DatabaseIdentifier identifier) {
        this._databaseIdentifier = identifier;
    }

    public SQLObject getSQLObject() {
        return this._sqlObject;
    }

    @Override
    public void setSQLObject(SQLObject object) {
        this._sqlObject = object;
    }

    @Override
    public void setDefaultPageId(String defaultPageId) {
        this._defaultPageId = defaultPageId;
    }

    protected void setActivePage() {
        if (this._defaultPageId != null && this._part instanceof SchemaObjectEditor) {
            ((SchemaObjectEditor)this._part).setActivePage(this._defaultPageId);
        }
    }

    class OpenSchemaEditorJob
    extends Job {
        public OpenSchemaEditorJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor == null) {
                monitor = manager.createProgressGroup();
            }
            monitor.beginTask(Messages.EditSchemaObjectAction_open_schema_editor, -1);
            EditSchemaObjectAction.this.run(monitor);
            return Status.OK_STATUS;
        }
    }
}

