/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext.painter;

import java.util.Arrays;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class ResourceHelper {
    private ResourceHelper() {
    }

    public static Color getColor(String rgbString) {
        if (!JFaceResources.getColorRegistry().hasValueFor(rgbString)) {
            String rgbValues = rgbString.substring(rgbString.indexOf(40) + 1, rgbString.lastIndexOf(41));
            String[] values = rgbValues.split(",");
            try {
                int red = Integer.valueOf(values[0].trim());
                int green = Integer.valueOf(values[1].trim());
                int blue = Integer.valueOf(values[2].trim());
                JFaceResources.getColorRegistry().put(rgbString, new RGB(red, green, blue));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return JFaceResources.getColorRegistry().get(rgbString);
    }

    public static Font getFont(FontData ... fontDatas) {
        StringBuilder keyBuilder = new StringBuilder();
        FontData[] fontDataArray = fontDatas;
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            keyBuilder.append(fontData.toString());
            ++n2;
        }
        String key = keyBuilder.toString();
        if (!JFaceResources.getFontRegistry().hasValueFor(key)) {
            JFaceResources.getFontRegistry().put(key, fontDatas);
        }
        return JFaceResources.getFont((String)key);
    }

    public static Font getFont(Font currentFont, String name, Integer size) {
        FontData[] fontData;
        FontData[] original = currentFont.getFontData();
        FontData[] fontDataArray = fontData = Arrays.copyOf(original, original.length);
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            if (name != null) {
                data.setName(name);
            }
            if (size != null) {
                data.setHeight(size.intValue());
            }
            ++n2;
        }
        return ResourceHelper.getFont(fontData);
    }

    public static Font getBoldFont(Font currentFont) {
        FontData[] fontData;
        FontData[] original = currentFont.getFontData();
        FontData[] fontDataArray = fontData = Arrays.copyOf(original, original.length);
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setStyle(data.getStyle() | 1);
            ++n2;
        }
        return ResourceHelper.getFont(fontData);
    }

    public static Font getItalicFont(Font currentFont) {
        FontData[] fontData;
        FontData[] original = currentFont.getFontData();
        FontData[] fontDataArray = fontData = Arrays.copyOf(original, original.length);
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setStyle(data.getStyle() | 2);
            ++n2;
        }
        return ResourceHelper.getFont(fontData);
    }

    public static String ltrim(String s) {
        int i = 0;
        while (i < s.length() && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        return s.substring(i);
    }

    public static String rtrim(String s) {
        int i = s.length() - 1;
        while (i >= 0 && Character.isWhitespace(s.charAt(i))) {
            --i;
        }
        return s.substring(0, i + 1);
    }
}

