/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.equinox;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.libra.framework.core.FrameworkInstanceConfiguration;
import org.eclipse.libra.framework.core.FrameworkInstanceDelegate;
import org.eclipse.libra.framework.core.OSGIFrameworkInstanceBehaviorDelegate;
import org.eclipse.libra.framework.core.TargetDefinitionUtil;
import org.eclipse.libra.framework.core.Trace;
import org.eclipse.libra.framework.equinox.EquinoxFramework;
import org.eclipse.libra.framework.equinox.IEquinoxFrameworkInstance;
import org.eclipse.libra.framework.equinox.IEquinoxVersionHandler;
import org.eclipse.libra.framework.equinox.Messages;
import org.eclipse.libra.framework.equinox.internal.EquinoxFrameworkInstanceBehavior;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;

public class EquinoxFrameworkInstance
extends FrameworkInstanceDelegate
implements IEquinoxFrameworkInstance {
    protected transient IEquinoxVersionHandler versionHandler;

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        IStatus status = super.canModifyModules(add, remove);
        if (!status.isOK()) {
            return status;
        }
        if (this.getEquinoxVersionHandler() == null) {
            return new Status(4, "org.eclipse.libra.framework.equinox", 0, Messages.errorNoRuntime, null);
        }
        if (add != null) {
            int size = add.length;
            int i = 0;
            while (i < size) {
                IModule module = add[i];
                IStatus status2 = this.getEquinoxVersionHandler().canAddModule(module);
                if (status2 != null && !status2.isOK()) {
                    return status2;
                }
                ++i;
            }
        }
        return Status.OK_STATUS;
    }

    public void setDefaults(IProgressMonitor monitor) {
        super.setDefaults(monitor);
        try {
            this.getEquinoxConfiguration();
        }
        catch (CoreException e) {
            Trace.trace((byte)2, (String)"Can't setup for Equinox configuration.", (Throwable)e);
        }
    }

    public void importRuntimeConfiguration(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        super.importRuntimeConfiguration(runtime, monitor);
        OSGIFrameworkInstanceBehaviorDelegate fsb = (OSGIFrameworkInstanceBehaviorDelegate)this.getServer().loadAdapter(EquinoxFrameworkInstanceBehavior.class, null);
        if (fsb != null) {
            IPath tempDir = fsb.getTempDirectory();
            if (!tempDir.isAbsolute()) {
                IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                tempDir = rootPath.append(tempDir);
            }
            this.setInstanceDirectory(tempDir.toPortableString());
        }
        try {
            this.getEquinoxConfiguration();
        }
        catch (CoreException e) {
            Trace.trace((byte)2, (String)"Can't setup for Equinox configuration.", (Throwable)e);
        }
    }

    public EquinoxFramework getEquinoxRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        return (EquinoxFramework)this.getServer().getRuntime().loadAdapter(EquinoxFramework.class, null);
    }

    public IEquinoxVersionHandler getEquinoxVersionHandler() {
        if (this.versionHandler == null) {
            if (this.getServer().getRuntime() == null || this.getEquinoxRuntime() == null) {
                return null;
            }
            this.versionHandler = this.getEquinoxRuntime().getVersionHandler();
        }
        return this.versionHandler;
    }

    public FrameworkInstanceConfiguration getEquinoxConfiguration() throws CoreException {
        return this.getFrameworkInstanceConfiguration();
    }

    public ITargetDefinition createDefaultTarget() throws CoreException {
        ITargetPlatformService service = TargetDefinitionUtil.getTargetPlatformService();
        ITargetDefinition targetDefinition = service.newTarget();
        targetDefinition.setName(this.getServer().getName());
        targetDefinition.resolve((IProgressMonitor)new NullProgressMonitor());
        service.saveTargetDefinition(targetDefinition);
        return targetDefinition;
    }

    public String getFrameworkJarPath() {
        IPath installPath = this.getServer().getRuntime().getLocation();
        IPath plugins = installPath.append("plugins");
        if (plugins.toFile().exists()) {
            File[] files;
            File[] fileArray = files = plugins.toFile().listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().indexOf("org.eclipse.osgi_") > -1) {
                    return file.getAbsolutePath();
                }
                ++n2;
            }
        }
        return null;
    }
}

