/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.model.aspects.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jwt.we.conf.model.Aspect;
import org.eclipse.jwt.we.conf.model.ConfModel;
import org.eclipse.jwt.we.conf.model.Profile;
import org.eclipse.jwt.we.conf.model.aspects.ConfRegistry;
import org.eclipse.jwt.we.conf.model.plugin.ConfPlugin;
import org.eclipse.jwt.we.conf.model.plugin.internal.Logger;
import org.eclipse.jwt.we.conf.model.resource.ConfModelResourceManager;
import org.eclipse.jwt.we.conf.model.resource.ConfResourceException;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfRegistryImpl
implements ConfRegistry {
    public static final String CONF_EXTENSION_POINT_CONF_FILE = "file";
    protected static Logger logger = Logger.getLogger(ConfRegistryImpl.class);
    protected List<ConfModel> declaredConfs = new ArrayList<ConfModel>();
    protected List<ConfModel> discoveredConfs = new ArrayList<ConfModel>();
    protected List<ConfModel> installedConfs = new ArrayList<ConfModel>();
    private boolean inited = false;
    private ArrayList<Profile> installedProfilesCache = new ArrayList();
    private Map<String, Profile> idToInstalledProfileMapCache = new HashMap<String, Profile>();
    private Map<String, Aspect> idToInstalledAspectsMapCache = new HashMap<String, Aspect>();

    protected ConfRegistryImpl() {
    }

    public static ConfRegistry createConfRegistry() {
        ConfRegistryImpl confRegistry = new ConfRegistryImpl();
        confRegistry.init();
        return confRegistry;
    }

    @Override
    public Aspect getInstalledAspect(String aspectId) {
        if (aspectId == null || aspectId.length() == 0) {
            return null;
        }
        return this.idToInstalledAspectsMapCache.get(aspectId);
    }

    @Override
    public Profile getInstalledProfile(String profileId) {
        if (profileId == null || profileId.length() == 0) {
            return null;
        }
        return this.idToInstalledProfileMapCache.get(profileId);
    }

    @Override
    public ArrayList<Profile> getInstalledProfiles() {
        return this.installedProfilesCache;
    }

    @Override
    public void addDiscoveredConf(ConfModel confModel) {
        this.discoveredConfs.add(confModel);
        this.installedConfs.add(confModel);
        if (this.inited) {
            this.rebuildConfCaches();
        }
    }

    @Override
    public void addDeclaredConf(ConfModel confModel) {
        this.declaredConfs.add(confModel);
        this.installedConfs.add(confModel);
        if (this.inited) {
            this.rebuildConfCaches();
        }
    }

    @Override
    public List<ConfModel> getDeclaredConfs() {
        return this.declaredConfs;
    }

    @Override
    public List<ConfModel> getDiscoveredConfs() {
        return this.discoveredConfs;
    }

    @Override
    public List<ConfModel> getInstalledConfs() {
        return this.installedConfs;
    }

    protected void init() {
        this.inited = false;
        this.collectConfModels();
        this.rebuildConfCaches();
        this.inited = true;
    }

    protected void rebuildConfCaches() {
        this.rebuildInstalledProfilesCache();
        this.rebuildIdToInstalledProfileMapCache();
        this.rebuildIdToInstalledAspectMapCache();
    }

    protected void rebuildInstalledProfilesCache() {
        this.installedProfilesCache.clear();
        for (ConfModel confModel : this.getInstalledConfs()) {
            this.installedProfilesCache.addAll((Collection<Profile>)confModel.getProfiles());
        }
    }

    protected void rebuildIdToInstalledProfileMapCache() {
        this.idToInstalledProfileMapCache.clear();
        for (Profile profile : this.getInstalledProfiles()) {
            this.idToInstalledProfileMapCache.put(profile.getName(), profile);
        }
    }

    protected void rebuildIdToInstalledAspectMapCache() {
        this.idToInstalledAspectsMapCache.clear();
        for (Profile profile : this.getInstalledProfiles()) {
            this.idToInstalledProfileMapCache.put(profile.getName(), profile);
            for (Aspect aspect : profile.getAspects()) {
                this.idToInstalledAspectsMapCache.put(aspect.getId(), aspect);
            }
        }
    }

    protected void collectConfModels() {
        try {
            this.loadDeclaredConfs();
            this.loadDiscoveredConfs();
        }
        catch (Exception ex) {
            logger.severe("Error collecting ConfModels", ex);
        }
    }

    public void loadDiscoveredConfs() throws IOException {
        URL conffullpath;
        URL confpath = ConfPlugin.getPlugin().getBundle().getEntry("conf/");
        File confdir = null;
        if (confpath != null && (conffullpath = FileLocator.resolve((URL)confpath)) != null) {
            confdir = new Path(FileLocator.toFileURL((URL)confpath).getPath()).toFile();
        }
        if (confdir == null) {
            confdir = new File("conf/");
        }
        if (!(confdir.exists() && confdir.isDirectory() && confdir.canRead())) {
            logger.debug("Conf discovery directory at " + confdir.getAbsolutePath() + " can't be read, aborting conf discovery");
            return;
        }
        this.loadDiscoveredConfs(confdir);
    }

    protected void loadDiscoveredConfs(File confdir) {
        int i = 0;
        while (i < confdir.listFiles().length) {
            block10: {
                File discoveredConfFile = confdir.listFiles()[i];
                if (!discoveredConfFile.isFile()) {
                    if (!discoveredConfFile.isDirectory() || !discoveredConfFile.canRead()) {
                        logger.debug("Conf subdirectory at " + discoveredConfFile.getAbsolutePath() + " can't be read, skipping");
                    } else {
                        this.loadDiscoveredConfs(discoveredConfFile);
                    }
                } else {
                    String discoveredConfFileName = discoveredConfFile.getAbsolutePath();
                    String ext = discoveredConfFileName.substring(discoveredConfFileName.lastIndexOf(".") + 1);
                    if (ext.equals("conf")) {
                        ConfModel confModel = null;
                        try {
                            confModel = this.loadConf(URI.createFileURI((String)discoveredConfFile.getAbsolutePath()));
                        }
                        catch (ConfResourceException e) {
                            logger.warning("Error while looking for discovered conf file at " + discoveredConfFile.getAbsolutePath() + ", skipping", e);
                            break block10;
                        }
                        if (confModel == null) {
                            logger.warning("No conf in discovered conf file at " + discoveredConfFile.getAbsolutePath() + ", skipping");
                        } else {
                            this.addDiscoveredConf(confModel);
                        }
                    }
                }
            }
            ++i;
        }
    }

    public ConfModel loadConf(URI uri) throws ConfResourceException {
        return ConfModelResourceManager.INSTANCE.loadConfModel(uri, null, null, false);
    }

    public void loadDeclaredConfs() {
        logger.debug("Getting conf extensions at point org.eclipse.jwt.we.conf.model.conf");
        try {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint confExtensionPoint = registry.getExtensionPoint("org.eclipse.jwt.we.conf.model.conf");
            if (confExtensionPoint == null || confExtensionPoint.getConfigurationElements() == null) {
                logger.debug("No declared conf extension found at point org.eclipse.jwt.we.conf.model.conf");
                return;
            }
            IConfigurationElement[] iConfigurationElementArray = confExtensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    IConfigurationElement point = iConfigurationElementArray[n2];
                    String confFileName = point.getAttribute(CONF_EXTENSION_POINT_CONF_FILE);
                    logger.info("Found ConfModel extension at point org.eclipse.jwt.we.conf.model.conf : conf file " + confFileName);
                    Bundle bundle = Platform.getBundle((String)point.getContributor().getName());
                    URL confPath = bundle.getEntry(confFileName);
                    if (confPath == null) {
                        logger.severe("Conf file " + confFileName + " could not be found");
                    } else {
                        ConfModel confModel = null;
                        URI confUri = URI.createURI((String)confPath.toURI().toString());
                        try {
                            confModel = this.loadConf(confUri);
                        }
                        catch (ConfResourceException e) {
                            logger.severe("Error while looking for declared conf file at " + confUri.toString() + " by contributor " + point.getContributor().getName() + ", skipping", e);
                            break block10;
                        }
                        if (confModel == null) {
                            logger.severe("No conf in declared conf file at " + confUri.toString() + " by contributor " + point.getContributor().getName() + ", skipping");
                        } else {
                            this.addDeclaredConf(confModel);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.severe("Error loading external confs", e);
        }
    }
}

