/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.refactoring.ui.SyncUtil;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.testing.AbstractEditorTest;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.junit.Assert;

public abstract class AbstractQuickfixTest
extends AbstractEditorTest {
    @Inject
    protected Injector injector;
    @Inject
    protected IResourceSetProvider resourceSetProvider;
    @Inject
    @Extension
    protected SyncUtil _syncUtil;
    @Inject
    @Extension
    protected IResourceValidator _iResourceValidator;
    @Inject
    @Extension
    protected FileExtensionProvider _fileExtensionProvider;
    @Inject
    @Extension
    protected IssueResolutionProvider _issueResolutionProvider;
    protected IProject project;

    public void testQuickfixesOn(CharSequence it, String issueCode, Quickfix ... quickfixes) {
        this.quickfixesAreOffered(this.openInEditor(this.dslFile(it)), issueCode, quickfixes);
    }

    protected IFile dslFile(CharSequence content) {
        try {
            boolean _not;
            IFile _xblockexpression = null;
            IFile file = IResourcesSetupUtil.createFile(this.getProjectName(), this.getFileName(), this.getFileExtension(), content.toString());
            this.project = file.getProject();
            boolean _hasNature = this.project.hasNature("org.eclipse.xtext.ui.shared.xtextNature");
            boolean bl = _not = !_hasNature;
            if (_not) {
                IResourcesSetupUtil.addNature(this.project, "org.eclipse.xtext.ui.shared.xtextNature");
            }
            _xblockexpression = file;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String getProjectName() {
        return "QuickfixTestProject";
    }

    protected String getFileName() {
        return "quickfix";
    }

    protected String getFileExtension() {
        return this._fileExtensionProvider.getPrimaryFileExtension();
    }

    protected XtextEditor openInEditor(IFile dslFile) {
        try {
            XtextEditor _xblockexpression = null;
            this._syncUtil.waitForBuild((IProgressMonitor)new NullProgressMonitor());
            _xblockexpression = this.openEditor(dslFile);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void quickfixesAreOffered(XtextEditor editor, String issueCode, Quickfix ... expected) {
        IXtextDocument document = editor.getDocument();
        String originalText = document.get();
        Issue issue = this.getValidationIssue(document, issueCode);
        List actualIssueResolutions = this._issueResolutionProvider.getResolutions(issue);
        Assert.assertEquals((String)"The number of quickfixes does not match!", (long)((List)Conversions.doWrapArray((Object)expected)).size(), (long)actualIssueResolutions.size());
        int _size = actualIssueResolutions.size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
        for (Integer i : _doubleDotLessThan) {
            IssueResolution actualIssueResolution = (IssueResolution)actualIssueResolutions.get(i);
            Quickfix expectedIssueResolution = expected[i];
            Assert.assertEquals((Object)expectedIssueResolution.label, (Object)actualIssueResolution.getLabel());
            Assert.assertEquals((Object)expectedIssueResolution.description, (Object)actualIssueResolution.getDescription());
            this.assertIssueResolutionResult(expectedIssueResolution.result, actualIssueResolution, originalText);
        }
    }

    protected Issue getValidationIssue(IXtextDocument document, String issueCode) {
        Issue _xblockexpression = null;
        IUnitOfWork _function = it -> this._iResourceValidator.validate((Resource)it, CheckMode.NORMAL_AND_FAST, CancelIndicator.NullImpl);
        List issues = (List)document.readOnly(_function);
        Functions.Function1 _function_1 = it -> {
            String _code = it.getCode();
            return Objects.equal((Object)_code, (Object)issueCode);
        };
        Iterable issueCandidates = IterableExtensions.filter((Iterable)issues, (Functions.Function1)_function_1);
        Assert.assertEquals((String)("There should be one '" + issueCode + "' validation issue!"), (long)1L, (long)IterableExtensions.size((Iterable)issueCandidates));
        _xblockexpression = (Issue)IterableExtensions.head((Iterable)issueCandidates);
        return _xblockexpression;
    }

    protected void assertIssueResolutionResult(String expectedResult, IssueResolution actualIssueResolution, String originalText) {
        IXtextDocument document = this.getDocument(originalText);
        TestModificationContext modificationContext = new TestModificationContext();
        modificationContext.setDocument(document);
        String _label = actualIssueResolution.getLabel();
        String _description = actualIssueResolution.getDescription();
        String _image = actualIssueResolution.getImage();
        IModification _modification = actualIssueResolution.getModification();
        int _relevance = actualIssueResolution.getRelevance();
        new IssueResolution(_label, _description, _image, (IModificationContext)modificationContext, _modification, _relevance).apply();
        String actualResult = document.get();
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    protected IXtextDocument getDocument(String model) {
        XtextDocument _xblockexpression = null;
        XtextResource xtextResource = this.getXtextResource(model);
        XtextDocument document = (XtextDocument)this.injector.getInstance(XtextDocument.class);
        document.set(model);
        document.setInput(xtextResource);
        _xblockexpression = document;
        return _xblockexpression;
    }

    protected XtextResource getXtextResource(String model) {
        try {
            XtextResource _xblockexpression = null;
            String _emptyIfNull = Strings.emptyIfNull((String)model);
            StringInputStream in = new StringInputStream(_emptyIfNull);
            URI uri = URI.createURI((String)"");
            ResourceSet rs = this.resourceSetProvider.get(this.project);
            Resource resource = ((IResourceFactory)this.injector.getInstance(IResourceFactory.class)).createResource(uri);
            EList _resources = rs.getResources();
            _resources.add((Object)resource);
            resource.load((InputStream)in, null);
            if (resource instanceof LazyLinkingResource) {
                ((LazyLinkingResource)resource).resolveLazyCrossReferences(CancelIndicator.NullImpl);
            } else {
                EcoreUtil.resolveAll((Resource)resource);
            }
            _xblockexpression = (XtextResource)resource;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Data
    protected static class Quickfix {
        private final String label;
        private final String description;
        private final String result;

        public Quickfix(String label, String description, String result) {
            this.label = label;
            this.description = description;
            this.result = result;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            return 31 * result + (this.result == null ? 0 : this.result.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Quickfix other = (Quickfix)obj;
            if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
                return false;
            }
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            return !(this.result == null ? other.result != null : !this.result.equals(other.result));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("label", (Object)this.label);
            b.add("description", (Object)this.description);
            b.add("result", (Object)this.result);
            return b.toString();
        }

        @Pure
        public String getLabel() {
            return this.label;
        }

        @Pure
        public String getDescription() {
            return this.description;
        }

        @Pure
        public String getResult() {
            return this.result;
        }
    }

    private static class TestModificationContext
    implements IModificationContext {
        private IXtextDocument doc;

        private TestModificationContext() {
        }

        public IXtextDocument getXtextDocument() {
            return this.doc;
        }

        public IXtextDocument getXtextDocument(URI uri) {
            return this.doc;
        }

        public IXtextDocument setDocument(IXtextDocument doc) {
            this.doc = doc;
            return this.doc;
        }
    }
}

