/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout.semantic;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.layoutdata.AbstractLayoutData;
import org.eclipse.sirius.diagram.layoutdata.EdgeLayoutData;
import org.eclipse.sirius.diagram.layoutdata.NodeLayoutData;
import org.eclipse.sirius.diagram.ui.tools.api.layout.AbstractSiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutDataHelper;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutDataKey;
import org.eclipse.sirius.diagram.ui.tools.api.layout.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.AdvancedSiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.semantic.AbstractSemanticLayoutDataKey;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.semantic.SemanticEdgeLayoutDataKey;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.semantic.SemanticNodeLayoutDataKey;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class SiriusLayoutDataManagerForSemanticElements
extends AbstractSiriusLayoutDataManager
implements AdvancedSiriusLayoutDataManager {
    private static final SiriusLayoutDataManagerForSemanticElements INSTANCE = new SiriusLayoutDataManagerForSemanticElements();
    private final Map<SemanticNodeLayoutDataKey, NodeLayoutData> nodeLayoutDataMap = new HashMap<SemanticNodeLayoutDataKey, NodeLayoutData>();
    private final Map<SemanticEdgeLayoutDataKey, EdgeLayoutData> edgeLayoutDataMap = new HashMap<SemanticEdgeLayoutDataKey, EdgeLayoutData>();

    @Override
    public void addLayoutData(LayoutDataKey key, AbstractLayoutData layoutData) {
        if (!this.checkKeyType(key)) {
            layoutData.setId(null);
            return;
        }
        if (key instanceof SemanticNodeLayoutDataKey) {
            if (layoutData instanceof NodeLayoutData) {
                this.nodeLayoutDataMap.put((SemanticNodeLayoutDataKey)key, (NodeLayoutData)layoutData);
            }
        } else if (key instanceof SemanticEdgeLayoutDataKey && layoutData instanceof EdgeLayoutData) {
            this.edgeLayoutDataMap.put((SemanticEdgeLayoutDataKey)key, (EdgeLayoutData)layoutData);
        }
    }

    @Override
    public AbstractLayoutData getLayoutData(LayoutDataKey key) {
        AbstractLayoutData result = null;
        if (this.checkKeyType(key)) {
            if (key instanceof SemanticNodeLayoutDataKey) {
                result = (AbstractLayoutData)this.nodeLayoutDataMap.get(key);
            } else if (key instanceof SemanticEdgeLayoutDataKey) {
                result = (AbstractLayoutData)this.edgeLayoutDataMap.get(key);
            }
        }
        return result;
    }

    private boolean checkKeyType(LayoutDataKey key) {
        return key instanceof SemanticNodeLayoutDataKey || key instanceof SemanticEdgeLayoutDataKey;
    }

    public SiriusLayoutDataManager getInstance() {
        return INSTANCE;
    }

    @Override
    public LayoutDataKey createKey(DSemanticDecorator semanticDecorator) {
        AbstractSemanticLayoutDataKey result = null;
        EObject realSemanticElement = semanticDecorator.getTarget();
        if (semanticDecorator instanceof DEdge) {
            result = new SemanticEdgeLayoutDataKey(realSemanticElement);
        } else if (semanticDecorator instanceof AbstractDNode || semanticDecorator instanceof DDiagram) {
            result = new SemanticNodeLayoutDataKey(realSemanticElement);
        }
        return result;
    }

    @Override
    public boolean containsData() {
        return !this.nodeLayoutDataMap.isEmpty() || !this.edgeLayoutDataMap.isEmpty();
    }

    @Override
    public void clearLayoutData() {
        this.nodeLayoutDataMap.clear();
        this.edgeLayoutDataMap.clear();
    }

    public Map<SemanticEdgeLayoutDataKey, EdgeLayoutData> getEdgeLayoutData() {
        return this.edgeLayoutDataMap;
    }

    @Override
    public Map<? extends LayoutDataKey, ? extends NodeLayoutData> getRootNodeLayoutData() {
        return LayoutDataHelper.INSTANCE.getRootLayoutData(this.nodeLayoutDataMap);
    }

    public Map<SemanticNodeLayoutDataKey, NodeLayoutData> getNodeLayoutData() {
        return this.nodeLayoutDataMap;
    }
}

