/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateRelationshipCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.UMLPackage;

public class InstanceSpecificationEditHelper
extends ElementEditHelper {
    public static final String INSTANCE_END = "InstanceEnd";

    private InstanceSpecification getSourceOwnerType(ConfigureRequest req) {
        InstanceSpecification result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.source");
        if (paramObject instanceof InstanceSpecification) {
            result = (InstanceSpecification)paramObject;
        }
        return result;
    }

    private InstanceSpecification getTargetOwnerType(ConfigureRequest req) {
        InstanceSpecification result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.target");
        if (paramObject instanceof InstanceSpecification) {
            result = (InstanceSpecification)paramObject;
        }
        return result;
    }

    protected boolean canCreate(EObject source, EObject target) {
        if (source != null && !(source instanceof InstanceSpecification)) {
            return false;
        }
        return target == null || target instanceof InstanceSpecification;
    }

    protected ICommand getCreateRelationshipCommand(CreateRelationshipRequest req) {
        boolean noSourceAndTarget;
        EObject source = req.getSource();
        EObject target = req.getTarget();
        boolean noSourceOrTarget = source == null || target == null;
        boolean bl = noSourceAndTarget = source == null && target == null;
        if (!noSourceAndTarget && !this.canCreate(source, target)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (noSourceOrTarget && !noSourceAndTarget) {
            return IdentityCommand.INSTANCE;
        }
        View sourceView = (View)req.getParameter("SOURCE_GRAPHICAL_VIEW");
        if (sourceView != null) {
            Diagram diagram = sourceView.getDiagram();
            EObject proposedContainer = EMFCoreUtil.getContainer((EObject)diagram.getElement(), (EClass)UMLPackage.Literals.PACKAGE);
            req.setContainer(proposedContainer);
        }
        return new CreateRelationshipCommand(req);
    }

    @Override
    protected ICommand getConfigureCommand(ConfigureRequest req) {
        return super.getConfigureCommand(req);
    }

    protected ICommand getDestroyDependentsCommand(DestroyDependentsRequest req) {
        EObject elementToDestroy = req.getElementToDestroy();
        EObject container = elementToDestroy.eContainer();
        ArrayList<Slot> dependentSlots = new ArrayList<Slot>();
        if (elementToDestroy instanceof InstanceSpecification) {
            dependentSlots.addAll(this.collectDependentSlots((InstanceSpecification)elementToDestroy));
        }
        if (container != null && container instanceof InstanceSpecification) {
            dependentSlots.addAll(this.collectDependentSlots((InstanceSpecification)container));
        }
        return dependentSlots.isEmpty() ? super.getDestroyDependentsCommand(req) : req.getDestroyDependentsCommand(dependentSlots);
    }

    private List<Slot> collectDependentSlots(InstanceSpecification instanceSpecification) {
        if (instanceSpecification == null) {
            return Collections.emptyList();
        }
        List<InstanceSpecification> ends = this.getEnds(instanceSpecification);
        if (ends.size() != 2) {
            return Collections.emptyList();
        }
        InstanceSpecification source = ends.get(0);
        InstanceSpecification target = ends.get(1);
        EList classifiers = instanceSpecification.getClassifiers();
        if (classifiers == null || classifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Slot> result = new ArrayList<Slot>();
        for (Classifier nextAssociation : classifiers) {
            if (!(nextAssociation instanceof Association)) continue;
            for (Property nextAssociationEnd : ((Association)nextAssociation).getMemberEnds()) {
                Slot targetSlot;
                Slot sourceSlot = this.findAssociatedSlot(nextAssociationEnd, source);
                if (sourceSlot != null) {
                    result.add(sourceSlot);
                }
                if ((targetSlot = this.findAssociatedSlot(nextAssociationEnd, target)) == null) continue;
                result.add(targetSlot);
            }
        }
        return result;
    }

    private Slot findAssociatedSlot(Property associationEnd, InstanceSpecification instanceSpecification) {
        for (Slot nextSlot : instanceSpecification.getSlots()) {
            if (associationEnd != nextSlot.getDefiningFeature()) continue;
            return nextSlot;
        }
        return null;
    }

    private List<InstanceSpecification> getEnds(InstanceSpecification instance) {
        ArrayList<InstanceSpecification> array = new ArrayList<InstanceSpecification>();
        EAnnotation endtypes = instance.getEAnnotation(INSTANCE_END);
        if (endtypes != null) {
            assert (endtypes.getReferences().size() == 2);
            array.add((InstanceSpecification)endtypes.getReferences().get(0));
            array.add((InstanceSpecification)endtypes.getReferences().get(1));
        }
        return array;
    }
}

