/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.collectionextract.ExtractionUtils;
import org.eclipse.mat.internal.collectionextract.FieldArrayCollectionExtractor;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

public class FieldSizeArrayCollectionExtractor
extends FieldArrayCollectionExtractor {
    protected final String sizeField;

    public FieldSizeArrayCollectionExtractor(String sizeField, String arrayField) {
        super(arrayField);
        if (sizeField == null) {
            throw new IllegalArgumentException();
        }
        this.sizeField = sizeField;
    }

    public boolean hasSize() {
        return true;
    }

    public Integer getSize(IObject coll) throws SnapshotException {
        Integer value = ExtractionUtils.toInteger(coll.resolveValue(this.sizeField));
        if (value != null) {
            return value;
        }
        IObjectArray array = this.extractEntries(coll);
        if (array != null) {
            return ExtractionUtils.getNumberOfNotNullArrayElements(array);
        }
        return null;
    }
}

