/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jwt.transformations.api.Transformation;
import org.eclipse.jwt.transformations.api.TransformationException;
import org.eclipse.jwt.transformations.api.io.AbstractIODefinition;
import org.eclipse.jwt.transformations.api.io.IODefinition;
import org.eclipse.jwt.transformations.internal.init.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransformation
implements Transformation,
IExecutableExtension {
    private static final String TRANSFORMATION_EXTENSION_POINT = "org.eclipse.jwt.transformations";
    private static final String CLASS_CONFIGURATION_ATTRIBUTE = "class";
    private static final String NAME_CONFIGURATION_ATTRIBUTE = "name";
    private static final String DESCRIPTION_CONFIGURATION_ATTRIBUTE = "description";
    private static final String TYPE_CONFIGURATION_ATTRIBUTE = "type";
    private static final String INPUTS_CONFIGURATION_CHILD = "inputs";
    private static final String OUTPUTS_CONFIGURATION_CHILD = "outputs";
    private String name;
    private String description;
    private Transformation.Type type;
    private final List<IODefinition> inputDefinitions = new ArrayList<IODefinition>();
    private final List<IODefinition> outputDefinitions = new ArrayList<IODefinition>();

    public static IExtensionPoint getExtensionPoint() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        return registry.getExtensionPoint(TRANSFORMATION_EXTENSION_POINT);
    }

    public static Transformation createTransformation(IConfigurationElement config) throws CoreException, IOException {
        Object created = config.createExecutableExtension(CLASS_CONFIGURATION_ATTRIBUTE);
        if (created == null) {
            throw new IOException("A Transformation could not be created");
        }
        if (!(created instanceof Transformation)) {
            throw new IOException("An Transformation was found to have incorrect type");
        }
        return (Transformation)created;
    }

    @Override
    public abstract void transform(Object var1, Object var2) throws IllegalArgumentException, IOException, TransformationException;

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Deprecated
    protected void setDescription(String description) {
        this.description = description;
    }

    @Override
    public final Transformation.Type getType() {
        return this.type;
    }

    @Deprecated
    protected void setType(Transformation.Type type) {
        this.type = type;
    }

    public final void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        this.name = config.getAttribute(NAME_CONFIGURATION_ATTRIBUTE);
        this.description = config.getAttribute(DESCRIPTION_CONFIGURATION_ATTRIBUTE);
        this.type = Transformation.Type.fromString(config.getAttribute(TYPE_CONFIGURATION_ATTRIBUTE));
        if (config.getChildren(INPUTS_CONFIGURATION_CHILD).length > 0) {
            IConfigurationElement inputs = config.getChildren(INPUTS_CONFIGURATION_CHILD)[0];
            iConfigurationElementArray = inputs.getChildren();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                IConfigurationElement input = iConfigurationElementArray[n];
                this.inputDefinitions.add(this.extractIO(input));
                ++n;
            }
        }
        if (config.getChildren(OUTPUTS_CONFIGURATION_CHILD).length > 0) {
            IConfigurationElement outputs = config.getChildren(OUTPUTS_CONFIGURATION_CHILD)[0];
            iConfigurationElementArray = outputs.getChildren();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                IConfigurationElement output = iConfigurationElementArray[n];
                this.outputDefinitions.add(this.extractIO(output));
                ++n;
            }
        }
    }

    private IODefinition extractIO(IConfigurationElement element) throws CoreException {
        try {
            return AbstractIODefinition.createIODefinition(element);
        }
        catch (IOException e) {
            throw new InvalidTransformationException(this, e);
        }
    }

    @Override
    public List<IODefinition> getCompatibleInputDefinitions() {
        return Collections.unmodifiableList(this.inputDefinitions);
    }

    @Override
    public List<IODefinition> getCompatibleOutputDefinitions() {
        return Collections.unmodifiableList(this.outputDefinitions);
    }

    private static class InvalidTransformationException
    extends CoreException {
        private static final long serialVersionUID = -8978517553154150730L;
        private static String ERROR_FORMAT = "A registered Transformation is invalid [name:%s]";

        public InvalidTransformationException(AbstractTransformation transformation, Throwable cause) {
            super((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), String.format(ERROR_FORMAT, transformation.name), cause));
        }
    }
}

