/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;

public class RoundedRectangleBorder
extends LineBorder {
    int arcWidth;
    int arcHeight;

    public RoundedRectangleBorder(int arcWidth, int arcHeight) {
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
    }

    public Insets getInsets(IFigure figure) {
        return new Insets(this.getWidth());
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public void setArcWidth(int arcWidth) {
        this.arcWidth = arcWidth;
    }

    public int getArcHeight() {
        return this.arcHeight;
    }

    public void setArcHeight(int arcHeight) {
        this.arcHeight = arcHeight;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        RoundedRectangleBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
        RoundedRectangleBorder.tempRect.x += this.getWidth() / 2;
        RoundedRectangleBorder.tempRect.y += this.getWidth() / 2;
        RoundedRectangleBorder.tempRect.width -= this.getWidth();
        RoundedRectangleBorder.tempRect.height -= this.getWidth();
        graphics.setLineWidth(this.getWidth());
        graphics.setLineStyle(this.getStyle());
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        } else {
            graphics.setForegroundColor(figure.getForegroundColor());
        }
        graphics.drawRoundRectangle(tempRect, this.arcWidth, this.arcHeight);
    }
}

