/*******************************************************************************
 * Copyright (c) 2008-2011 Chair for Applied Software Engineering,
 * Technische Universitaet Muenchen.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 ******************************************************************************/
package org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.api.APIDelegate;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.ESRole;

/**
 * <!-- begin-user-doc --> A representation of the model object ' <em><b>Role</b></em>'.
 *
 * @extends APIDelegate<ESRole>
 *          <!-- end-user-doc -->
 *
 *          <p>
 *          The following features are supported:
 *          </p>
 *          <ul>
 *          <li>{@link org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.Role#getProjects
 *          <em>Projects</em>}</li>
 *          </ul>
 *
 * @see org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.RolesPackage#getRole()
 * @model abstract="true"
 * @generated
 */
public interface Role extends EObject, APIDelegate<ESRole> {
	/**
	 * Returns the value of the '<em><b>Projects</b></em>' containment reference
	 * list. The list contents are of type {@link org.eclipse.emf.emfstore.internal.server.model.ProjectId}. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Projects</em>' reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Projects</em>' containment reference list.
	 * @see org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.RolesPackage#getRole_Projects()
	 * @model containment="true" resolveProxies="true" keys="id"
	 * @generated
	 */
	EList<ProjectId> getProjects();

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @model
	 * @generated
	 */
	boolean canAdministrate(ProjectId projectId);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @model
	 * @generated
	 */
	boolean canCreate(ProjectId projectId, EObject modelElement);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @model
	 * @generated
	 */
	boolean canDelete(ProjectId projectId, EObject modelElement);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @model
	 * @generated
	 */
	boolean canModify(ProjectId projectId, EObject modelElement);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @model
	 * @generated
	 */
	boolean canRead(ProjectId projectId, EObject modelElement);

} // Role