/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.util.ArrayUtil;

public class FieldInfos
implements Iterable<FieldInfo> {
    private final boolean hasFreq;
    private final boolean hasProx;
    private final boolean hasPayloads;
    private final boolean hasOffsets;
    private final boolean hasVectors;
    private final boolean hasNorms;
    private final boolean hasDocValues;
    private final boolean hasPointValues;
    private final FieldInfo[] byNumberTable;
    private final SortedMap<Integer, FieldInfo> byNumberMap;
    private final HashMap<String, FieldInfo> byName = new HashMap();
    private final Collection<FieldInfo> values;

    public FieldInfos(FieldInfo[] infos) {
        Integer max;
        boolean hasVectors = false;
        boolean hasProx = false;
        boolean hasPayloads = false;
        boolean hasOffsets = false;
        boolean hasFreq = false;
        boolean hasNorms = false;
        boolean hasDocValues = false;
        boolean hasPointValues = false;
        TreeMap<Integer, FieldInfo> byNumber = new TreeMap<Integer, FieldInfo>();
        for (FieldInfo info : infos) {
            if (info.number < 0) {
                throw new IllegalArgumentException("illegal field number: " + info.number + " for field " + info.name);
            }
            FieldInfo previous = byNumber.put(info.number, info);
            if (previous != null) {
                throw new IllegalArgumentException("duplicate field numbers: " + previous.name + " and " + info.name + " have: " + info.number);
            }
            previous = this.byName.put(info.name, info);
            if (previous != null) {
                throw new IllegalArgumentException("duplicate field names: " + previous.number + " and " + info.number + " have: " + info.name);
            }
            hasVectors |= info.hasVectors();
            hasProx |= info.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            hasFreq |= info.getIndexOptions() != IndexOptions.DOCS;
            hasOffsets |= info.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            hasNorms |= info.hasNorms();
            hasDocValues |= info.getDocValuesType() != DocValuesType.NONE;
            hasPayloads |= info.hasPayloads();
            hasPointValues |= info.getPointDimensionCount() != 0;
        }
        this.hasVectors = hasVectors;
        this.hasProx = hasProx;
        this.hasPayloads = hasPayloads;
        this.hasOffsets = hasOffsets;
        this.hasFreq = hasFreq;
        this.hasNorms = hasNorms;
        this.hasDocValues = hasDocValues;
        this.hasPointValues = hasPointValues;
        this.values = Collections.unmodifiableCollection(byNumber.values());
        Integer n = max = byNumber.isEmpty() ? null : (Integer)Collections.max(byNumber.keySet());
        if (max != null && max < ArrayUtil.MAX_ARRAY_LENGTH && (long)max.intValue() < 16L * (long)byNumber.size()) {
            this.byNumberMap = null;
            this.byNumberTable = new FieldInfo[max + 1];
            for (Map.Entry<Integer, FieldInfo> entry : byNumber.entrySet()) {
                this.byNumberTable[entry.getKey().intValue()] = entry.getValue();
            }
        } else {
            this.byNumberMap = byNumber;
            this.byNumberTable = null;
        }
    }

    public boolean hasFreq() {
        return this.hasFreq;
    }

    public boolean hasProx() {
        return this.hasProx;
    }

    public boolean hasPayloads() {
        return this.hasPayloads;
    }

    public boolean hasOffsets() {
        return this.hasOffsets;
    }

    public boolean hasVectors() {
        return this.hasVectors;
    }

    public boolean hasNorms() {
        return this.hasNorms;
    }

    public boolean hasDocValues() {
        return this.hasDocValues;
    }

    public boolean hasPointValues() {
        return this.hasPointValues;
    }

    public int size() {
        return this.byName.size();
    }

    @Override
    public Iterator<FieldInfo> iterator() {
        return this.values.iterator();
    }

    public FieldInfo fieldInfo(String fieldName) {
        return this.byName.get(fieldName);
    }

    public FieldInfo fieldInfo(int fieldNumber) {
        if (fieldNumber < 0) {
            throw new IllegalArgumentException("Illegal field number: " + fieldNumber);
        }
        if (this.byNumberTable != null) {
            if (fieldNumber >= this.byNumberTable.length) {
                return null;
            }
            return this.byNumberTable[fieldNumber];
        }
        return (FieldInfo)this.byNumberMap.get(fieldNumber);
    }

    static final class Builder {
        private final HashMap<String, FieldInfo> byName = new HashMap();
        final FieldNumbers globalFieldNumbers;

        Builder() {
            this(new FieldNumbers());
        }

        Builder(FieldNumbers globalFieldNumbers) {
            assert (globalFieldNumbers != null);
            this.globalFieldNumbers = globalFieldNumbers;
        }

        public void add(FieldInfos other) {
            for (FieldInfo fieldInfo : other) {
                this.add(fieldInfo);
            }
        }

        public FieldInfo getOrAdd(String name) {
            FieldInfo fi = this.fieldInfo(name);
            if (fi == null) {
                int fieldNumber = this.globalFieldNumbers.addOrGet(name, -1, DocValuesType.NONE, 0, 0);
                fi = new FieldInfo(name, fieldNumber, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, new HashMap<String, String>(), 0, 0);
                assert (!this.byName.containsKey(fi.name));
                this.globalFieldNumbers.verifyConsistent(fi.number, fi.name, DocValuesType.NONE);
                this.byName.put(fi.name, fi);
            }
            return fi;
        }

        private FieldInfo addOrUpdateInternal(String name, int preferredFieldNumber, boolean storeTermVector, boolean omitNorms, boolean storePayloads, IndexOptions indexOptions, DocValuesType docValues, int dimensionCount, int dimensionNumBytes) {
            if (docValues == null) {
                throw new NullPointerException("DocValuesType must not be null");
            }
            FieldInfo fi = this.fieldInfo(name);
            if (fi == null) {
                int fieldNumber = this.globalFieldNumbers.addOrGet(name, preferredFieldNumber, docValues, dimensionCount, dimensionNumBytes);
                fi = new FieldInfo(name, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValues, -1L, new HashMap<String, String>(), dimensionCount, dimensionNumBytes);
                assert (!this.byName.containsKey(fi.name));
                this.globalFieldNumbers.verifyConsistent(fi.number, fi.name, fi.getDocValuesType());
                this.byName.put(fi.name, fi);
            } else {
                fi.update(storeTermVector, omitNorms, storePayloads, indexOptions, dimensionCount, dimensionNumBytes);
                if (docValues != DocValuesType.NONE) {
                    boolean updateGlobal;
                    boolean bl = updateGlobal = fi.getDocValuesType() == DocValuesType.NONE;
                    if (updateGlobal) {
                        this.globalFieldNumbers.setDocValuesType(fi.number, name, docValues);
                    }
                    fi.setDocValuesType(docValues);
                }
            }
            return fi;
        }

        public FieldInfo add(FieldInfo fi) {
            return this.addOrUpdateInternal(fi.name, fi.number, fi.hasVectors(), fi.omitsNorms(), fi.hasPayloads(), fi.getIndexOptions(), fi.getDocValuesType(), fi.getPointDimensionCount(), fi.getPointNumBytes());
        }

        public FieldInfo fieldInfo(String fieldName) {
            return this.byName.get(fieldName);
        }

        FieldInfos finish() {
            return new FieldInfos(this.byName.values().toArray(new FieldInfo[this.byName.size()]));
        }
    }

    static final class FieldDimensions {
        public final int dimensionCount;
        public final int dimensionNumBytes;

        public FieldDimensions(int dimensionCount, int dimensionNumBytes) {
            this.dimensionCount = dimensionCount;
            this.dimensionNumBytes = dimensionNumBytes;
        }
    }

    static final class FieldNumbers {
        private final Map<Integer, String> numberToName;
        private final Map<String, Integer> nameToNumber = new HashMap<String, Integer>();
        private final Map<String, DocValuesType> docValuesType;
        private final Map<String, FieldDimensions> dimensions;
        private int lowestUnassignedFieldNumber = -1;

        FieldNumbers() {
            this.numberToName = new HashMap<Integer, String>();
            this.docValuesType = new HashMap<String, DocValuesType>();
            this.dimensions = new HashMap<String, FieldDimensions>();
        }

        synchronized int addOrGet(String fieldName, int preferredFieldNumber, DocValuesType dvType, int dimensionCount, int dimensionNumBytes) {
            Integer fieldNumber;
            if (dvType != DocValuesType.NONE) {
                DocValuesType currentDVType = this.docValuesType.get(fieldName);
                if (currentDVType == null) {
                    this.docValuesType.put(fieldName, dvType);
                } else if (currentDVType != DocValuesType.NONE && currentDVType != dvType) {
                    throw new IllegalArgumentException("cannot change DocValues type from " + (Object)((Object)currentDVType) + " to " + (Object)((Object)dvType) + " for field \"" + fieldName + "\"");
                }
            }
            if (dimensionCount != 0) {
                FieldDimensions dims = this.dimensions.get(fieldName);
                if (dims != null) {
                    if (dims.dimensionCount != dimensionCount) {
                        throw new IllegalArgumentException("cannot change point dimension count from " + dims.dimensionCount + " to " + dimensionCount + " for field=\"" + fieldName + "\"");
                    }
                    if (dims.dimensionNumBytes != dimensionNumBytes) {
                        throw new IllegalArgumentException("cannot change point numBytes from " + dims.dimensionNumBytes + " to " + dimensionNumBytes + " for field=\"" + fieldName + "\"");
                    }
                } else {
                    this.dimensions.put(fieldName, new FieldDimensions(dimensionCount, dimensionNumBytes));
                }
            }
            if ((fieldNumber = this.nameToNumber.get(fieldName)) == null) {
                Integer preferredBoxed = preferredFieldNumber;
                if (preferredFieldNumber != -1 && !this.numberToName.containsKey(preferredBoxed)) {
                    fieldNumber = preferredBoxed;
                } else {
                    while (this.numberToName.containsKey(++this.lowestUnassignedFieldNumber)) {
                    }
                    fieldNumber = this.lowestUnassignedFieldNumber;
                }
                assert (fieldNumber >= 0);
                this.numberToName.put(fieldNumber, fieldName);
                this.nameToNumber.put(fieldName, fieldNumber);
            }
            return fieldNumber;
        }

        synchronized void verifyConsistent(Integer number, String name, DocValuesType dvType) {
            if (!name.equals(this.numberToName.get(number))) {
                throw new IllegalArgumentException("field number " + number + " is already mapped to field name \"" + this.numberToName.get(number) + "\", not \"" + name + "\"");
            }
            if (!number.equals(this.nameToNumber.get(name))) {
                throw new IllegalArgumentException("field name \"" + name + "\" is already mapped to field number \"" + this.nameToNumber.get(name) + "\", not \"" + number + "\"");
            }
            DocValuesType currentDVType = this.docValuesType.get(name);
            if (dvType != DocValuesType.NONE && currentDVType != null && currentDVType != DocValuesType.NONE && dvType != currentDVType) {
                throw new IllegalArgumentException("cannot change DocValues type from " + (Object)((Object)currentDVType) + " to " + (Object)((Object)dvType) + " for field \"" + name + "\"");
            }
        }

        synchronized void verifyConsistentDimensions(Integer number, String name, int dimensionCount, int dimensionNumBytes) {
            if (!name.equals(this.numberToName.get(number))) {
                throw new IllegalArgumentException("field number " + number + " is already mapped to field name \"" + this.numberToName.get(number) + "\", not \"" + name + "\"");
            }
            if (!number.equals(this.nameToNumber.get(name))) {
                throw new IllegalArgumentException("field name \"" + name + "\" is already mapped to field number \"" + this.nameToNumber.get(name) + "\", not \"" + number + "\"");
            }
            FieldDimensions dim = this.dimensions.get(name);
            if (dim != null) {
                if (dim.dimensionCount != dimensionCount) {
                    throw new IllegalArgumentException("cannot change point dimension count from " + dim.dimensionCount + " to " + dimensionCount + " for field=\"" + name + "\"");
                }
                if (dim.dimensionNumBytes != dimensionNumBytes) {
                    throw new IllegalArgumentException("cannot change point numBytes from " + dim.dimensionNumBytes + " to " + dimensionNumBytes + " for field=\"" + name + "\"");
                }
            }
        }

        synchronized boolean contains(String fieldName, DocValuesType dvType) {
            if (!this.nameToNumber.containsKey(fieldName)) {
                return false;
            }
            return dvType == this.docValuesType.get(fieldName);
        }

        synchronized Set<String> getFieldNames() {
            return Collections.unmodifiableSet(new HashSet<String>(this.nameToNumber.keySet()));
        }

        synchronized void clear() {
            this.numberToName.clear();
            this.nameToNumber.clear();
            this.docValuesType.clear();
            this.dimensions.clear();
        }

        synchronized void setDocValuesType(int number, String name, DocValuesType dvType) {
            this.verifyConsistent(number, name, dvType);
            this.docValuesType.put(name, dvType);
        }

        synchronized void setDimensions(int number, String name, int dimensionCount, int dimensionNumBytes) {
            if (dimensionNumBytes > 16) {
                throw new IllegalArgumentException("dimension numBytes must be <= PointValues.MAX_NUM_BYTES (= 16); got " + dimensionNumBytes + " for field=\"" + name + "\"");
            }
            if (dimensionCount > 8) {
                throw new IllegalArgumentException("pointDimensionCount must be <= PointValues.MAX_DIMENSIONS (= 8); got " + dimensionCount + " for field=\"" + name + "\"");
            }
            this.verifyConsistentDimensions(number, name, dimensionCount, dimensionNumBytes);
            this.dimensions.put(name, new FieldDimensions(dimensionCount, dimensionNumBytes));
        }
    }
}

