/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.util;

import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendHintProvider;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryBackendContext;
import org.eclipse.viatra.query.runtime.matchers.planning.IQueryPlannerStrategy;
import org.eclipse.viatra.query.runtime.rete.construction.basiclinear.BasicLinearLayout;
import org.eclipse.viatra.query.runtime.rete.construction.quasitree.QuasiTreeLayout;

public class Options {
    public static final NodeSharingOption nodeSharingOption = NodeSharingOption.ALL;
    public static final boolean releaseOnetimeIndexers = true;
    public static final InjectivityStrategy injectivityStrategy = InjectivityStrategy.EAGER;
    public static final boolean enableInheritance = true;
    public static final boolean employTrivialIndexers = true;
    public static final int numberOfLocalContainers = 1;
    public static final int firstFreeContainer = 0;
    public static final boolean MONITOR_VIOLATION_OF_RETE_NODEGROUP_TOPOLOGICAL_SORTING = false;
    public static final BuilderMethod builderMethod = BuilderMethod.PSYSTEM_QUASITREE;
    public static final FunctionalDependencyOption functionalDependencyOption = FunctionalDependencyOption.OPPORTUNISTIC;
    public static final PlanTrimOption planTrimOption = PlanTrimOption.OPPORTUNISTIC;

    public static enum BuilderMethod {
        LEGACY,
        PSYSTEM_BASIC_LINEAR,
        PSYSTEM_QUASITREE;


        public IQueryPlannerStrategy layoutStrategy(IQueryBackendContext bContext, IQueryBackendHintProvider hintProvider) {
            switch (this) {
                case PSYSTEM_BASIC_LINEAR: {
                    return new BasicLinearLayout(bContext);
                }
                case PSYSTEM_QUASITREE: {
                    return new QuasiTreeLayout(bContext, hintProvider);
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    public static enum FunctionalDependencyOption {
        OFF,
        OPPORTUNISTIC;

    }

    public static enum InjectivityStrategy {
        EAGER,
        LAZY;

    }

    public static enum NodeSharingOption {
        NEVER,
        INDEXER_AND_REMOTEPROXY,
        ALL;

    }

    public static enum PlanTrimOption {
        OFF,
        OPPORTUNISTIC;

    }
}

