/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.trace;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.util.ConversionHelper;
import org.eclipse.tracecompass.internal.pcap.core.util.PcapTimestampScale;

public class PcapFile
implements Closeable {
    private final Path fPcapFilePath;
    private final ByteOrder fByteOrder;
    private final SeekableByteChannel fFileChannel;
    private final PcapTimestampScale fTimestampPrecision;
    private final int fMajorVersion;
    private final int fMinorVersion;
    private final long fTimeAccuracy;
    private final long fTimeZoneCorrection;
    private final long fSnapshotLength;
    private final long fDataLinkType;
    private final TreeMap<Long, Long> fFileIndex = new TreeMap();
    private long fCurrentRank = 0L;
    private long fTotalNumberPackets = -1L;

    public PcapFile(Path filePath) throws BadPcapFileException, IOException {
        this.fPcapFilePath = filePath;
        if (Files.notExists(this.fPcapFilePath, new LinkOption[0]) || !Files.isRegularFile(this.fPcapFilePath, new LinkOption[0]) || Files.size(this.fPcapFilePath) < 24L) {
            throw new BadPcapFileException("Bad Pcap File.");
        }
        if (!Files.isReadable(this.fPcapFilePath)) {
            throw new BadPcapFileException("File is not readable.");
        }
        this.fFileChannel = (SeekableByteChannel)NonNullUtils.checkNotNull((Object)Files.newByteChannel(this.fPcapFilePath, new OpenOption[0]));
        ByteBuffer globalHeader = ByteBuffer.allocate(24);
        globalHeader.clear();
        this.fFileChannel.read(globalHeader);
        globalHeader.flip();
        int magicNumber = globalHeader.getInt();
        switch (magicNumber) {
            case -1582119980: {
                this.fByteOrder = ByteOrder.BIG_ENDIAN;
                this.fTimestampPrecision = PcapTimestampScale.MICROSECOND;
                break;
            }
            case -725372255: {
                this.fByteOrder = ByteOrder.LITTLE_ENDIAN;
                this.fTimestampPrecision = PcapTimestampScale.MICROSECOND;
                break;
            }
            case -1582154675: {
                this.fByteOrder = ByteOrder.BIG_ENDIAN;
                this.fTimestampPrecision = PcapTimestampScale.NANOSECOND;
                break;
            }
            case 1295823521: {
                this.fByteOrder = ByteOrder.LITTLE_ENDIAN;
                this.fTimestampPrecision = PcapTimestampScale.NANOSECOND;
                break;
            }
            default: {
                this.close();
                throw new BadPcapFileException(String.valueOf(String.format("%08x", magicNumber)) + " is not a known magic number.");
            }
        }
        globalHeader.order(this.fByteOrder);
        this.fMajorVersion = ConversionHelper.unsignedShortToInt(globalHeader.getShort());
        this.fMinorVersion = ConversionHelper.unsignedShortToInt(globalHeader.getShort());
        this.fTimeAccuracy = ConversionHelper.unsignedIntToLong(globalHeader.getInt());
        this.fTimeZoneCorrection = ConversionHelper.unsignedIntToLong(globalHeader.getInt());
        this.fSnapshotLength = ConversionHelper.unsignedIntToLong(globalHeader.getInt());
        this.fDataLinkType = ConversionHelper.unsignedIntToLong(globalHeader.getInt());
        this.fFileIndex.put(this.fCurrentRank, this.fFileChannel.position());
    }

    public synchronized @Nullable PcapPacket parseNextPacket() throws IOException, BadPcapFileException, BadPacketException {
        if (this.fFileChannel.size() - this.fFileChannel.position() == 0L) {
            return null;
        }
        if (this.fFileChannel.size() - this.fFileChannel.position() < 16L) {
            throw new BadPcapFileException("A pcap header is invalid.");
        }
        ByteBuffer pcapPacketHeader = ByteBuffer.allocate(16);
        pcapPacketHeader.clear();
        pcapPacketHeader.order(this.fByteOrder);
        this.fFileChannel.read(pcapPacketHeader);
        pcapPacketHeader.flip();
        pcapPacketHeader.position(8);
        long includedPacketLength = ConversionHelper.unsignedIntToLong(pcapPacketHeader.getInt());
        if (this.fFileChannel.size() - this.fFileChannel.position() < includedPacketLength) {
            throw new BadPcapFileException("A packet header is invalid.");
        }
        if (includedPacketLength > Integer.MAX_VALUE) {
            throw new BadPacketException("Packets that are bigger than 2^31-1 bytes are not supported.");
        }
        ByteBuffer pcapPacketData = ByteBuffer.allocate((int)includedPacketLength);
        pcapPacketData.clear();
        pcapPacketHeader.order(ByteOrder.BIG_ENDIAN);
        this.fFileChannel.read(pcapPacketData);
        pcapPacketData.flip();
        this.fFileIndex.put(++this.fCurrentRank, this.fFileChannel.position());
        return new PcapPacket(this, null, pcapPacketHeader, pcapPacketData, this.fCurrentRank - 1L);
    }

    public synchronized void skipNextPacket() throws IOException, BadPcapFileException {
        if (this.fFileChannel.size() - this.fFileChannel.position() == 0L) {
            return;
        }
        if (this.fFileChannel.size() - this.fFileChannel.position() < 16L) {
            throw new BadPcapFileException("A pcap header is invalid.");
        }
        ByteBuffer pcapPacketHeader = ByteBuffer.allocate(16);
        pcapPacketHeader.clear();
        pcapPacketHeader.order(this.fByteOrder);
        this.fFileChannel.read(pcapPacketHeader);
        pcapPacketHeader.flip();
        pcapPacketHeader.position(8);
        long includedPacketLength = ConversionHelper.unsignedIntToLong(pcapPacketHeader.getInt());
        if (this.fFileChannel.size() - this.fFileChannel.position() < includedPacketLength) {
            throw new BadPcapFileException("A packet header is invalid.");
        }
        this.fFileChannel.position(this.fFileChannel.position() + includedPacketLength);
        this.fFileIndex.put(++this.fCurrentRank, this.fFileChannel.position());
    }

    public synchronized void seekPacket(long rank) throws IOException, BadPcapFileException {
        if (rank < 0L) {
            throw new IllegalArgumentException();
        }
        Long positionInBytes = this.fFileIndex.get(rank);
        if (positionInBytes != null) {
            this.fFileChannel.position(positionInBytes);
            this.fCurrentRank = rank;
        } else {
            this.fCurrentRank = this.fFileIndex.floorKey(rank);
            do {
                this.skipNextPacket();
            } while (this.fCurrentRank != rank && this.hasNextPacket());
        }
    }

    public synchronized boolean hasNextPacket() throws IOException {
        return this.fFileChannel.size() - this.fFileChannel.position() > 0L;
    }

    public ByteOrder getByteOrder() {
        return this.fByteOrder;
    }

    public int getMajorVersion() {
        return this.fMajorVersion;
    }

    public int getMinorVersion() {
        return this.fMinorVersion;
    }

    public long getTimeAccuracy() {
        return this.fTimeAccuracy;
    }

    public long getTimeZoneCorrection() {
        return this.fTimeZoneCorrection;
    }

    public long getSnapLength() {
        return this.fSnapshotLength;
    }

    public long getDataLinkType() {
        return this.fDataLinkType;
    }

    public Path getPath() {
        return this.fPcapFilePath;
    }

    public synchronized long getTotalNbPackets() throws IOException, BadPcapFileException {
        if (this.fTotalNumberPackets == -1L) {
            long rank = this.fCurrentRank;
            this.fCurrentRank = this.fFileIndex.floorKey(rank);
            while (this.hasNextPacket()) {
                this.skipNextPacket();
            }
            this.fTotalNumberPackets = this.fCurrentRank;
            this.fCurrentRank = rank;
            this.seekPacket(rank);
        }
        return this.fTotalNumberPackets;
    }

    public synchronized long getCurrentRank() {
        return this.fCurrentRank;
    }

    public PcapTimestampScale getTimestampPrecision() {
        return this.fTimestampPrecision;
    }

    @Override
    public void close() throws IOException {
        this.fFileChannel.close();
    }
}

