/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.utilities;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIfExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLetExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGMapExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGMapPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNavigationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNumber;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGShadowExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGShadowPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTupleExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTuplePart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.RealValue;

public class EquivalenceUtil {
    public static @Nullable Boolean isEquivalent(@NonNull CGCallExp thisValue, @NonNull CGCallExp thatValue) {
        if (thisValue == thatValue) {
            return Boolean.TRUE;
        }
        CGValuedElement thisSource = thisValue.getSource();
        CGValuedElement thatSource = thatValue.getSource();
        if (thisSource != null || thatSource != null) {
            if (thisSource == null || thatSource == null) {
                return null;
            }
            Boolean equivalence = thisSource.isEquivalentTo(thatSource);
            if (equivalence != Boolean.TRUE) {
                return null;
            }
        }
        return Boolean.TRUE;
    }

    public static @Nullable Boolean isEquivalent(@NonNull CGCollectionExp thisValue, @NonNull CGCollectionExp thatValue) {
        if (thisValue == thatValue) {
            return Boolean.TRUE;
        }
        Element thisAST = thisValue.getAst();
        Element thatAST = thatValue.getAst();
        if (!(thisAST instanceof CollectionLiteralExp) || !(thatAST instanceof CollectionLiteralExp)) {
            return null;
        }
        if (((CollectionLiteralExp)thisAST).getKind() != ((CollectionLiteralExp)thatAST).getKind()) {
            return Boolean.FALSE;
        }
        List<CGCollectionPart> theseParts = thisValue.getParts();
        List<CGCollectionPart> thoseParts = thatValue.getParts();
        int iSize = theseParts.size();
        if (iSize != thoseParts.size()) {
            return null;
        }
        int i = 0;
        while (i < iSize) {
            CGCollectionPart thisPart = theseParts.get(i);
            CGCollectionPart thatPart = thoseParts.get(i);
            if (thisPart == null || thatPart == null) {
                return null;
            }
            Boolean equivalence = thisPart.isEquivalentTo(thatPart);
            if (equivalence != Boolean.TRUE) {
                return null;
            }
            ++i;
        }
        return Boolean.TRUE;
    }

    public static @Nullable Boolean isEquivalent(@NonNull CGCollectionPart thisValue, @NonNull CGCollectionPart thatValue) {
        if (thisValue == thatValue) {
            return Boolean.TRUE;
        }
        CGValuedElement thisLast = thisValue.getLast();
        CGValuedElement thatLast = thatValue.getLast();
        if (thisLast != null || thatLast != null) {
            if (thisLast == null || thatLast == null) {
                return null;
            }
            Boolean equivalence = thisLast.isEquivalentTo(thatLast);
            if (equivalence != Boolean.TRUE) {
                return equivalence;
            }
        }
        CGValuedElement thisFirst = thisValue.getFirst();
        CGValuedElement thatFirst = thatValue.getFirst();
        if (thisFirst == null || thatFirst == null) {
            return null;
        }
        return thisFirst.isEquivalentTo(thatFirst);
    }

    public static @Nullable Boolean isEquivalent(@NonNull CGIfExp thisValue, @NonNull CGIfExp thatValue) {
        if (thisValue == thatValue) {
            return Boolean.TRUE;
        }
        if (thisValue.isConstant() && thatValue.isConstant()) {
            CGValuedElement thisConstant = thisValue.getNamedValue();
            CGValuedElement thatConstant = thatValue.getNamedValue();
            return thisConstant.isEquivalentTo(thatConstant);
        }
        CGValuedElement thisCondition = thisValue.getCondition();
        CGValuedElement thatCondition = thatValue.getCondition();
        if (thisCondition != null || thatCondition != null) {
            if (thisCondition == null || thatCondition == null) {
                return null;
            }
            Boolean equivalence = thisCondition.isEquivalentTo(thatCondition);
            if (equivalence != Boolean.TRUE) {
                return null;
            }
        }
        CGValuedElement thisThen = thisValue.getThenExpression();
        CGValuedElement thatThen = thatValue.getThenExpression();
        if (thisThen != null || thatThen != null) {
            if (thisThen == null || thatThen == null) {
                return null;
            }
            Boolean equivalence = thisThen.isEquivalentTo(thatThen);
            if (equivalence != Boolean.TRUE) {
                return null;
            }
        }
        CGValuedElement thisElse = thisValue.getElseExpression();
        CGValuedElement thatElse = thatValue.getElseExpression();
        if (thisElse != null || thatElse != null) {
            if (thisElse == null || thatElse == null) {
                return null;
            }
            Boolean equivalence = thisElse.isEquivalentTo(thatElse);
            if (equivalence != Boolean.TRUE) {
                return null;
            }
        }
        return Boolean.TRUE;
    }

    public static @Nullable Boolean isEquivalent(@NonNull CGIterationCallExp thisValue, @NonNull CGIterationCallExp thatValue) {
        if (thisValue == thatValue) {
            return Boolean.TRUE;
        }
        Element thisAST = thisValue.getAst();
        Element thatAST = thatValue.getAst();
        if (!(thisAST instanceof LoopExp) || !(thatAST instanceof LoopExp)) {
            return null;
        }
        if (((LoopExp)thisAST).getReferredIteration() != ((LoopExp)thatAST).getReferredIteration()) {
            return null;
        }
        CGValuedElement thisSource = thisValue.getSource();
        CGValuedElement thatSource = thatValue.getSource();
        if (thisSource != null || thatSource != null) {
            if (thisSource == null || thatSource == null) {
                return null;
            }
            Boolean equivalence = thisSource.isEquivalentTo(thatSource);
            if (equivalence != Boolean.TRUE) {
                return null;
            }
        }
        CGValuedElement thisBody = thisValue.getBody();
        CGValuedElement thatBody = thatValue.getBody();
        if (thisBody != null || thatBody != null) {
            if (thisBody == null || thatBody == null) {
                return null;
            }
            Boolean equivalence = thisBody.isEquivalentTo(thatBody);
            if (equivalence != Boolean.TRUE) {
                return null;
            }
        }
        List<CGIterator> theseIterators = thisValue.getIterators();
        List<CGIterator> thoseIterators = thatValue.getIterators();
        int iSize = theseIterators.size();
        if (iSize != thoseIterators.size()) {
            return null;
        }
        int i = 0;
        while (i < iSize) {
            CGIterator thisIterator = theseIterators.get(i);
            CGIterator thatIterator = thoseIterators.get(i);
            if (thisIterator != null || thatIterator != null) {
                if (thisIterator == null || thatIterator == null) {
                    return null;
                }
                Boolean equivalence = thisIterator.isEquivalentTo(thatIterator);
                if (equivalence != Boolean.TRUE) {
                    return null;
                }
            }
            ++i;
        }
        List<CGIterator> theseCoIterators = thisValue.getCoIterators();
        List<CGIterator> thoseCoIterators = thatValue.getCoIterators();
        int iCoSize = theseCoIterators.size();
        if (iCoSize != thoseCoIterators.size()) {
            return null;
        }
        int i2 = 0;
        while (i2 < iCoSize) {
            CGIterator thisCoIterator = theseCoIterators.get(i2);
            CGIterator thatCoIterator = thoseCoIterators.get(i2);
            if (thisCoIterator != null || thatCoIterator != null) {
                if (thisCoIterator == null || thatCoIterator == null) {
                    return null;
                }
                Boolean equivalence = thisCoIterator.isEquivalentTo(thatCoIterator);
                if (equivalence != Boolean.TRUE) {
                    return null;
                }
            }
            ++i2;
        }
        return Boolean.TRUE;
    }

    public static @Nullable Boolean isEquivalent(@NonNull CGLetExp thisValue, @NonNull CGLetExp thatValue) {
        if (thisValue == thatValue) {
            return Boolean.TRUE;
        }
        if (thisValue.isConstant() && thatValue.isConstant()) {
            CGValuedElement thisConstant = thisValue.getNamedValue();
            CGValuedElement thatConstant = thatValue.getNamedValue();
            return thisConstant.isEquivalentTo(thatConstant);
        }
        CGVariable thisInit = thisValue.getInit();
        CGVariable thatInit = thatValue.getInit();
        if (thisInit != null || thatInit != null) {
            if (thisInit == null || thatInit == null) {
                return null;
            }
            Boolean equivalence = thisInit.isEquivalentTo(thatInit);
            if (equivalence != Boolean.TRUE) {
                return null;
            }
        }
        CGValuedElement thisIn = thisValue.getIn();
        CGValuedElement thatIn = thatValue.getIn();
        if (thisIn != null || thatIn != null) {
            if (thisIn == null || thatIn == null) {
                return null;
            }
            Boolean equivalence = thisIn.isEquivalentTo(thatIn);
            if (equivalence != Boolean.TRUE) {
                return null;
            }
        }
        return Boolean.TRUE;
    }

    public static @Nullable Boolean isEquivalent(@NonNull CGMapExp thisValue, @NonNull CGMapExp thatValue) {
        if (thisValue == thatValue) {
            return Boolean.TRUE;
        }
        Element thisAST = thisValue.getAst();
        Element thatAST = thatValue.getAst();
        if (!(thisAST instanceof MapLiteralExp) || !(thatAST instanceof MapLiteralExp)) {
            return null;
        }
        List<CGMapPart> theseParts = thisValue.getParts();
        List<CGMapPart> thoseParts = thatValue.getParts();
        int iSize = theseParts.size();
        if (iSize != thoseParts.size()) {
            return null;
        }
        int i = 0;
        while (i < iSize) {
            CGMapPart thisPart = theseParts.get(i);
            CGMapPart thatPart = thoseParts.get(i);
            if (thisPart == null || thatPart == null) {
                return null;
            }
            Boolean equivalence = thisPart.isEquivalentTo(thatPart);
            if (equivalence != Boolean.TRUE) {
                return null;
            }
            ++i;
        }
        return Boolean.TRUE;
    }

    public static @Nullable Boolean isEquivalent(@NonNull CGMapPart thisPart, @NonNull CGMapPart thatPart) {
        if (thisPart == thatPart) {
            return Boolean.TRUE;
        }
        CGValuedElement thisKey = thisPart.getKey();
        CGValuedElement thatKey = thatPart.getKey();
        if (thisKey != null || thatKey != null) {
            if (thisKey == null || thatKey == null) {
                return null;
            }
            Boolean equivalence = thisKey.isEquivalentTo(thatKey);
            if (equivalence != Boolean.TRUE) {
                return equivalence;
            }
        }
        CGValuedElement thisValue = thisPart.getValue();
        CGValuedElement thatValue = thatPart.getValue();
        if (thisValue == null || thatValue == null) {
            return null;
        }
        return thisValue.isEquivalentTo(thatValue);
    }

    public static @Nullable Boolean isEquivalent(@NonNull CGNumber thisValue, @NonNull CGNumber thatValue) {
        double thatDouble;
        if (thisValue == thatValue) {
            return Boolean.TRUE;
        }
        Number thisNumber = thisValue.getNumericValue();
        Number thatNumber = thatValue.getNumericValue();
        if (thisNumber == null || thatNumber == null) {
            return null;
        }
        if (thisNumber.getClass() == thatNumber.getClass()) {
            return thisNumber.equals(thatNumber);
        }
        if (thisNumber instanceof RealValue && thatNumber instanceof RealValue) {
            return thisNumber.equals(thatNumber);
        }
        if (ValueUtil.isRealNumber((Number)thisNumber) || ValueUtil.isRealNumber((Number)thatNumber)) {
            RealValue thisReal = ValueUtil.realValueOf((Number)thisNumber);
            RealValue thatReal = ValueUtil.realValueOf((Number)thatNumber);
            return thisReal.equals(thatReal);
        }
        if (ValueUtil.isIntegerNumber((Number)thisNumber) && ValueUtil.isIntegerNumber((Number)thatNumber)) {
            IntegerValue thisInteger = ValueUtil.integerValueOf((Object)thisNumber);
            IntegerValue thatInterger = ValueUtil.integerValueOf((Object)thatNumber);
            return thisInteger.equals(thatInterger);
        }
        double thisDouble = thisNumber.doubleValue();
        if (thisDouble == (thatDouble = thatNumber.doubleValue())) {
            return true;
        }
        return false;
    }

    public static @Nullable Boolean isEquivalent(@NonNull CGOperationCallExp thisValue, @NonNull CGOperationCallExp thatValue) {
        if (thisValue == thatValue) {
            return Boolean.TRUE;
        }
        Element thisAST = thisValue.getAst();
        Element thatAST = thatValue.getAst();
        if (!(thisAST instanceof OperationCallExp) || !(thatAST instanceof OperationCallExp)) {
            return null;
        }
        if (((OperationCallExp)thisAST).getReferredOperation() != ((OperationCallExp)thatAST).getReferredOperation()) {
            return null;
        }
        CGValuedElement thisSource = thisValue.getSource();
        CGValuedElement thatSource = thatValue.getSource();
        if (thisSource != null || thatSource != null) {
            if (thisSource == null || thatSource == null) {
                return null;
            }
            Boolean equivalence = thisSource.isEquivalentTo(thatSource);
            if (equivalence != Boolean.TRUE) {
                return null;
            }
        }
        List<CGValuedElement> theseArguments = thisValue.getArguments();
        List<CGValuedElement> thoseArguments = thatValue.getArguments();
        int iSize = theseArguments.size();
        if (iSize != thoseArguments.size()) {
            return null;
        }
        int i = 0;
        while (i < iSize) {
            CGValuedElement thisArgument = theseArguments.get(i);
            CGValuedElement thatArgument = thoseArguments.get(i);
            if (thisArgument != null || thatArgument != null) {
                if (thisArgument == null || thatArgument == null) {
                    return null;
                }
                Boolean equivalence = thisArgument.isEquivalentTo(thatArgument);
                if (equivalence != Boolean.TRUE) {
                    return null;
                }
            }
            ++i;
        }
        return Boolean.TRUE;
    }

    public static @Nullable Boolean isEquivalent(@NonNull CGNavigationCallExp thisValue, @NonNull CGNavigationCallExp thatValue) {
        Property thatProperty;
        if (thisValue == thatValue) {
            return Boolean.TRUE;
        }
        Element thisAST = thisValue.getAst();
        Element thatAST = thatValue.getAst();
        if (!(thisAST instanceof NavigationCallExp) || !(thatAST instanceof NavigationCallExp)) {
            return null;
        }
        if (thisAST.eClass() != thatAST.eClass()) {
            return null;
        }
        Property thisProperty = thisAST instanceof PropertyCallExp ? ((PropertyCallExp)thisAST).getReferredProperty() : ((OppositePropertyCallExp)thisAST).getReferredProperty();
        Property property = thatProperty = thatAST instanceof PropertyCallExp ? ((PropertyCallExp)thatAST).getReferredProperty() : ((OppositePropertyCallExp)thatAST).getReferredProperty();
        if (thisProperty != thatProperty) {
            return null;
        }
        CGValuedElement thisSource = thisValue.getSource();
        CGValuedElement thatSource = thatValue.getSource();
        if (thisSource != null || thatSource != null) {
            if (thisSource == null || thatSource == null) {
                return null;
            }
            Boolean equivalence = thisSource.isEquivalentTo(thatSource);
            if (equivalence != Boolean.TRUE) {
                return null;
            }
        }
        return Boolean.TRUE;
    }

    public static @Nullable Boolean isEquivalent(@NonNull CGShadowExp thisValue, @NonNull CGShadowExp thatValue) {
        if (thisValue == thatValue) {
            return Boolean.TRUE;
        }
        Element thisAST = thisValue.getAst();
        Element thatAST = thatValue.getAst();
        if (!(thisAST instanceof ShadowExp) || !(thatAST instanceof ShadowExp)) {
            return null;
        }
        if (((ShadowExp)thisAST).getTypeId() != ((ShadowExp)thatAST).getTypeId()) {
            return Boolean.FALSE;
        }
        List<CGShadowPart> theseParts = thisValue.getParts();
        List<CGShadowPart> thoseParts = thatValue.getParts();
        int iSize = theseParts.size();
        if (iSize != thoseParts.size()) {
            return Boolean.FALSE;
        }
        int i = 0;
        while (i < iSize) {
            CGShadowPart thisPart = theseParts.get(i);
            CGShadowPart thatPart = thoseParts.get(i);
            if (thisPart == null || thatPart == null) {
                return null;
            }
            Boolean equivalence = thisPart.isEquivalentTo(thatPart);
            if (equivalence != Boolean.TRUE) {
                return equivalence;
            }
            ++i;
        }
        return Boolean.TRUE;
    }

    public static @Nullable Boolean isEquivalent(@NonNull CGShadowPart thisValue, @NonNull CGShadowPart thatValue) {
        if (thisValue == thatValue) {
            return Boolean.TRUE;
        }
        Element thisAST = thisValue.getAst();
        Element thatAST = thatValue.getAst();
        if (!(thisAST instanceof ShadowPart) || !(thatAST instanceof ShadowPart)) {
            return null;
        }
        if (((ShadowPart)thisAST).getTypeId() != ((ShadowPart)thatAST).getTypeId()) {
            return Boolean.FALSE;
        }
        CGValuedElement thisPartInit = thisValue.getInit();
        CGValuedElement thatPartInit = thatValue.getInit();
        if (thisPartInit == null || thatPartInit == null) {
            return null;
        }
        return thisPartInit.isEquivalentTo(thatPartInit);
    }

    public static @Nullable Boolean isEquivalent(@NonNull CGTupleExp thisValue, @NonNull CGTupleExp thatValue) {
        if (thisValue == thatValue) {
            return Boolean.TRUE;
        }
        Element thisAST = thisValue.getAst();
        Element thatAST = thatValue.getAst();
        if (!(thisAST instanceof TupleLiteralExp) || !(thatAST instanceof TupleLiteralExp)) {
            return null;
        }
        if (((TupleLiteralExp)thisAST).getTypeId() != ((TupleLiteralExp)thatAST).getTypeId()) {
            return Boolean.FALSE;
        }
        List<CGTuplePart> theseParts = thisValue.getParts();
        List<CGTuplePart> thoseParts = thatValue.getParts();
        int iSize = theseParts.size();
        if (iSize != thoseParts.size()) {
            return Boolean.FALSE;
        }
        int i = 0;
        while (i < iSize) {
            CGTuplePart thisPart = theseParts.get(i);
            CGTuplePart thatPart = thoseParts.get(i);
            if (thisPart == null || thatPart == null) {
                return null;
            }
            Boolean equivalence = thisPart.isEquivalentTo(thatPart);
            if (equivalence != Boolean.TRUE) {
                return equivalence;
            }
            ++i;
        }
        return Boolean.TRUE;
    }

    public static @Nullable Boolean isEquivalent(@NonNull CGTuplePart thisValue, @NonNull CGTuplePart thatValue) {
        if (thisValue == thatValue) {
            return Boolean.TRUE;
        }
        Element thisAST = thisValue.getAst();
        Element thatAST = thatValue.getAst();
        if (!(thisAST instanceof TupleLiteralPart) || !(thatAST instanceof TupleLiteralPart)) {
            return null;
        }
        if (((TupleLiteralPart)thisAST).getTypeId() != ((TupleLiteralPart)thatAST).getTypeId()) {
            return Boolean.FALSE;
        }
        CGValuedElement thisPartInit = thisValue.getInit();
        CGValuedElement thatPartInit = thatValue.getInit();
        if (thisPartInit == null || thatPartInit == null) {
            return null;
        }
        return thisPartInit.isEquivalentTo(thatPartInit);
    }
}

