/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.constants;

import org.apache.commons.lang.StringUtils;

public final class TestExecutionConstants {
    public static final String EXIT_INVALID_ARGUMENT = "invalid argument";

    private TestExecutionConstants() {
    }

    public static enum RunSteps {
        CDB("cdb", "the connection to the database"),
        LP("lp", "the project loading"),
        CC("cc", "the completeness check"),
        CAA("caa", "the connection to the AUT Agent"),
        SA("sa", "the AUT start"),
        CA("ca", "connection to the AUT"),
        RPV("rpv", "resolution of the pre-defined variables"),
        PTE("pte", "the preparation of the test execution: clear external data (e.g. the caches)"),
        BT("bt", "the step to build the test execution tree"),
        NORMAL("normal", "the normal test execution without no-run mode");

        private String m_stepValue;
        private String m_description;

        private RunSteps(String stepValue, String description) {
            this.m_stepValue = stepValue;
            this.m_description = description;
        }

        public String getStepValue() {
            return this.m_stepValue;
        }

        public String getDescription() {
            return this.m_description;
        }

        public static String validateRunStep(String runStepValue) {
            if (StringUtils.isEmpty((String)runStepValue)) {
                return RunSteps.getDefaultNoRunMode();
            }
            RunSteps[] runStepsArray = RunSteps.values();
            int n = runStepsArray.length;
            int n2 = 0;
            while (n2 < n) {
                RunSteps noRunOptMode = runStepsArray[n2];
                if (noRunOptMode.getStepValue().equals(runStepValue)) {
                    return runStepValue;
                }
                ++n2;
            }
            return TestExecutionConstants.EXIT_INVALID_ARGUMENT;
        }

        private static String getDefaultNoRunMode() {
            RunSteps defaultMode = CC;
            return defaultMode.getStepValue();
        }
    }
}

