/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.Set;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;

public class CompNameTypeManager {
    private CompNameTypeManager() {
    }

    public static String calcUsageType(String type1, String type2) {
        if (type1 == null || type2 == null) {
            return "guidancer.abstract.Unknown";
        }
        CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
        Component comp1 = CompNameTypeManager.getMostConcreteVisibleAncestor(compSystem.findComponent(type1), compSystem);
        Component comp2 = CompNameTypeManager.getMostConcreteVisibleAncestor(compSystem.findComponent(type2), compSystem);
        if (comp1 == null || comp2 == null) {
            return "guidancer.abstract.Unknown";
        }
        Component moreConcrete = CompNameTypeManager.getMoreConcreteComponent(comp1, comp2, true);
        if (moreConcrete == null) {
            return "guidancer.abstract.Unknown";
        }
        String compType = moreConcrete.getType();
        if ((moreConcrete = CompNameTypeManager.getMostConcreteVisibleAncestor(moreConcrete, compSystem)) != null) {
            compType = moreConcrete.getType();
        }
        if (compType != null) {
            return compType;
        }
        return "guidancer.abstract.Unknown";
    }

    public static String getMostAbstractType() {
        return ComponentBuilder.getInstance().getCompSystem().getMostAbstractComponent().getType();
    }

    public static boolean doesFirstTypeRealizeSecond(String first, String second) {
        if (first == null || second == null) {
            return false;
        }
        if (first.equals(second)) {
            return true;
        }
        CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
        Component comp1 = compSystem.getComponentForType(first);
        if (comp1 == null) {
            return false;
        }
        return comp1.isRealizing(second);
    }

    private static Component getMoreConcreteComponent(Component comp1, Component comp2, boolean isFirstCall) {
        if (comp1 == null || comp2 == null) {
            return null;
        }
        if (comp1.equals((Object)comp2)) {
            return comp1;
        }
        String comp2Type = comp2.getType();
        for (Component realizer : comp1.getAllRealizers()) {
            if (!realizer.getType().equals(comp2Type)) continue;
            return realizer;
        }
        return isFirstCall ? CompNameTypeManager.getMoreConcreteComponent(comp2, comp1, false) : null;
    }

    private static Component getMostConcreteVisibleAncestor(Component component, CompSystem compSystem) {
        Component comp = component;
        while (comp != null && !comp.isVisible()) {
            Set realized = comp.getAllRealized();
            comp = compSystem.getMostConcrete(realized.toArray(new Component[realized.size()]));
        }
        return comp;
    }

    public static String getMostConcreteVisibleAncestorType(String type) {
        if (type == null) {
            return "guidancer.abstract.Unknown";
        }
        CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
        Component comp = compSystem.findComponent(type);
        if (comp == null) {
            return "guidancer.abstract.Unknown";
        }
        Component ancestor = CompNameTypeManager.getMostConcreteVisibleAncestor(comp, compSystem);
        return ancestor == null ? "guidancer.abstract.Unknown" : ancestor.getType();
    }

    public static boolean mayBeCompatible(IComponentNamePO cN, String type) {
        if (cN.getComponentType() == null) {
            return false;
        }
        return !(!CompNameTypeManager.doesFirstTypeRealizeSecond(type, cN.getUsageType()) && !CompNameTypeManager.doesFirstTypeRealizeSecond(cN.getUsageType(), type) || !cN.getComponentType().equals(cN.getUsageType()) && !CompNameTypeManager.doesFirstTypeRealizeSecond(cN.getComponentType(), type));
    }
}

