/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jgit.attributes.FilterCommand;
import org.eclipse.jgit.attributes.FilterCommandFactory;
import org.eclipse.jgit.attributes.FilterCommandRegistry;
import org.eclipse.jgit.lfs.Lfs;
import org.eclipse.jgit.lfs.LfsPointer;
import org.eclipse.jgit.lfs.errors.CorruptMediaFile;
import org.eclipse.jgit.lfs.internal.AtomicObjectOutputStream;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;

public class CleanFilter
extends FilterCommand {
    public static final FilterCommandFactory FACTORY = new FilterCommandFactory(){

        public FilterCommand create(Repository db, InputStream in, OutputStream out) throws IOException {
            return new CleanFilter(db, in, out);
        }
    };
    private AtomicObjectOutputStream aOut;
    private Lfs lfsUtil;
    private long size;
    private Path tmpFile;

    static void register() {
        FilterCommandRegistry.register((String)"jgit://builtin/lfs/clean", (FilterCommandFactory)FACTORY);
    }

    public CleanFilter(Repository db, InputStream in, OutputStream out) throws IOException {
        super(in, out);
        this.lfsUtil = new Lfs(db);
        Files.createDirectories(this.lfsUtil.getLfsTmpDir(), new FileAttribute[0]);
        this.tmpFile = this.lfsUtil.createTmpFile();
        this.aOut = new AtomicObjectOutputStream(this.tmpFile.toAbsolutePath());
    }

    public int run() throws IOException {
        try {
            byte[] buf = new byte[8192];
            int length = this.in.read(buf);
            if (length != -1) {
                this.aOut.write(buf, 0, length);
                this.size += (long)length;
                return length;
            }
            this.aOut.close();
            AnyLongObjectId loid = this.aOut.getId();
            this.aOut = null;
            Path mediaFile = this.lfsUtil.getMediaFile(loid);
            if (Files.isRegularFile(mediaFile, new LinkOption[0])) {
                long fsSize = Files.size(mediaFile);
                if (fsSize != this.size) {
                    throw new CorruptMediaFile(mediaFile, this.size, fsSize);
                }
                FileUtils.delete((File)this.tmpFile.toFile());
            } else {
                Path parent = mediaFile.getParent();
                if (parent != null) {
                    FileUtils.mkdirs((File)parent.toFile(), (boolean)true);
                }
                FileUtils.rename((File)this.tmpFile.toFile(), (File)mediaFile.toFile(), (CopyOption[])new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
            }
            LfsPointer lfsPointer = new LfsPointer(loid, this.size);
            lfsPointer.encode(this.out);
            this.in.close();
            this.out.close();
            return -1;
        }
        catch (IOException e) {
            if (this.aOut != null) {
                this.aOut.abort();
            }
            this.in.close();
            this.out.close();
            throw e;
        }
    }
}

