/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.dialogs;

import static java.util.concurrent.TimeUnit.SECONDS;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class UI {
    private static final Point TOOLTIP_DISPLACEMENT = new Point(5, 20);
    private static final int TOOLTIP_HIDE_DELAY = (int) SECONDS.toMillis(20);

    private static boolean isAnyNull(Object... arguments) {
        for (Object argument : arguments) {
            if (argument == null) {
                return true;
            }
        }
        return false;
    }

    public static GridDataFactory gd() {
        return GridDataFactory.fillDefaults();
    }

    public static void gd(Control control) {
        GridDataFactory.defaultsFor(control).applyTo(control);
    }

    public static GridDataFactory gdGrabHV() {
        return GridDataFactory.fillDefaults().grab(true, true);
    }

    public static GridDataFactory gdGrabH() {
        return GridDataFactory.fillDefaults().grab(true, false);
    }

    public static GridDataFactory gdGrabV() {
        return GridDataFactory.fillDefaults().grab(false, true);
    }

    public static void gdGrabH(Control control) {
        gdGrabH().applyTo(control);
    }

    public static GridLayoutFactory gl() {
        return GridLayoutFactory.fillDefaults();
    }

    public static boolean isUIThread() {
        return Display.getCurrent() != null;
    }

    public static Button createCheckButton(Composite parent, String text, String toolTip) {
        Button button = new Button(parent, SWT.CHECK);
        button.setText(text);
        calibrateToolTip(new DefaultToolTip(button), toolTip);
        return button;
    }

    public static Text createLabelWithText(Composite parent, String labelText, String textMessage, String toolTip) {
        {
            Label label = new Label(parent, SWT.NONE);
            label.setText(labelText);
            calibrateToolTip(new DefaultToolTip(label), toolTip);
        }
        {
            Text text = new Text(parent, SWT.BORDER);
            text.setMessage(textMessage);
            calibrateToolTip(new DefaultToolTip(text), toolTip);
            gdGrabH().applyTo(text);
            return text;
        }
    }

    public static void calibrateToolTip(DefaultToolTip toolTip, String toolTipText) {
        toolTip.setText(toolTipText);
        toolTip.setFont(JFaceResources.getDialogFont());
        toolTip.setShift(TOOLTIP_DISPLACEMENT);
        toolTip.setHideDelay(TOOLTIP_HIDE_DELAY);
    }
}
