/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template;

import java.lang.reflect.Method;
import java.util.Iterator;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.ui.internal.template.AsyncProposalPosition;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ICompletionProposalProvider;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ILinkedAsyncProposalListener;
import org.eclipse.scout.sdk.s2e.ui.internal.template.PositionInformationBridge;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class LinkedAsyncProposalModelPresenter {
    public void enterLinkedMode(ITextViewer viewer, IEditorPart editor, boolean switchedEditor, LinkedProposalModel linkedProposalModel) throws BadLocationException {
        int cursorPosition;
        IDocument document = viewer.getDocument();
        LinkedModeModel model = new LinkedModeModel();
        final LinkedModeUI[] holder = new LinkedModeUI[1];
        final Display display = Display.getCurrent();
        ILinkedAsyncProposalListener listener = new ILinkedAsyncProposalListener(){

            @Override
            public void loaded() {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LinkedModeUI ui = holder[0];
                            if (ui == null) {
                                return;
                            }
                            Method m = LinkedModeUI.class.getDeclaredMethod("triggerContentAssist", new Class[0]);
                            m.setAccessible(true);
                            m.invoke((Object)ui, new Object[0]);
                        }
                        catch (Exception t) {
                            SdkLog.debug((Object[])new Object[]{t});
                        }
                    }
                });
            }
        };
        Iterator iterator = linkedProposalModel.getPositionGroupIterator();
        while (iterator.hasNext()) {
            Object pos;
            LinkedProposalPositionGroup curr = (LinkedProposalPositionGroup)iterator.next();
            LinkedPositionGroup group = new LinkedPositionGroup();
            Object[] positions = PositionInformationBridge.getPositions(curr);
            if (positions.length <= 0) continue;
            if (curr instanceof ICompletionProposalProvider) {
                int i = 0;
                while (i < positions.length) {
                    pos = positions[i];
                    if (PositionInformationBridge.getOffset(pos) != -1) {
                        ICompletionProposalProvider proposalProvider = (ICompletionProposalProvider)curr;
                        if (display != null) {
                            proposalProvider.addListener(listener);
                        }
                        group.addPosition((LinkedPosition)new AsyncProposalPosition(document, PositionInformationBridge.getOffset(pos), PositionInformationBridge.getLength(pos), PositionInformationBridge.getSequenceRank(pos), proposalProvider, model));
                    }
                    ++i;
                }
            } else {
                int n;
                LinkedProposalPositionGroup.Proposal[] linkedModeProposals = curr.getProposals();
                if (linkedModeProposals.length <= 1) {
                    Object[] objectArray = positions;
                    n = positions.length;
                    int proposalProvider = 0;
                    while (proposalProvider < n) {
                        pos = objectArray[proposalProvider];
                        if (PositionInformationBridge.getOffset(pos) != -1) {
                            group.addPosition(new LinkedPosition(document, PositionInformationBridge.getOffset(pos), PositionInformationBridge.getLength(pos), PositionInformationBridge.getSequenceRank(pos)));
                        }
                        ++proposalProvider;
                    }
                } else {
                    LinkedPositionProposalImpl[] proposalImpls = new LinkedPositionProposalImpl[linkedModeProposals.length];
                    int i = 0;
                    while (i < linkedModeProposals.length) {
                        proposalImpls[i] = new LinkedPositionProposalImpl(linkedModeProposals[i], model);
                        ++i;
                    }
                    Object[] objectArray = positions;
                    int n2 = positions.length;
                    n = 0;
                    while (n < n2) {
                        Object pos2 = objectArray[n];
                        if (PositionInformationBridge.getOffset(pos2) != -1) {
                            group.addPosition((LinkedPosition)new ProposalPosition(document, PositionInformationBridge.getOffset(pos2), PositionInformationBridge.getLength(pos2), PositionInformationBridge.getSequenceRank(pos2), (ICompletionProposal[])proposalImpls));
                        }
                        ++n;
                    }
                }
            }
            model.addGroup(group);
        }
        model.forceInstall();
        if (editor instanceof JavaEditor) {
            model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer((JavaEditor)editor));
        }
        EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
        holder[0] = ui;
        Object endPosition = PositionInformationBridge.getEndPosition(linkedProposalModel);
        int offset = -1;
        if (endPosition != null) {
            offset = PositionInformationBridge.getOffset(endPosition);
        }
        if (offset != -1) {
            ui.setExitPosition(viewer, offset + PositionInformationBridge.getLength(endPosition), 0, Integer.MAX_VALUE);
        } else if (!switchedEditor && (cursorPosition = viewer.getSelectedRange().x) != 0) {
            ui.setExitPosition(viewer, cursorPosition, 0, Integer.MAX_VALUE);
        }
        ui.setExitPolicy((LinkedModeUI.IExitPolicy)new LinkedModeExitPolicy());
        ui.enter();
        IRegion region = ui.getSelectedRegion();
        viewer.setSelectedRange(region.getOffset(), region.getLength());
        viewer.revealRange(region.getOffset(), region.getLength());
    }

    private static final class LinkedModeExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private LinkedModeExitPolicy() {
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (event.character == '=') {
                return new LinkedModeUI.ExitFlags(1, true);
            }
            return null;
        }
    }

    static class LinkedPositionProposalImpl
    implements ICompletionProposalExtension2,
    IJavaCompletionProposal {
        private final LinkedProposalPositionGroup.Proposal m_proposal;
        private final LinkedModeModel m_linkedPositionModel;

        LinkedPositionProposalImpl(LinkedProposalPositionGroup.Proposal proposal, LinkedModeModel model) {
            this.m_proposal = proposal;
            this.m_linkedPositionModel = model;
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
            IDocument doc = viewer.getDocument();
            LinkedPosition position = this.m_linkedPositionModel.findPosition(new LinkedPosition(doc, offset, 0));
            if (position == null) {
                return;
            }
            try {
                TextEdit edit = this.m_proposal.computeEdits(offset, position, trigger, stateMask, this.m_linkedPositionModel);
                if (edit != null) {
                    edit.apply(position.getDocument(), 0);
                }
            }
            catch (Exception e) {
                SdkLog.info((String)"Unable to apply text edit.", (Object[])new Object[]{e});
            }
        }

        public String getDisplayString() {
            return this.m_proposal.getDisplayString();
        }

        public Image getImage() {
            return this.m_proposal.getImage();
        }

        public int getRelevance() {
            return this.m_proposal.getRelevance();
        }

        public void apply(IDocument document) {
        }

        public String getAdditionalProposalInfo() {
            return this.m_proposal.getAdditionalProposalInfo();
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public void selected(ITextViewer viewer, boolean smartToggle) {
        }

        public void unselected(ITextViewer viewer) {
        }

        public boolean validate(IDocument document, int offset, DocumentEvent event) {
            String insert = this.getDisplayString();
            LinkedPosition pos = this.m_linkedPositionModel.findPosition(new LinkedPosition(document, offset, 0));
            int off = pos != null ? pos.getOffset() : Math.max(0, offset - insert.length());
            int length = offset - off;
            if (offset <= document.getLength()) {
                try {
                    String content = document.get(off, length);
                    if (insert.startsWith(content)) {
                        return true;
                    }
                }
                catch (BadLocationException e) {
                    JavaPlugin.log((Throwable)e);
                }
            }
            return false;
        }
    }
}

