/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml.dtd;

import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Map;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.xml.dtd.internal.DtdParserImpl;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;

public final class DtdParser {
    @Text(value="Failed while parsing DTD located at \"{0}\".")
    private static LocalizableText parseFailed;

    static {
        LocalizableText.init(DtdParser.class);
    }

    public static XmlDocumentSchema parse(URL url) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = url.openStream();){
                return DtdParser.parse(MiscUtil.readTextContent((InputStream)in));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            String message = parseFailed.format(new Object[]{url});
            throw new RuntimeException(message, e);
        }
    }

    public static XmlDocumentSchema parse(String dtd) {
        try {
            String content = dtd;
            DtdParserImpl parser = new DtdParserImpl(new StringReader(content));
            parser.Start();
            if (!parser.entities.isEmpty()) {
                String substitutedContent = DtdParser.substituteEntity(content, parser.entities);
                while (!content.equals(substitutedContent)) {
                    content = substitutedContent;
                    substitutedContent = DtdParser.substituteEntity(content, parser.entities);
                }
                parser = new DtdParserImpl(new StringReader(content));
                parser.Start();
            }
            return parser.schema.create();
        }
        catch (Exception e) {
            String message = parseFailed.format(new Object[]{"##string##"});
            throw new RuntimeException(message, e);
        }
    }

    private static String substituteEntity(String content, Map<String, String> entities) {
        for (Map.Entry<String, String> entity : entities.entrySet()) {
            content = content.replace("%" + entity.getKey() + ";", entity.getValue());
        }
        return content;
    }
}

