/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PossibleTypesService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.xml.ChildXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlUtil;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;
import org.eclipse.sapphire.util.ListFactory;

public class StandardXmlListBindingImpl
extends LayeredListPropertyBinding {
    @Text(value="{0}.{1} : {2}")
    private static LocalizableText failure;
    @Text(value="Element name must be specified in @XmlListBinding.Mapping annotation.")
    private static LocalizableText mustSpecifyElementNameMsg;
    private PossibleTypesService possibleTypesService;
    private Listener possibleTypesServiceListener;
    protected XmlPath path;
    protected QName[] xmlElementNames;
    protected ElementType[] modelElementTypes;

    static {
        LocalizableText.init(StandardXmlListBindingImpl.class);
    }

    public void init(final Property property) {
        super.init(property);
        this.possibleTypesService = (PossibleTypesService)property.service(PossibleTypesService.class);
        this.possibleTypesServiceListener = new Listener(){

            public void handle(Event event) {
                try {
                    StandardXmlListBindingImpl.this.initBindingMetadata();
                }
                catch (Exception e) {
                    String msg = failure.format(new Object[]{property.element().type().getSimpleName(), property.name(), e.getMessage()});
                    ((LoggingService)Sapphire.service(LoggingService.class)).logError(msg);
                }
            }
        };
        this.possibleTypesService.attach(this.possibleTypesServiceListener);
        try {
            this.initBindingMetadata();
        }
        catch (Exception e) {
            String msg = failure.format(new Object[]{property.element().type().getSimpleName(), property.name(), e.getMessage()});
            throw new RuntimeException(msg, e);
        }
    }

    protected void initBindingMetadata() {
        XmlListBinding annotation = (XmlListBinding)this.property().definition().getAnnotation(XmlListBinding.class);
        XmlNamespaceResolver xmlNamespaceResolver = ((XmlResource)this.property().element().resource()).getXmlNamespaceResolver();
        Set possible = this.possibleTypesService.types();
        this.modelElementTypes = possible.toArray(new ElementType[possible.size()]);
        if (annotation == null) {
            this.path = new XmlPath(this.property().name(), xmlNamespaceResolver);
            this.xmlElementNames = new QName[this.modelElementTypes.length];
            int i = 0;
            while (i < this.modelElementTypes.length) {
                this.xmlElementNames[i] = this.createDefaultElementName(this.modelElementTypes[i], xmlNamespaceResolver);
                ++i;
            }
        } else {
            if (annotation.path().length() > 0) {
                this.path = new XmlPath(annotation.path(), xmlNamespaceResolver);
            }
            XmlListBinding.Mapping[] mappings = annotation.mappings();
            this.xmlElementNames = new QName[this.modelElementTypes.length];
            int i = 0;
            while (i < this.modelElementTypes.length) {
                ElementType type = this.modelElementTypes[i];
                XmlListBinding.Mapping[] mappingArray = mappings;
                int n = mappings.length;
                int n2 = 0;
                while (n2 < n) {
                    XmlListBinding.Mapping mapping = mappingArray[n2];
                    if (mapping.type() == type.getModelElementClass()) {
                        String mappingElementName = mapping.element().trim();
                        if (mappingElementName.length() == 0) {
                            throw new RuntimeException(mustSpecifyElementNameMsg.text());
                        }
                        this.xmlElementNames[i] = XmlUtil.createQualifiedName(mappingElementName, xmlNamespaceResolver);
                        break;
                    }
                    ++n2;
                }
                if (this.xmlElementNames[i] == null) {
                    this.xmlElementNames[i] = this.createDefaultElementName(type, xmlNamespaceResolver);
                }
                ++i;
            }
        }
    }

    protected QName createDefaultElementName(ElementType type, XmlNamespaceResolver xmlNamespaceResolver) {
        return XmlUtil.createDefaultElementName(type);
    }

    public ElementType type(Resource resource) {
        XmlElement xmlElement = ((XmlResource)resource).getXmlElement();
        QName xmlElementName = XmlUtil.createQualifiedName(xmlElement.getDomNode());
        String xmlElementNamespace = xmlElementName.getNamespaceURI();
        int i = 0;
        while (i < this.xmlElementNames.length) {
            if (XmlUtil.equal(this.xmlElementNames[i], xmlElementName, xmlElementNamespace)) {
                return this.modelElementTypes[i];
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    protected Resource resource(Object obj) {
        XmlElement xmlElement = (XmlElement)obj;
        XmlResource parentXmlResource = (XmlResource)this.property().element().resource();
        return new ChildXmlResource(parentXmlResource, xmlElement);
    }

    protected List<?> readUnderlyingList() {
        XmlElement parent = this.getXmlElement(false);
        if (parent == null) {
            return Collections.emptyList();
        }
        ListFactory list = ListFactory.start();
        for (XmlElement element : parent.getChildElements()) {
            QName xmlElementName = XmlUtil.createQualifiedName(element.getDomNode());
            if (!XmlUtil.contains(this.xmlElementNames, xmlElementName, xmlElementName.getNamespaceURI())) continue;
            list.add((Object)element);
        }
        return list.result();
    }

    protected Object insertUnderlyingObject(ElementType type, int position) {
        List<?> list;
        XmlElement parent = this.getXmlElement(true);
        QName xmlElementName = this.xmlElementNames[MiscUtil.indexOf((Object[])this.modelElementTypes, (Object)type)];
        if (xmlElementName.getNamespaceURI().equals("")) {
            xmlElementName = new QName(parent.getNamespace(), xmlElementName.getLocalPart());
        }
        XmlElement refXmlElement = position < (list = this.readUnderlyingList()).size() ? list.get(position) : null;
        return parent.addChildElement(xmlElementName, refXmlElement);
    }

    public void move(Resource resource, int position) {
        List<?> list = this.readUnderlyingList();
        XmlElement xmlElement = ((ChildXmlResource)resource).getXmlElement();
        XmlElement refXmlElement = position < list.size() ? list.get(position) : null;
        xmlElement.move(refXmlElement);
    }

    public void remove(Resource resource) {
        XmlElement parent;
        XmlElement base;
        XmlResource xmlResource = (XmlResource)resource;
        XmlElement xmlElement = xmlResource.getXmlElement();
        xmlElement.remove();
        if (this.path != null && (base = this.getBaseXmlElement(false)) != null && (parent = (XmlElement)base.getChildNode(this.path, false)) != null && parent.isEmpty()) {
            base.removeChildNode(this.path);
        }
    }

    protected XmlElement getXmlElement(boolean createIfNecessary) {
        XmlElement parent = this.getBaseXmlElement(createIfNecessary);
        if (parent != null && this.path != null) {
            parent = (XmlElement)parent.getChildNode(this.path, createIfNecessary);
        }
        return parent;
    }

    protected XmlElement getBaseXmlElement(boolean createIfNecessary) {
        XmlResource resource = (XmlResource)this.property().element().resource();
        return resource.getXmlElement(createIfNecessary);
    }

    public void dispose() {
        super.dispose();
        if (this.possibleTypesService != null) {
            this.possibleTypesService.detach(this.possibleTypesServiceListener);
        }
    }
}

