/*******************************************************************************
 * Copyright (c) 2015, 2018 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Red Hat Inc - initial API and implementation
 *******************************************************************************/
package org.eclipse.linuxtools.internal.oprofile.ui.view;

import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

/**
 * Simple View to show text output of OCount
 * @author jjohnstn
 *
 */
public class OcountView extends ViewPart {

	String text = ""; //$NON-NLS-1$
	TextViewer viewer;
	Composite parent;

	@Override
	public void createPartControl(Composite parent) {
        viewer = new TextViewer(parent, SWT.V_SCROLL | SWT.H_SCROLL);
        viewer.setEditable(false);
        viewer.getTextWidget().setFont(JFaceResources.getFont(IDebugUIConstants.PREF_DETAIL_PANE_FONT));
        Control control=viewer.getControl();
        GridData gd=new GridData(GridData.FILL_BOTH);
        control.setLayoutData(gd);
        Document d = new Document(text);
        viewer.setDocument(d);
        viewer.refresh();
        OprofileUiPlugin.getDefault().setOcountView(this);
        this.parent = parent;
	}

	public void setText(String text) {
        Document d = new Document(text);
        viewer.setDocument(d);
	}
    /**
     * Refresh the view or open a new instance if it was closed.
     */
    public void refreshView() {
        // Need to create another view object if it was closed.
        if(parent == null || parent.isDisposed()) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(OprofileUiPlugin.ID_OCOUNT_VIEW);
                String currentText = viewer.getDocument().get();
                OprofileUiPlugin.getDefault().getOcountView().setText(currentText);
                return;
            } catch (PartInitException e2) {
                e2.printStackTrace();
            }
        }
        viewer.refresh();
    }
	/**
	 * Get the Text Viewer
	 *
	 * @return the text viewer for this View
	 */
	public TextViewer getViewer() {
		return viewer;
	}

	@Override
	public void setFocus() {
		// TODO Auto-generated method stub

	}

}
