/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.controls.internal;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class CButton
extends Canvas {
    private boolean inButton;
    private Image hotImage;
    private Image coldImage;

    public CButton(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (CButton.this.inButton) {
                    if (CButton.this.hotImage != null) {
                        e.gc.drawImage(CButton.this.hotImage, 0, 0);
                    } else if (CButton.this.coldImage != null) {
                        e.gc.drawImage(CButton.this.coldImage, 0, 0);
                    }
                } else if (CButton.this.coldImage != null) {
                    e.gc.drawImage(CButton.this.coldImage, 0, 0);
                } else if (CButton.this.hotImage != null) {
                    e.gc.drawImage(CButton.this.hotImage, 0, 0);
                }
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                CButton.this.setSelected(true);
            }

            public void mouseExit(MouseEvent e) {
                CButton.this.setSelected(false);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CButton.this.setSelected(true);
                CButton.this.handleSelection(CButton.this.inButton);
            }

            public void mouseDoubleClick(MouseEvent e) {
                CButton.this.setSelected(true);
                CButton.this.handleDefaultSelection(CButton.this.inButton);
            }
        });
    }

    public void dispose() {
        super.dispose();
        if (this.hotImage != null) {
            this.hotImage.dispose();
        }
        if (this.coldImage != null) {
            this.coldImage.dispose();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Rectangle bounds;
        int width = 0;
        int height = 0;
        if (this.hotImage != null) {
            bounds = this.hotImage.getBounds();
            width = bounds.width;
            height = bounds.height;
        }
        if (this.coldImage != null) {
            bounds = this.coldImage.getBounds();
            if (bounds.width > width) {
                width = bounds.width;
            }
            if (bounds.height > height) {
                height = bounds.height;
            }
        }
        return new Point(width, height);
    }

    public void setHotImage(Image image) {
        this.hotImage = image;
    }

    public void setColdImage(Image image) {
        this.coldImage = image;
    }

    protected void handleSelection(boolean selection) {
        this.notifyListeners(13, null);
    }

    protected void handleDefaultSelection(boolean selection) {
        this.notifyListeners(14, null);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void setSelected(boolean sel) {
        this.inButton = sel;
        this.redraw();
    }

    public boolean isSelected() {
        return this.inButton;
    }
}

