/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.eval.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.visualization.eval.preferences.IGuidelineTreeItem;
import org.eclipse.actf.visualization.internal.eval.EvaluationPlugin;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuidelineTreeItemType
implements IGuidelineTreeItem {
    public static final int TYPE_HTML = 10;
    public static final int TYPE_ODF = 11;
    public static final int TYPE_FLASH = 12;
    public int _type;
    private IGuidelineTreeItem _parent = null;
    private List<IGuidelineTreeItem> _children = null;

    GuidelineTreeItemType(int n) {
        this._type = n;
        this._children = new ArrayList<IGuidelineTreeItem>();
    }

    @Override
    public void add(IGuidelineTreeItem iGuidelineTreeItem) {
        this._children.add(iGuidelineTreeItem);
        this._parent = this;
    }

    @Override
    public IGuidelineTreeItem getParent() {
        return this._parent;
    }

    @Override
    public List<IGuidelineTreeItem> getChildren() {
        return this._children;
    }

    public String getTypeStr() {
        switch (this._type) {
            case 10: {
                return "HTML";
            }
            case 11: {
                return "ODF";
            }
            case 12: {
                return "FLASH";
            }
        }
        return "";
    }

    public Image getTypeImage() {
        switch (this._type) {
            case 10: {
                return EvaluationPlugin.getImageDescriptor("icons/media/w3c.png").createImage();
            }
            case 11: {
                return EvaluationPlugin.getImageDescriptor("icons/media/odf.png").createImage();
            }
            case 12: {
                return EvaluationPlugin.getImageDescriptor("icons/media/flash.png").createImage();
            }
        }
        return null;
    }
}

